/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.mocco;

import eva2.gui.MOCCOStandalone;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.mocco.InterfaceProcessElement;
import eva2.optimization.mocco.MOCCOPhase;
import eva2.optimization.mocco.paretofrontviewer.InterfaceRefSolutionListener;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceMultiObjectiveDeNovoProblem;
import eva2.problems.InterfaceOptimizationObjective;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MOCCOChooseReferenceSolution
extends MOCCOPhase
implements InterfaceProcessElement,
InterfaceRefSolutionListener {
    AbstractEAIndividual referenceSolution = null;
    JPanel selected;
    ActionListener continue2 = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            if (MOCCOChooseReferenceSolution.this.referenceSolution != null) {
                MOCCOChooseReferenceSolution.this.mocco.view.setRefSolutionSelectable(false);
                MOCCOChooseReferenceSolution.this.mocco.view.removeRefSolutionSelectionListeners();
                MOCCOChooseReferenceSolution.this.mocco.controlPanel.removeAll();
                MOCCOChooseReferenceSolution.this.mocco.controlPanel.validate();
                MOCCOChooseReferenceSolution.this.mocco.parameterPanel.removeAll();
                MOCCOChooseReferenceSolution.this.hasFinished = true;
            } else {
                JOptionPane.showMessageDialog(MOCCOChooseReferenceSolution.this.mocco.getMainFrame(), "No reference solution selected. Cannot proceed!", "Warning", 2);
            }
        }
    };

    public MOCCOChooseReferenceSolution(MOCCOStandalone mocco) {
        this.mocco = mocco;
    }

    @Override
    public void initProcessElementParametrization() {
        this.mocco.controlPanel.removeAll();
        JButton tmpB = new JButton("Continue to strategy parameterization.");
        tmpB.addActionListener(this.continue2);
        this.mocco.controlPanel.add(tmpB);
        this.mocco.parameterPanel.removeAll();
        this.mocco.parameterPanel.setLayout(new BorderLayout());
        this.mocco.parameterPanel.add((Component)this.makeHelpText("Please choose a reference solution from the Pareto-optimal solutions (grey circles) given to the right."), "North");
        JPanel tmpP = new JPanel();
        tmpP.setLayout(new BorderLayout());
        tmpP.add((Component)new JLabel("Currently selected solution:"), "North");
        this.selected = new JPanel();
        tmpP.add((Component)this.selected, "Center");
        this.updateSelected();
        this.mocco.view.setRefSolutionSelectable(true);
        this.mocco.view.setUniquelySelectable(true);
        this.mocco.view.addRefSolutionSelectionListener(this);
        this.mocco.parameterPanel.add((Component)tmpP, "Center");
        this.mocco.parameterPanel.validate();
        this.mocco.controlPanel.validate();
    }

    private void updateSelected() {
        InterfaceOptimizationObjective[] obj = ((InterfaceMultiObjectiveDeNovoProblem)((Object)this.mocco.state.currentProblem)).getProblemObjectives();
        this.selected.removeAll();
        this.selected.setLayout(new BorderLayout());
        if (this.referenceSolution == null) {
            this.selected.add((Component)new JLabel("Selected Individual: none"), "North");
        } else {
            this.selected.add((Component)new JLabel("Selected Individual: " + this.referenceSolution), "North");
            JPanel tmpP = new JPanel();
            tmpP.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 2.0;
            tmpP.add((Component)new JLabel("Objective:"), gbc);
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            tmpP.add((Component)new JLabel(""), gbc);
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.weightx = 2.0;
            tmpP.add((Component)new JLabel("Value"), gbc);
            for (int i = 0; i < obj.length; ++i) {
                gbc.gridx = 0;
                gbc.gridy = i + 1;
                gbc.weightx = 1.0;
                tmpP.add((Component)new JLabel("" + obj[i].getIdentName()), gbc);
                gbc.gridx = 1;
                gbc.gridy = i + 1;
                gbc.weightx = 1.0;
                JTextField textA = obj[i].is2BMinimized() ? new JTextField("min") : new JTextField("max");
                textA.setEditable(false);
                tmpP.add((Component)textA, gbc);
                gbc.gridx = 2;
                gbc.gridy = i + 1;
                gbc.weightx = 1.0;
                textA = new JTextField("" + this.referenceSolution.getData(obj[i].getIdentName()));
                textA.setEditable(false);
                tmpP.add((Component)textA, gbc);
            }
            this.selected.add((Component)tmpP, "Center");
        }
        this.selected.validate();
    }

    public AbstractEAIndividual getReferenceSolution() {
        return this.referenceSolution;
    }

    @Override
    public void individualSelected(AbstractEAIndividual indy) {
        Population pop = this.mocco.state.paretoFront.getMarkedIndividuals();
        this.referenceSolution = pop.size() == 1 ? (AbstractEAIndividual)pop.get(0) : null;
        this.updateSelected();
    }
}

