/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.mocco;

import eva2.gui.MOCCOStandalone;
import eva2.gui.PropertyDoubleArray;
import eva2.gui.PropertyEditorProvider;
import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.mocco.InterfaceProcessElement;
import eva2.optimization.mocco.MOCCOPhase;
import eva2.optimization.operator.moso.MOSOWeightedFitness;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.strategies.GeneticAlgorithm;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.optimization.tools.AbstractObjectEditor;
import eva2.optimization.tools.GeneralOptimizationEditorProperty;
import eva2.problems.AbstractMultiObjectiveOptimizationProblem;
import eva2.problems.InterfaceMultiObjectiveDeNovoProblem;
import eva2.problems.InterfaceOptimizationObjective;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MOCCOParameterizeGDF
extends MOCCOPhase
implements InterfaceProcessElement {
    private AbstractEAIndividual refSolution;
    private JTextField[][] tradeOffTextFields;
    JPanel choicePanel;
    private InterfaceOptimizer optimizer;
    private GeneralOptimizationEditorProperty optimizationEditorProperty;
    ActionListener weightListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            int i;
            double[] w = new double[MOCCOParameterizeGDF.this.tradeOffTextFields.length];
            double sum = 0.0;
            for (i = 0; i < MOCCOParameterizeGDF.this.tradeOffTextFields.length; ++i) {
                w[i] = Double.parseDouble(MOCCOParameterizeGDF.this.tradeOffTextFields[i][i].getText());
                sum += w[i];
            }
            if (new Double(sum).isNaN()) {
                return;
            }
            for (i = 0; i < MOCCOParameterizeGDF.this.tradeOffTextFields.length; ++i) {
                for (int j = 0; j < MOCCOParameterizeGDF.this.tradeOffTextFields.length; ++j) {
                    if (i == j) continue;
                    MOCCOParameterizeGDF.this.tradeOffTextFields[i][j].setText("" + w[i] / w[j]);
                }
            }
            MOCCOParameterizeGDF.this.choicePanel.validate();
        }
    };
    ActionListener continue2 = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            double[] w = new double[MOCCOParameterizeGDF.this.tradeOffTextFields.length];
            for (int i = 0; i < MOCCOParameterizeGDF.this.tradeOffTextFields.length; ++i) {
                w[i] = Double.parseDouble(MOCCOParameterizeGDF.this.tradeOffTextFields[i][i].getText());
            }
            MOSOWeightedFitness wf = new MOSOWeightedFitness();
            ((AbstractMultiObjectiveOptimizationProblem)MOCCOParameterizeGDF.this.mocco.state.currentProblem).setMOSOConverter(wf);
            w = MOCCOParameterizeGDF.this.mapObjectives2Fitness(w);
            PropertyDoubleArray da = new PropertyDoubleArray(w);
            wf.setOutputDimension(da.getNumRows());
            wf.setWeights(da);
            MOCCOParameterizeGDF.this.optimizer.setProblem(MOCCOParameterizeGDF.this.mocco.state.currentProblem);
            MOCCOParameterizeGDF.this.mocco.state.optimizer = MOCCOParameterizeGDF.this.optimizer;
            MOCCOParameterizeGDF.this.mocco.controlPanel.removeAll();
            MOCCOParameterizeGDF.this.mocco.controlPanel.validate();
            MOCCOParameterizeGDF.this.mocco.parameterPanel.removeAll();
            MOCCOParameterizeGDF.this.mocco.parameterPanel.validate();
            MOCCOParameterizeGDF.this.hasFinished = true;
        }
    };

    public MOCCOParameterizeGDF(MOCCOStandalone mocco) {
        this.mocco = mocco;
    }

    @Override
    public void initProcessElementParametrization() {
        this.mocco.controlPanel.removeAll();
        JButton tmpB = new JButton("Start optimization.");
        tmpB.setToolTipText("Start the adhoc online optimization.");
        tmpB.addActionListener(this.continue2);
        this.mocco.controlPanel.add(tmpB);
        tmpB = new JButton("Save task.");
        tmpB.setToolTipText("Save the optimization problem and algorithm to *.ser file for offline optimization.");
        tmpB.addActionListener(this.saveState2FileForOfflineOptimization);
        this.mocco.controlPanel.add(tmpB);
        this.mocco.parameterPanel.removeAll();
        this.mocco.parameterPanel.setLayout(new BorderLayout());
        this.mocco.parameterPanel.add((Component)this.makeHelpText("Please give weights (white) for the individual objectives, or choose trade-off (gray) between individual objectives. Please note that these values are interdependent."), "North");
        JPanel tmpP = new JPanel();
        tmpP.setLayout(new BorderLayout());
        this.choicePanel = new JPanel();
        tmpP.add((Component)this.choicePanel, "Center");
        this.installChoice();
        this.mocco.parameterPanel.add((Component)tmpP, "Center");
        this.mocco.parameterPanel.validate();
        this.mocco.controlPanel.validate();
    }

    private void installChoice() {
        this.choicePanel.setLayout(new GridBagLayout());
        JPanel panelGDF = new JPanel();
        panelGDF.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Parameterize Perferences:"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        panelGDF.setLayout(new GridBagLayout());
        InterfaceOptimizationObjective[] obj = ((InterfaceMultiObjectiveDeNovoProblem)((Object)this.mocco.state.currentProblem)).getProblemObjectives();
        this.tradeOffTextFields = new JTextField[obj.length][obj.length];
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 1;
        for (int i = 0; i < obj.length; ++i) {
            gbc.gridx = 0;
            gbc.gridy = i;
            gbc.weightx = 2.0;
            panelGDF.add((Component)new JLabel("" + obj[i].getIdentName()), gbc);
            for (int j = 0; j < obj.length; ++j) {
                this.tradeOffTextFields[i][j] = new JTextField("");
                if (i == j) {
                    this.tradeOffTextFields[i][j].setBackground(Color.WHITE);
                    if (obj[i].getOptimizationMode().contains("Objective")) {
                        this.tradeOffTextFields[i][j].setEditable(true);
                    } else {
                        this.tradeOffTextFields[i][j].setEditable(false);
                    }
                    this.tradeOffTextFields[i][j].setText("1.0");
                    this.tradeOffTextFields[i][j].addActionListener(this.weightListener);
                } else {
                    this.tradeOffTextFields[i][j].setBackground(Color.LIGHT_GRAY);
                    this.tradeOffTextFields[i][j].setEditable(false);
                    this.tradeOffTextFields[i][j].setText("0.5");
                }
                gbc.gridx = j + 1;
                gbc.gridy = i;
                gbc.weightx = 1.0;
                panelGDF.add((Component)this.tradeOffTextFields[i][j], gbc);
            }
        }
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridy = 0;
        this.choicePanel.add((Component)panelGDF, gbc);
        gbc.gridwidth = 1;
        this.optimizationEditorProperty = new GeneralOptimizationEditorProperty();
        this.optimizer = new GeneticAlgorithm();
        this.optimizer.setProblem(this.mocco.state.currentProblem);
        this.mocco.state.optimizer = this.optimizer;
        this.optimizationEditorProperty.name = "Island Model EA";
        try {
            this.optimizationEditorProperty.value = this.optimizer;
            this.optimizationEditorProperty.editor = PropertyEditorProvider.findEditor(this.optimizationEditorProperty.value.getClass());
            if (this.optimizationEditorProperty.editor == null) {
                this.optimizationEditorProperty.editor = PropertyEditorProvider.findEditor(InterfaceOptimizer.class);
            }
            if (this.optimizationEditorProperty.editor instanceof GenericObjectEditor) {
                ((GenericObjectEditor)this.optimizationEditorProperty.editor).setClassType(InterfaceOptimizer.class);
            }
            this.optimizationEditorProperty.editor.setValue(this.optimizationEditorProperty.value);
            AbstractObjectEditor.findViewFor(this.optimizationEditorProperty);
            if (this.optimizationEditorProperty.view != null) {
                this.optimizationEditorProperty.view.repaint();
            }
        }
        catch (Exception e) {
            System.out.println("Darn can't read the value...");
        }
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 2.0;
        this.choicePanel.add((Component)new JLabel("" + this.optimizationEditorProperty.name), gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        this.choicePanel.add((Component)this.optimizationEditorProperty.view, gbc);
        GeneralOptimizationEditorProperty editor = new GeneralOptimizationEditorProperty();
        editor.name = "Terminator";
        try {
            editor.value = this.mocco.state.terminator;
            editor.editor = PropertyEditorProvider.findEditor(editor.value.getClass());
            if (editor.editor == null) {
                editor.editor = PropertyEditorProvider.findEditor(InterfaceTerminator.class);
            }
            if (editor.editor instanceof GenericObjectEditor) {
                ((GenericObjectEditor)editor.editor).setClassType(InterfaceTerminator.class);
            }
            editor.editor.setValue(editor.value);
            AbstractObjectEditor.findViewFor(editor);
            if (editor.view != null) {
                editor.view.repaint();
            }
        }
        catch (Exception e) {
            System.out.println("Darn can't read the value...");
        }
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 2.0;
        this.choicePanel.add((Component)new JLabel("" + editor.name), gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        this.choicePanel.add((Component)editor.view, gbc);
    }

    public void setReferenceSolution(AbstractEAIndividual indy) {
        this.refSolution = indy;
    }

    public double[] mapObjectives2Fitness(double[] d) {
        ArrayList<Double> tmpA = new ArrayList<Double>();
        InterfaceOptimizationObjective[] obj = ((InterfaceMultiObjectiveDeNovoProblem)((Object)this.mocco.state.currentProblem)).getProblemObjectives();
        System.out.println("Calling mapObjectives2Fitness");
        System.out.println("obj.length = " + obj.length);
        System.out.println("d.length   = " + d.length);
        for (int i = 0; i < obj.length; ++i) {
            if (!obj[i].getOptimizationMode().contains("Objective")) continue;
            tmpA.add(d[i]);
        }
        double[] result = new double[tmpA.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Double)tmpA.get(i);
        }
        return result;
    }
}

