/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.mocco;

import eva2.gui.MOCCOStandalone;
import eva2.gui.PropertyEditorProvider;
import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.mocco.InterfaceProcessElement;
import eva2.optimization.mocco.MOCCOPhase;
import eva2.optimization.operator.migration.SOBestMigration;
import eva2.optimization.operator.moso.MOSOLpMetric;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.strategies.IslandModelEA;
import eva2.optimization.tools.AbstractObjectEditor;
import eva2.optimization.tools.GeneralOptimizationEditorProperty;
import eva2.problems.AbstractMultiObjectiveOptimizationProblem;
import eva2.tools.math.RNG;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MOCCOParameterizeRefPoint
extends MOCCOPhase
implements InterfaceProcessElement {
    private double[] refPoint;
    private MOSOLpMetric lpMetric;
    private IslandModelEA islandModelEA;
    private GeneralOptimizationEditorProperty optimizationEditorProperty;
    private GeneralOptimizationEditorProperty optimizationEditorProperty1;
    private int perturbations = 4;
    private double perturbation = 0.01;
    private JTextField numPerTextField;
    private JTextField sizePerTextField;
    JPanel parameterPanel;
    ActionListener satisfiedChanged = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
        }
    };
    ActionListener continue2 = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                MOCCOParameterizeRefPoint.this.perturbations = Integer.parseInt(MOCCOParameterizeRefPoint.this.numPerTextField.getText());
            }
            catch (NumberFormatException e) {
                System.out.println("Can't read k.");
            }
            try {
                MOCCOParameterizeRefPoint.this.perturbation = Double.parseDouble(MOCCOParameterizeRefPoint.this.sizePerTextField.getText());
            }
            catch (NumberFormatException e) {
                System.out.println("Can't read amount of perturbation.");
            }
            if (((MOCCOParameterizeRefPoint)MOCCOParameterizeRefPoint.this).optimizationEditorProperty1.value instanceof IslandModelEA) {
                MOCCOParameterizeRefPoint.this.islandModelEA = (IslandModelEA)((MOCCOParameterizeRefPoint)MOCCOParameterizeRefPoint.this).optimizationEditorProperty1.value;
            } else {
                System.out.println("The selected optimizer does not allow heterogenuous multi-starts!");
            }
            if (((MOCCOParameterizeRefPoint)MOCCOParameterizeRefPoint.this).optimizationEditorProperty.value instanceof MOSOLpMetric) {
                MOCCOParameterizeRefPoint.this.lpMetric = (MOSOLpMetric)((MOCCOParameterizeRefPoint)MOCCOParameterizeRefPoint.this).optimizationEditorProperty.value;
            } else {
                System.out.println("The selected MOSO conversion is not suited for the reference point approach!");
            }
            MOCCOParameterizeRefPoint.this.mocco.state.optimizer = MOCCOParameterizeRefPoint.this.islandModelEA;
            MOCCOParameterizeRefPoint.this.mocco.state.optimizer.setProblem(MOCCOParameterizeRefPoint.this.mocco.state.currentProblem);
            MOCCOParameterizeRefPoint.this.islandModelEA.initialize();
            MOSOLpMetric[] tmpLPs = new MOSOLpMetric[MOCCOParameterizeRefPoint.this.perturbations];
            for (int i = 0; i < MOCCOParameterizeRefPoint.this.perturbations; ++i) {
                double[] tmpD = new double[MOCCOParameterizeRefPoint.this.refPoint.length];
                for (int j = 0; j < tmpD.length; ++j) {
                    tmpD[j] = i > 0 ? MOCCOParameterizeRefPoint.this.refPoint[j] + RNG.gaussianDouble(MOCCOParameterizeRefPoint.this.perturbation) : MOCCOParameterizeRefPoint.this.refPoint[j];
                }
                tmpLPs[i] = (MOSOLpMetric)MOCCOParameterizeRefPoint.this.lpMetric.clone();
                ((AbstractMultiObjectiveOptimizationProblem)MOCCOParameterizeRefPoint.this.islandModelEA.getOptimizers()[i].getProblem()).setMOSOConverter(tmpLPs[i]);
                tmpLPs[i].setOutputDimension(tmpD.length);
                tmpLPs[i].getReference().setDoubleArray(tmpD);
            }
            MOCCOParameterizeRefPoint.this.mocco.view.removeReferencePoint();
            MOCCOParameterizeRefPoint.this.mocco.controlPanel.removeAll();
            MOCCOParameterizeRefPoint.this.mocco.controlPanel.validate();
            MOCCOParameterizeRefPoint.this.mocco.parameterPanel.removeAll();
            MOCCOParameterizeRefPoint.this.mocco.parameterPanel.validate();
            MOCCOParameterizeRefPoint.this.hasFinished = true;
        }
    };

    public MOCCOParameterizeRefPoint(MOCCOStandalone mocco) {
        this.mocco = mocco;
    }

    @Override
    public void initProcessElementParametrization() {
        this.mocco.controlPanel.removeAll();
        JButton tmpB = new JButton("Start optimization.");
        tmpB.setToolTipText("Start the adhoc online optimization.");
        tmpB.addActionListener(this.continue2);
        this.mocco.controlPanel.add(tmpB);
        tmpB = new JButton("Save task.");
        tmpB.setToolTipText("Save the optimization problem and algorithm to *.ser file for offline optimization.");
        tmpB.addActionListener(this.saveState2FileForOfflineOptimization);
        this.mocco.controlPanel.add(tmpB);
        this.mocco.parameterPanel.removeAll();
        this.mocco.parameterPanel.setLayout(new BorderLayout());
        this.mocco.parameterPanel.add((Component)this.makeHelpText("Please parameterized the reference point method. Typically this methods generates a set of solutions by using k perturbations of the reference point given. Also the choice of the optimization algorithms and migration rate for the heterogeneuos island model EA is critical. Please note that the server settings will override k!"), "North");
        JPanel tmpP = new JPanel();
        tmpP.setLayout(new BorderLayout());
        this.parameterPanel = new JPanel();
        tmpP.add((Component)this.parameterPanel, "Center");
        this.installChoice();
        this.mocco.parameterPanel.add((Component)tmpP, "Center");
        this.mocco.parameterPanel.validate();
        this.mocco.controlPanel.validate();
    }

    private void installChoice() {
        this.parameterPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 2.0;
        this.parameterPanel.add((Component)new JLabel("Choose number of Perturbations k:"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        this.numPerTextField = new JTextField("" + this.perturbations);
        this.parameterPanel.add((Component)this.numPerTextField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 2.0;
        this.parameterPanel.add((Component)new JLabel("Choose amount of Perturbation:"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        this.sizePerTextField = new JTextField("" + this.perturbation);
        this.parameterPanel.add((Component)this.sizePerTextField, gbc);
        this.optimizationEditorProperty = new GeneralOptimizationEditorProperty();
        this.lpMetric = new MOSOLpMetric();
        this.lpMetric.getReference().setDoubleArray(this.refPoint);
        this.optimizationEditorProperty.name = "Lp-Metric";
        try {
            this.optimizationEditorProperty.value = this.lpMetric;
            this.optimizationEditorProperty.editor = PropertyEditorProvider.findEditor(this.optimizationEditorProperty.value.getClass());
            if (this.optimizationEditorProperty.editor == null) {
                this.optimizationEditorProperty.editor = PropertyEditorProvider.findEditor(MOSOLpMetric.class);
            }
            if (this.optimizationEditorProperty.editor instanceof GenericObjectEditor) {
                ((GenericObjectEditor)this.optimizationEditorProperty.editor).setClassType(MOSOLpMetric.class);
            }
            this.optimizationEditorProperty.editor.setValue(this.optimizationEditorProperty.value);
            AbstractObjectEditor.findViewFor(this.optimizationEditorProperty);
            if (this.optimizationEditorProperty.view != null) {
                this.optimizationEditorProperty.view.repaint();
            }
        }
        catch (Exception e) {
            System.out.println("Darn can't read the value...");
        }
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 2.0;
        this.parameterPanel.add((Component)new JLabel("" + this.optimizationEditorProperty.name), gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        this.parameterPanel.add((Component)this.optimizationEditorProperty.view, gbc);
        this.optimizationEditorProperty1 = new GeneralOptimizationEditorProperty();
        this.islandModelEA = new IslandModelEA();
        this.islandModelEA.setHeterogeneousProblems(true);
        this.islandModelEA.setLocalOnly(true);
        this.islandModelEA.setMigrationRate(2);
        this.islandModelEA.setMigrationStrategy(new SOBestMigration());
        this.islandModelEA.setNumberLocalCPUs(this.perturbations);
        this.islandModelEA.setProblem(this.mocco.state.currentProblem);
        this.mocco.state.optimizer = this.islandModelEA;
        this.optimizationEditorProperty1.name = "Island Model EA";
        try {
            this.optimizationEditorProperty1.value = this.islandModelEA;
            this.optimizationEditorProperty1.editor = PropertyEditorProvider.findEditor(this.optimizationEditorProperty1.value.getClass());
            if (this.optimizationEditorProperty1.editor == null) {
                this.optimizationEditorProperty1.editor = PropertyEditorProvider.findEditor(IslandModelEA.class);
            }
            if (this.optimizationEditorProperty1.editor instanceof GenericObjectEditor) {
                ((GenericObjectEditor)this.optimizationEditorProperty1.editor).setClassType(IslandModelEA.class);
            }
            this.optimizationEditorProperty1.editor.setValue(this.optimizationEditorProperty1.value);
            AbstractObjectEditor.findViewFor(this.optimizationEditorProperty1);
            if (this.optimizationEditorProperty1.view != null) {
                this.optimizationEditorProperty1.view.repaint();
            }
        }
        catch (Exception e) {
            System.out.println("Darn can't read the value...");
        }
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 2.0;
        this.parameterPanel.add((Component)new JLabel("" + this.optimizationEditorProperty1.name), gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        this.parameterPanel.add((Component)this.optimizationEditorProperty1.view, gbc);
        GeneralOptimizationEditorProperty editor = new GeneralOptimizationEditorProperty();
        editor.name = "Terminator";
        try {
            editor.value = this.mocco.state.terminator;
            editor.editor = PropertyEditorProvider.findEditor(editor.value.getClass());
            if (editor.editor == null) {
                editor.editor = PropertyEditorProvider.findEditor(InterfaceTerminator.class);
            }
            if (editor.editor instanceof GenericObjectEditor) {
                ((GenericObjectEditor)editor.editor).setClassType(InterfaceTerminator.class);
            }
            editor.editor.setValue(editor.value);
            AbstractObjectEditor.findViewFor(editor);
            if (editor.view != null) {
                editor.view.repaint();
            }
        }
        catch (Exception e) {
            System.out.println("Darn can't read the value...");
        }
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 2.0;
        this.parameterPanel.add((Component)new JLabel("" + editor.name), gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        this.parameterPanel.add((Component)editor.view, gbc);
    }

    public void setReferencePoint(double[] point) {
        this.refPoint = point;
    }
}

