/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.mocco;

import eva2.gui.MOCCOStandalone;
import eva2.gui.PropertyEditorProvider;
import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.mocco.InterfaceProcessElement;
import eva2.optimization.mocco.MOCCOPhase;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.strategies.GeneticAlgorithm;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.optimization.strategies.MultiObjectiveEA;
import eva2.optimization.tools.AbstractObjectEditor;
import eva2.optimization.tools.GeneralOptimizationEditorProperty;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MOCCOParameterizeSO
extends MOCCOPhase
implements InterfaceProcessElement {
    ActionListener continue2 = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            MOCCOParameterizeSO.this.mocco.controlPanel.removeAll();
            MOCCOParameterizeSO.this.mocco.parameterPanel.removeAll();
            MOCCOParameterizeSO.this.hasFinished = true;
        }
    };

    public MOCCOParameterizeSO(MOCCOStandalone mocco) {
        this.mocco = mocco;
    }

    @Override
    public void initProcessElementParametrization() {
        this.mocco.controlPanel.removeAll();
        JButton tmpB = new JButton("Start optimization.");
        tmpB.setToolTipText("Start the adhoc online optimization.");
        tmpB.addActionListener(this.continue2);
        this.mocco.controlPanel.add(tmpB);
        tmpB = new JButton("Save task.");
        tmpB.setToolTipText("Save the optimization problem and algorithm to *.ser file for offline optimization.");
        tmpB.addActionListener(this.saveState2FileForOfflineOptimization);
        this.mocco.controlPanel.add(tmpB);
        this.init();
        this.mocco.getMainFrame().setVisible(true);
        this.mocco.getMainFrame().validate();
    }

    private void init() {
        if (this.mocco.state.optimizer instanceof MultiObjectiveEA) {
            JOptionPane.showMessageDialog(this.mocco.getMainFrame(), "The current " + this.mocco.state.optimizer.getName() + " is no single-objective optimizer. I'm defaulting to " + "a Genetic Algorithms, please parameterize accordingly.", "Warning", 2);
            this.mocco.state.optimizer = new GeneticAlgorithm();
            this.mocco.state.optimizer.setProblem(this.mocco.state.currentProblem);
        }
        this.mocco.parameterPanel.removeAll();
        this.mocco.parameterPanel.setLayout(new BorderLayout());
        JPanel tmpP = new JPanel();
        tmpP.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 1;
        GeneralOptimizationEditorProperty editor = new GeneralOptimizationEditorProperty();
        editor.name = "Optimizer";
        try {
            editor.value = this.mocco.state.optimizer;
            editor.editor = PropertyEditorProvider.findEditor(editor.value.getClass());
            if (editor.editor == null) {
                editor.editor = PropertyEditorProvider.findEditor(InterfaceOptimizer.class);
            }
            if (editor.editor instanceof GenericObjectEditor) {
                ((GenericObjectEditor)editor.editor).setClassType(InterfaceOptimizer.class);
            }
            editor.editor.setValue(editor.value);
            AbstractObjectEditor.findViewFor(editor);
            if (editor.view != null) {
                editor.view.repaint();
            }
        }
        catch (Exception e) {
            System.out.println("Darn can't read the value...");
        }
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        tmpP.add((Component)new JLabel("" + editor.name), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 2.0;
        tmpP.add((Component)editor.view, gbc);
        editor = new GeneralOptimizationEditorProperty();
        editor.name = "Terminator";
        try {
            editor.value = this.mocco.state.terminator;
            editor.editor = PropertyEditorProvider.findEditor(editor.value.getClass());
            if (editor.editor == null) {
                editor.editor = PropertyEditorProvider.findEditor(InterfaceTerminator.class);
            }
            if (editor.editor instanceof GenericObjectEditor) {
                ((GenericObjectEditor)editor.editor).setClassType(InterfaceTerminator.class);
            }
            editor.editor.setValue(editor.value);
            AbstractObjectEditor.findViewFor(editor);
            if (editor.view != null) {
                editor.view.repaint();
            }
        }
        catch (Exception e) {
            System.out.println("Darn can't read the value...");
        }
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        tmpP.add((Component)new JLabel("" + editor.name), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 2.0;
        tmpP.add((Component)editor.view, gbc);
        this.mocco.parameterPanel.add((Component)tmpP, "Center");
        this.mocco.parameterPanel.add((Component)this.makeInformationText("Single-Objective Optimiaztion", "Please choose an appropriate single-objecitve optimizer."), "North");
    }
}

