/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.mocco;

import eva2.gui.MOCCOStandalone;
import eva2.gui.PropertyDoubleArray;
import eva2.gui.PropertyEditorProvider;
import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.mocco.InterfaceProcessElement;
import eva2.optimization.mocco.MOCCOPhase;
import eva2.optimization.operator.moso.MOSOWeightedFitness;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.strategies.GeneticAlgorithm;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.optimization.tools.AbstractObjectEditor;
import eva2.optimization.tools.GeneralOptimizationEditorProperty;
import eva2.problems.AbstractMultiObjectiveOptimizationProblem;
import eva2.problems.InterfaceMultiObjectiveDeNovoProblem;
import eva2.problems.InterfaceOptimizationObjective;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MOCCOParameterizeSTEP
extends MOCCOPhase
implements InterfaceProcessElement {
    private AbstractEAIndividual refSolution;
    private JTextField[] refSolTextField;
    private JTextField[] relaxTextField;
    private JTextField[] weightTextField;
    private JCheckBox[] satisfied;
    JPanel choicePanel;
    private InterfaceOptimizer optimizer;
    private GeneralOptimizationEditorProperty optimizationEditorProperty;
    ActionListener satisfiedChanged = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            InterfaceOptimizationObjective[] obj = ((InterfaceMultiObjectiveDeNovoProblem)((Object)MOCCOParameterizeSTEP.this.mocco.state.currentProblem)).getProblemObjectives();
            for (int i = 0; i < MOCCOParameterizeSTEP.this.satisfied.length; ++i) {
                if (obj[i].getOptimizationMode().contains("Objective")) {
                    if (MOCCOParameterizeSTEP.this.satisfied[i].isSelected()) {
                        MOCCOParameterizeSTEP.this.relaxTextField[i].setEditable(true);
                        MOCCOParameterizeSTEP.this.weightTextField[i].setEditable(false);
                        continue;
                    }
                    MOCCOParameterizeSTEP.this.relaxTextField[i].setEditable(false);
                    MOCCOParameterizeSTEP.this.weightTextField[i].setEditable(true);
                    continue;
                }
                MOCCOParameterizeSTEP.this.relaxTextField[i].setEditable(false);
                MOCCOParameterizeSTEP.this.weightTextField[i].setEditable(false);
            }
            MOCCOParameterizeSTEP.this.choicePanel.validate();
        }
    };
    ActionListener continue2 = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            InterfaceOptimizationObjective[] obj = ((InterfaceMultiObjectiveDeNovoProblem)((Object)MOCCOParameterizeSTEP.this.mocco.state.currentProblem)).getProblemObjectives();
            double[] weights = new double[MOCCOParameterizeSTEP.this.refSolTextField.length];
            double[] relax = new double[MOCCOParameterizeSTEP.this.refSolTextField.length];
            for (int i = 0; i < MOCCOParameterizeSTEP.this.refSolTextField.length; ++i) {
                weights[i] = Double.parseDouble(MOCCOParameterizeSTEP.this.weightTextField[i].getText());
                relax[i] = Double.parseDouble(MOCCOParameterizeSTEP.this.relaxTextField[i].getText());
                if (MOCCOParameterizeSTEP.this.satisfied[i].isSelected() && obj[i].getOptimizationMode().contains("Objective")) {
                    weights[i] = 0.0;
                    relax[i] = obj[i].is2BMinimized() ? (Double)MOCCOParameterizeSTEP.this.refSolution.getData(obj[i].getIdentName()) + Math.abs(relax[i]) : (Double)MOCCOParameterizeSTEP.this.refSolution.getData(obj[i].getIdentName()) - Math.abs(relax[i]);
                    obj[i].SetConstraintGoal(relax[i]);
                    obj[i].SetOptimizationMode("Constraint");
                    continue;
                }
                relax[i] = 0.0;
            }
            MOSOWeightedFitness wf = new MOSOWeightedFitness();
            ((AbstractMultiObjectiveOptimizationProblem)MOCCOParameterizeSTEP.this.mocco.state.currentProblem).setMOSOConverter(wf);
            double[] setWeights = MOCCOParameterizeSTEP.this.mapObjectives2Fitness(weights);
            PropertyDoubleArray da = new PropertyDoubleArray(setWeights);
            wf.setWeights(da);
            MOCCOParameterizeSTEP.this.optimizer.setProblem(MOCCOParameterizeSTEP.this.mocco.state.currentProblem);
            MOCCOParameterizeSTEP.this.mocco.state.optimizer = MOCCOParameterizeSTEP.this.optimizer;
            MOCCOParameterizeSTEP.this.mocco.controlPanel.removeAll();
            MOCCOParameterizeSTEP.this.mocco.controlPanel.validate();
            MOCCOParameterizeSTEP.this.mocco.parameterPanel.removeAll();
            MOCCOParameterizeSTEP.this.mocco.parameterPanel.validate();
            MOCCOParameterizeSTEP.this.hasFinished = true;
        }
    };

    public MOCCOParameterizeSTEP(MOCCOStandalone mocco) {
        this.mocco = mocco;
    }

    @Override
    public void initProcessElementParametrization() {
        this.mocco.controlPanel.removeAll();
        JButton tmpB = new JButton("Start optimization.");
        tmpB.setToolTipText("Start the adhoc online optimization.");
        tmpB.addActionListener(this.continue2);
        this.mocco.controlPanel.add(tmpB);
        tmpB = new JButton("Save task.");
        tmpB.setToolTipText("Save the optimization problem and algorithm to *.ser file for offline optimization.");
        tmpB.addActionListener(this.saveState2FileForOfflineOptimization);
        this.mocco.controlPanel.add(tmpB);
        this.mocco.parameterPanel.removeAll();
        this.mocco.parameterPanel.setLayout(new BorderLayout());
        this.mocco.parameterPanel.add((Component)this.makeHelpText("Please classify the achieved fitness values in satisfying and unsatisfying results. For the satisfied objectives relaxation-level can be given by which this objective is allowed to worsen. For the unsatisfied objectives weights can be given for weigthed aggregation."), "North");
        JPanel tmpP = new JPanel();
        tmpP.setLayout(new BorderLayout());
        this.choicePanel = new JPanel();
        tmpP.add((Component)this.choicePanel, "Center");
        this.installChoice();
        this.mocco.parameterPanel.add((Component)tmpP, "Center");
        this.mocco.parameterPanel.validate();
        this.mocco.controlPanel.validate();
    }

    private void installChoice() {
        this.choicePanel.setLayout(new GridBagLayout());
        JPanel panelSTEP = new JPanel();
        panelSTEP.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Parameterize Perferences:"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        panelSTEP.setLayout(new GridBagLayout());
        InterfaceOptimizationObjective[] obj = ((InterfaceMultiObjectiveDeNovoProblem)((Object)this.mocco.state.currentProblem)).getProblemObjectives();
        this.refSolTextField = new JTextField[obj.length];
        this.relaxTextField = new JTextField[obj.length];
        this.weightTextField = new JTextField[obj.length];
        this.satisfied = new JCheckBox[obj.length];
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 2.0;
        panelSTEP.add((Component)new JLabel("Objective:"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        panelSTEP.add((Component)new JLabel(""), gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 2.0;
        panelSTEP.add((Component)new JLabel("Value"), gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        panelSTEP.add((Component)new JLabel("Satis.?"), gbc);
        gbc.gridx = 4;
        gbc.gridy = 0;
        panelSTEP.add((Component)new JLabel("Weight"), gbc);
        gbc.gridx = 5;
        gbc.gridy = 0;
        panelSTEP.add((Component)new JLabel("Relax."), gbc);
        for (int i = 0; i < obj.length; ++i) {
            gbc.gridx = 0;
            gbc.gridy = i + 1;
            gbc.weightx = 2.0;
            panelSTEP.add((Component)new JLabel("" + obj[i].getIdentName()), gbc);
            gbc.gridx = 1;
            gbc.gridy = i + 1;
            gbc.weightx = 1.0;
            if (obj[i].is2BMinimized()) {
                panelSTEP.add((Component)new JLabel("min"), gbc);
            } else {
                panelSTEP.add((Component)new JLabel("max"), gbc);
            }
            gbc.gridx = 2;
            gbc.gridy = i + 1;
            this.refSolTextField[i] = new JTextField("" + this.refSolution.getData(obj[i].getIdentName()));
            this.refSolTextField[i].setEditable(false);
            panelSTEP.add((Component)this.refSolTextField[i], gbc);
            gbc.gridx = 3;
            gbc.gridy = i + 1;
            this.satisfied[i] = new JCheckBox();
            this.satisfied[i].addActionListener(this.satisfiedChanged);
            panelSTEP.add((Component)this.satisfied[i], gbc);
            gbc.gridx = 4;
            gbc.gridy = i + 1;
            this.weightTextField[i] = new JTextField("1.0");
            if (obj[i].getOptimizationMode().contains("Objective")) {
                this.weightTextField[i].setEditable(true);
            } else {
                this.weightTextField[i].setEditable(false);
            }
            panelSTEP.add((Component)this.weightTextField[i], gbc);
            gbc.gridx = 5;
            gbc.gridy = i + 1;
            this.relaxTextField[i] = new JTextField("0.0");
            this.relaxTextField[i].setEditable(false);
            panelSTEP.add((Component)this.relaxTextField[i], gbc);
        }
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridy = 0;
        this.choicePanel.add((Component)panelSTEP, gbc);
        gbc.gridwidth = 1;
        this.optimizationEditorProperty = new GeneralOptimizationEditorProperty();
        this.optimizer = new GeneticAlgorithm();
        this.optimizer.setProblem(this.mocco.state.currentProblem);
        this.mocco.state.optimizer = this.optimizer;
        this.optimizationEditorProperty.name = "Island Model EA";
        try {
            this.optimizationEditorProperty.value = this.optimizer;
            this.optimizationEditorProperty.editor = PropertyEditorProvider.findEditor(this.optimizationEditorProperty.value.getClass());
            if (this.optimizationEditorProperty.editor == null) {
                this.optimizationEditorProperty.editor = PropertyEditorProvider.findEditor(InterfaceOptimizer.class);
            }
            if (this.optimizationEditorProperty.editor instanceof GenericObjectEditor) {
                ((GenericObjectEditor)this.optimizationEditorProperty.editor).setClassType(InterfaceOptimizer.class);
            }
            this.optimizationEditorProperty.editor.setValue(this.optimizationEditorProperty.value);
            AbstractObjectEditor.findViewFor(this.optimizationEditorProperty);
            if (this.optimizationEditorProperty.view != null) {
                this.optimizationEditorProperty.view.repaint();
            }
        }
        catch (Exception e) {
            System.out.println("Darn can't read the value...");
        }
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 2.0;
        this.choicePanel.add((Component)new JLabel("" + this.optimizationEditorProperty.name), gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        this.choicePanel.add((Component)this.optimizationEditorProperty.view, gbc);
        GeneralOptimizationEditorProperty editor = new GeneralOptimizationEditorProperty();
        editor.name = "Terminator";
        try {
            editor.value = this.mocco.state.terminator;
            editor.editor = PropertyEditorProvider.findEditor(editor.value.getClass());
            if (editor.editor == null) {
                editor.editor = PropertyEditorProvider.findEditor(InterfaceTerminator.class);
            }
            if (editor.editor instanceof GenericObjectEditor) {
                ((GenericObjectEditor)editor.editor).setClassType(InterfaceTerminator.class);
            }
            editor.editor.setValue(editor.value);
            AbstractObjectEditor.findViewFor(editor);
            if (editor.view != null) {
                editor.view.repaint();
            }
        }
        catch (Exception e) {
            System.out.println("Darn can't read the value...");
        }
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 2.0;
        this.choicePanel.add((Component)new JLabel("" + editor.name), gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        this.choicePanel.add((Component)editor.view, gbc);
    }

    public void setReferenceSolution(AbstractEAIndividual indy) {
        this.refSolution = indy;
    }

    public double[] mapObjectives2Fitness(double[] d) {
        ArrayList<Double> tmpA = new ArrayList<Double>();
        InterfaceOptimizationObjective[] obj = ((InterfaceMultiObjectiveDeNovoProblem)((Object)this.mocco.state.currentProblem)).getProblemObjectives();
        System.out.println("Calling mapObjectives2Fitness");
        System.out.println("obj.length = " + obj.length);
        System.out.println("d.length   = " + d.length);
        for (int i = 0; i < obj.length; ++i) {
            if (!obj[i].getOptimizationMode().contains("Objective")) continue;
            tmpA.add(d[i]);
        }
        double[] result = new double[tmpA.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Double)tmpA.get(i);
        }
        return result;
    }
}

