/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.mocco;

import eva2.gui.MOCCOStandalone;
import eva2.gui.PropertyEditorProvider;
import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.mocco.InterfaceProcessElement;
import eva2.optimization.mocco.MOCCOPhase;
import eva2.optimization.operator.migration.SOBestMigration;
import eva2.optimization.operator.moso.MOSOWeightedLPTchebycheff;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.strategies.IslandModelEA;
import eva2.optimization.tools.AbstractObjectEditor;
import eva2.optimization.tools.GeneralOptimizationEditorProperty;
import eva2.problems.AbstractMultiObjectiveOptimizationProblem;
import eva2.tools.math.RNG;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MOCCOParameterizeTchebycheff
extends MOCCOPhase
implements InterfaceProcessElement {
    private double[] refPoint;
    private IslandModelEA islandModelEA;
    private GeneralOptimizationEditorProperty optimizationEditorProperty;
    private int perturbations = 4;
    private JTextField numPer;
    JPanel parameterPanel;
    private JTextField[] upperLimit;
    private JTextField[] lowerLimit;
    ActionListener continue2 = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                MOCCOParameterizeTchebycheff.this.perturbations = Integer.parseInt(MOCCOParameterizeTchebycheff.this.numPer.getText());
            }
            catch (NumberFormatException e) {
                System.out.println("Can't read k.");
            }
            if (((MOCCOParameterizeTchebycheff)MOCCOParameterizeTchebycheff.this).optimizationEditorProperty.value instanceof IslandModelEA) {
                MOCCOParameterizeTchebycheff.this.islandModelEA = (IslandModelEA)((MOCCOParameterizeTchebycheff)MOCCOParameterizeTchebycheff.this).optimizationEditorProperty.value;
            } else {
                System.out.println("The selected optimizer does not allow heterogenuous multi-starts!");
            }
            MOCCOParameterizeTchebycheff.this.mocco.state.optimizer = MOCCOParameterizeTchebycheff.this.islandModelEA;
            MOCCOParameterizeTchebycheff.this.mocco.state.optimizer.setProblem(MOCCOParameterizeTchebycheff.this.mocco.state.currentProblem);
            MOCCOParameterizeTchebycheff.this.islandModelEA.initialize();
            double sum = 0.0;
            double l = 0.0;
            double u = 1.0;
            MOSOWeightedLPTchebycheff[] tmpLPs = new MOSOWeightedLPTchebycheff[MOCCOParameterizeTchebycheff.this.perturbations];
            for (int i = 0; i < MOCCOParameterizeTchebycheff.this.perturbations; ++i) {
                int j;
                double[] tmpD = new double[MOCCOParameterizeTchebycheff.this.refPoint.length];
                sum = 0.0;
                for (j = 0; j < tmpD.length; ++j) {
                    try {
                        l = Double.parseDouble(MOCCOParameterizeTchebycheff.this.lowerLimit[j].getText());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    try {
                        u = Double.parseDouble(MOCCOParameterizeTchebycheff.this.upperLimit[j].getText());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (l < 0.0) {
                        l = 0.0;
                    }
                    if (u > 1.0) {
                        u = 1.0;
                    }
                    if (u < 0.0) {
                        u = 0.0;
                    }
                    if (l > 1.0) {
                        l = 1.0;
                    }
                    if (u < l) {
                        double t = u;
                        u = l;
                        l = t;
                    }
                    tmpD[j] = i > 0 ? RNG.randomDouble(l, u) : 1.0;
                    sum += tmpD[j];
                }
                j = 0;
                while (j < tmpD.length) {
                    int n = j++;
                    tmpD[n] = tmpD[n] / sum;
                }
                tmpLPs[i] = new MOSOWeightedLPTchebycheff();
                ((AbstractMultiObjectiveOptimizationProblem)MOCCOParameterizeTchebycheff.this.islandModelEA.getOptimizers()[i].getProblem()).setMOSOConverter(tmpLPs[i]);
                tmpLPs[i].setOutputDimension(tmpD.length);
                tmpLPs[i].getIdealPWeights().idealValue = MOCCOParameterizeTchebycheff.this.refPoint;
                tmpLPs[i].getIdealPWeights().weights = tmpD;
            }
            MOCCOParameterizeTchebycheff.this.mocco.view.removeReferencePoint();
            MOCCOParameterizeTchebycheff.this.mocco.controlPanel.removeAll();
            MOCCOParameterizeTchebycheff.this.mocco.controlPanel.validate();
            MOCCOParameterizeTchebycheff.this.mocco.parameterPanel.removeAll();
            MOCCOParameterizeTchebycheff.this.mocco.parameterPanel.validate();
            MOCCOParameterizeTchebycheff.this.hasFinished = true;
        }
    };

    public MOCCOParameterizeTchebycheff(MOCCOStandalone mocco) {
        this.mocco = mocco;
    }

    @Override
    public void initProcessElementParametrization() {
        this.mocco.controlPanel.removeAll();
        JButton tmpB = new JButton("Start optimization.");
        tmpB.setToolTipText("Start the adhoc online optimization.");
        tmpB.addActionListener(this.continue2);
        this.mocco.controlPanel.add(tmpB);
        tmpB = new JButton("Save task.");
        tmpB.setToolTipText("Save the optimization problem and algorithm to *.ser file for offline optimization.");
        tmpB.addActionListener(this.saveState2FileForOfflineOptimization);
        this.mocco.controlPanel.add(tmpB);
        this.mocco.parameterPanel.removeAll();
        this.mocco.parameterPanel.setLayout(new BorderLayout());
        this.mocco.parameterPanel.add((Component)this.makeHelpText("Please parameterized the Tchebycheff method. Typically this methods generates a set of solutions by using k perturbations of the weights used for the weighted Tchebycheff metric. But also the choice of the optimization algorithms and migration rate for the heterogeneuos island model EA is critical. Please note that any server server settings will override k!"), "North");
        JPanel tmpP = new JPanel();
        tmpP.setLayout(new BorderLayout());
        this.parameterPanel = new JPanel();
        tmpP.add((Component)this.parameterPanel, "Center");
        this.installChoice();
        this.mocco.parameterPanel.add((Component)tmpP, "Center");
        this.mocco.parameterPanel.validate();
        this.mocco.controlPanel.validate();
    }

    private void installChoice() {
        this.parameterPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 2.0;
        this.parameterPanel.add((Component)new JLabel("Choose number of Perturbations k:"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        this.numPer = new JTextField("" + this.perturbations);
        this.parameterPanel.add((Component)this.numPer, gbc);
        JComponent tmpP = this.makeLimits4Weigths();
        tmpP.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Choose Weight Bounds (0,1)"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridy = 1;
        gbc.weightx = 2.0;
        this.parameterPanel.add((Component)tmpP, gbc);
        this.optimizationEditorProperty = new GeneralOptimizationEditorProperty();
        this.islandModelEA = new IslandModelEA();
        this.islandModelEA.setHeterogeneousProblems(true);
        this.islandModelEA.setLocalOnly(true);
        this.islandModelEA.setMigrationRate(2);
        this.islandModelEA.setMigrationStrategy(new SOBestMigration());
        this.islandModelEA.setNumberLocalCPUs(this.perturbations);
        this.islandModelEA.setProblem(this.mocco.state.currentProblem);
        this.mocco.state.optimizer = this.islandModelEA;
        this.optimizationEditorProperty.name = "Island Model EA";
        try {
            this.optimizationEditorProperty.value = this.islandModelEA;
            this.optimizationEditorProperty.editor = PropertyEditorProvider.findEditor(this.optimizationEditorProperty.value.getClass());
            if (this.optimizationEditorProperty.editor == null) {
                this.optimizationEditorProperty.editor = PropertyEditorProvider.findEditor(IslandModelEA.class);
            }
            if (this.optimizationEditorProperty.editor instanceof GenericObjectEditor) {
                ((GenericObjectEditor)this.optimizationEditorProperty.editor).setClassType(IslandModelEA.class);
            }
            this.optimizationEditorProperty.editor.setValue(this.optimizationEditorProperty.value);
            AbstractObjectEditor.findViewFor(this.optimizationEditorProperty);
            if (this.optimizationEditorProperty.view != null) {
                this.optimizationEditorProperty.view.repaint();
            }
        }
        catch (Exception e) {
            System.out.println("Darn can't read the value...");
        }
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 2.0;
        this.parameterPanel.add((Component)new JLabel("" + this.optimizationEditorProperty.name), gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        this.parameterPanel.add((Component)this.optimizationEditorProperty.view, gbc);
        GeneralOptimizationEditorProperty editor = new GeneralOptimizationEditorProperty();
        editor.name = "Terminator";
        try {
            editor.value = this.mocco.state.terminator;
            editor.editor = PropertyEditorProvider.findEditor(editor.value.getClass());
            if (editor.editor == null) {
                editor.editor = PropertyEditorProvider.findEditor(InterfaceTerminator.class);
            }
            if (editor.editor instanceof GenericObjectEditor) {
                ((GenericObjectEditor)editor.editor).setClassType(InterfaceTerminator.class);
            }
            editor.editor.setValue(editor.value);
            AbstractObjectEditor.findViewFor(editor);
            if (editor.view != null) {
                editor.view.repaint();
            }
        }
        catch (Exception e) {
            System.out.println("Darn can't read the value...");
        }
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 2.0;
        this.parameterPanel.add((Component)new JLabel("" + editor.name), gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        this.parameterPanel.add((Component)editor.view, gbc);
    }

    private JComponent makeLimits4Weigths() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        this.upperLimit = new JTextField[this.refPoint.length];
        this.lowerLimit = new JTextField[this.refPoint.length];
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        result.add((Component)new JLabel("Objective"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 2.0;
        result.add((Component)new JLabel("Ideal Value"), gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        result.add((Component)new JLabel("Lower"), gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        result.add((Component)new JLabel("Upper"), gbc);
        for (int i = 0; i < this.refPoint.length; ++i) {
            gbc.gridx = 0;
            gbc.gridy = i + 1;
            gbc.weightx = 1.0;
            result.add((Component)new JLabel("Fitness " + i), gbc);
            gbc.gridx = 1;
            gbc.gridy = i + 1;
            gbc.weightx = 2.0;
            result.add((Component)new JLabel("" + this.refPoint[i]), gbc);
            gbc.gridx = 2;
            gbc.gridy = i + 1;
            gbc.weightx = 1.0;
            this.lowerLimit[i] = new JTextField("0.0");
            result.add((Component)this.lowerLimit[i], gbc);
            gbc.gridx = 3;
            gbc.gridy = i + 1;
            this.upperLimit[i] = new JTextField("1.0");
            result.add((Component)this.upperLimit[i], gbc);
        }
        return result;
    }

    public void setReferencePoint(double[] point) {
        this.refPoint = point;
    }
}

