/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.mocco.paretofrontviewer;

import eva2.gui.MOCCOStandalone;
import eva2.gui.plot.FunctionArea;
import eva2.gui.plot.GraphPointSet;
import eva2.gui.plot.InterfaceDPointWithContent;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.mocco.paretofrontviewer.InterfaceParetoFrontView;
import eva2.optimization.mocco.paretofrontviewer.InterfaceRefPointListener;
import eva2.optimization.mocco.paretofrontviewer.InterfaceRefSolutionListener;
import eva2.optimization.mocco.paretofrontviewer.ParetoFrontView2D;
import eva2.optimization.mocco.paretofrontviewer.ParetoFrontViewParallelAxis;
import eva2.optimization.mocco.paretofrontviewer.ParetoFrontViewScatterPlot;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceMultiObjectiveDeNovoProblem;
import eva2.problems.InterfaceOptimizationObjective;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DPointContentSelectable;
import eva2.tools.chart2d.ScaledBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MOCCOViewer
extends JPanel
implements InterfaceRefSolutionListener,
InterfaceRefPointListener {
    public MOCCOStandalone moccoStandalone;
    public MOCCOViewer instance;
    private InterfaceParetoFrontView paretoFrontView;
    private FunctionArea functionAre;
    public JPanel viewPanel;
    public JPanel choicesPanel;
    private InterfaceRefSolutionListener refSolutionListener;
    private InterfaceRefPointListener refPointListener;
    public double[] referencePoint = null;
    public boolean selectUniqueSolution = true;
    public boolean refPointSelectable = false;
    public boolean refSolutionSelectable = false;
    ActionListener paretoFrontViewChanged = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            JComboBox tmpC = (JComboBox)event.getSource();
            int index = tmpC.getSelectedIndex();
            switch (index) {
                case 0: {
                    MOCCOViewer.this.viewPanel.removeAll();
                    MOCCOViewer.this.paretoFrontView = new ParetoFrontView2D(MOCCOViewer.this.instance);
                    MOCCOViewer.this.viewPanel.add((Component)((JPanel)((Object)MOCCOViewer.this.paretoFrontView)), "Center");
                    break;
                }
                case 1: {
                    MOCCOViewer.this.viewPanel.removeAll();
                    MOCCOViewer.this.paretoFrontView = new ParetoFrontViewScatterPlot(MOCCOViewer.this.instance);
                    MOCCOViewer.this.viewPanel.add((Component)((JPanel)((Object)MOCCOViewer.this.paretoFrontView)), "Center");
                    break;
                }
                case 2: {
                    MOCCOViewer.this.viewPanel.removeAll();
                    MOCCOViewer.this.paretoFrontView = new ParetoFrontViewParallelAxis(MOCCOViewer.this.instance);
                    MOCCOViewer.this.viewPanel.add((Component)((JPanel)((Object)MOCCOViewer.this.paretoFrontView)), "Center");
                    break;
                }
                case 3: {
                    MOCCOViewer.this.viewPanel.removeAll();
                    MOCCOViewer.this.paretoFrontView = ((InterfaceMultiObjectiveDeNovoProblem)((Object)MOCCOViewer.this.moccoStandalone.state.currentProblem)).getParetoFrontViewer4MOCCO(MOCCOViewer.this.instance);
                    MOCCOViewer.this.viewPanel.add((Component)((JComponent)((Object)MOCCOViewer.this.paretoFrontView)), "Center");
                }
            }
            MOCCOViewer.this.viewPanel.updateUI();
        }
    };
    ActionListener saveParetoFront = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            double[] fit;
            SimpleDateFormat formatter = new SimpleDateFormat("E'_'yyyy.MM.dd'_'HH.mm.ss");
            String startDate = formatter.format(new Date());
            BufferedWriter out = null;
            String name = "MOCCO_" + startDate + "_PF_Iteration_" + MOCCOViewer.this.moccoStandalone.iteration + ".dat";
            Population pop = MOCCOViewer.this.moccoStandalone.state.paretoFront;
            try {
                out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(name)));
            }
            catch (FileNotFoundException e) {
                System.out.println("Could not open output file! Filename: " + name);
                return;
            }
            InterfaceOptimizationObjective[] obj = ((InterfaceMultiObjectiveDeNovoProblem)((Object)MOCCOViewer.this.moccoStandalone.state.currentProblem)).getProblemObjectives();
            String tmp = "";
            for (int j = 0; j < obj.length; ++j) {
                tmp = tmp + obj[j].getIdentName() + "\t";
            }
            try {
                out.write(tmp + "\n");
            }
            catch (IOException e) {
                // empty catch block
            }
            for (int i = 0; i < pop.size(); ++i) {
                if (((AbstractEAIndividual)pop.get(i)).violatesConstraint()) continue;
                tmp = "";
                fit = ((AbstractEAIndividual)pop.get(i)).getFitness();
                for (int j = 0; j < fit.length; ++j) {
                    tmp = tmp + fit[j] + "\t";
                }
                try {
                    out.write(tmp + "\n");
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            name = "MOCCO_" + startDate + "_All_Iteration_" + MOCCOViewer.this.moccoStandalone.iteration + ".dat";
            try {
                out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(name)));
            }
            catch (FileNotFoundException e) {
                System.out.println("Could not open output file! Filename: " + name);
                return;
            }
            pop = new Population();
            for (int i = 0; i < MOCCOViewer.this.moccoStandalone.state.populationHistory.length; ++i) {
                pop.addPopulation(MOCCOViewer.this.moccoStandalone.state.populationHistory[i]);
            }
            obj = ((InterfaceMultiObjectiveDeNovoProblem)((Object)MOCCOViewer.this.moccoStandalone.state.currentProblem)).getProblemObjectives();
            tmp = "";
            for (int j = 0; j < obj.length; ++j) {
                tmp = tmp + obj[j].getIdentName() + "\t";
            }
            try {
                out.write(tmp + "\n");
            }
            catch (IOException e) {
                // empty catch block
            }
            for (int i = 0; i < pop.size(); ++i) {
                if (((AbstractEAIndividual)pop.get(i)).violatesConstraint()) continue;
                tmp = "";
                fit = ((AbstractEAIndividual)pop.get(i)).getFitness();
                for (int j = 0; j < fit.length; ++j) {
                    tmp = tmp + fit[j] + "\t";
                }
                try {
                    out.write(tmp + "\n");
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            name = "MOCCO_" + startDate + "_Infeasible_Iteration_" + MOCCOViewer.this.moccoStandalone.iteration + ".dat";
            try {
                out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(name)));
            }
            catch (FileNotFoundException e) {
                System.out.println("Could not open output file! Filename: " + name);
                return;
            }
            pop = new Population();
            for (int i = 0; i < MOCCOViewer.this.moccoStandalone.state.populationHistory.length; ++i) {
                pop.addPopulation(MOCCOViewer.this.moccoStandalone.state.populationHistory[i]);
            }
            obj = ((InterfaceMultiObjectiveDeNovoProblem)((Object)MOCCOViewer.this.moccoStandalone.state.currentProblem)).getProblemObjectives();
            tmp = "";
            for (int j = 0; j < obj.length; ++j) {
                tmp = tmp + obj[j].getIdentName() + "\t";
            }
            try {
                out.write(tmp + "\n");
            }
            catch (IOException e) {
                // empty catch block
            }
            for (int i = 0; i < pop.size(); ++i) {
                if (!((AbstractEAIndividual)pop.get(i)).violatesConstraint()) continue;
                tmp = "";
                fit = ((AbstractEAIndividual)pop.get(i)).getFitness();
                for (int j = 0; j < fit.length; ++j) {
                    tmp = tmp + fit[j] + "\t";
                }
                try {
                    out.write(tmp + "\n");
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            name = "MOCCO_" + startDate + "_RefSolutions_Iteration_" + MOCCOViewer.this.moccoStandalone.iteration + ".dat";
            try {
                out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(name)));
            }
            catch (FileNotFoundException e) {
                System.out.println("Could not open output file! Filename: " + name);
                return;
            }
            pop = MOCCOViewer.this.moccoStandalone.state.paretoFront.getMarkedIndividuals();
            obj = ((InterfaceMultiObjectiveDeNovoProblem)((Object)MOCCOViewer.this.moccoStandalone.state.currentProblem)).getProblemObjectives();
            tmp = "";
            for (int j = 0; j < obj.length; ++j) {
                tmp = tmp + obj[j].getIdentName() + "\t";
            }
            try {
                out.write(tmp + "\n");
            }
            catch (IOException e) {
                // empty catch block
            }
            for (int i = 0; i < pop.size(); ++i) {
                tmp = "";
                fit = ((AbstractEAIndividual)pop.get(i)).getFitness();
                for (int j = 0; j < fit.length; ++j) {
                    tmp = tmp + fit[j] + "\t";
                }
                try {
                    out.write(tmp + "\n");
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            name = "MOCCO_" + startDate + "_RefPoint_Iteration_" + MOCCOViewer.this.moccoStandalone.iteration + ".dat";
            try {
                out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(name)));
            }
            catch (FileNotFoundException e) {
                System.out.println("Could not open output file! Filename: " + name);
                return;
            }
            pop = MOCCOViewer.this.moccoStandalone.state.paretoFront.getMarkedIndividuals();
            obj = ((InterfaceMultiObjectiveDeNovoProblem)((Object)MOCCOViewer.this.moccoStandalone.state.currentProblem)).getProblemObjectives();
            tmp = "";
            for (int j = 0; j < obj.length; ++j) {
                tmp = tmp + obj[j].getIdentName() + "\t";
            }
            try {
                out.write(tmp + "\n");
            }
            catch (IOException e) {
                // empty catch block
            }
            tmp = "";
            if (MOCCOViewer.this.referencePoint != null) {
                for (int j = 0; j < MOCCOViewer.this.referencePoint.length; ++j) {
                    tmp = tmp + MOCCOViewer.this.referencePoint[j] + "\t";
                }
                try {
                    out.write(tmp + "\n");
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    };

    public MOCCOViewer(MOCCOStandalone t) {
        this.moccoStandalone = t;
        this.instance = this;
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.viewPanel = new JPanel();
        this.viewPanel.setLayout(new BorderLayout());
        this.paretoFrontView = new ParetoFrontView2D(this);
        this.viewPanel.add((Component)((JPanel)((Object)this.paretoFrontView)), "Center");
        this.choicesPanel = new JPanel();
        JPanel tmpP = new JPanel();
        this.choicesPanel.setLayout(new GridLayout(1, 2));
        this.choicesPanel.add(tmpP);
        tmpP.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        tmpP.add((Component)new JLabel("Choose View:"), gbc);
        String[] tmpList = new String[]{"2D Pareto Front", "Scatter Plot"};
        JComboBox<String> tmpC = new JComboBox<String>(tmpList);
        tmpC.setSelectedIndex(0);
        tmpC.addActionListener(this.paretoFrontViewChanged);
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 3.0;
        tmpP.add(tmpC, gbc);
        JButton JBSaveParetoFront = new JButton("Save Pareto Front");
        JBSaveParetoFront.addActionListener(this.saveParetoFront);
        this.choicesPanel.add(JBSaveParetoFront);
        this.add((Component)this.viewPanel, "Center");
        this.add((Component)this.choicesPanel, "South");
    }

    public void problemChanged(boolean t) {
        this.moccoStandalone.state.makeFitnessCache(t);
        if (this.moccoStandalone.state.currentProblem.isMultiObjective()) {
            if (this.functionAre != null) {
                this.viewPanel.removeAll();
                this.viewPanel.add((Component)((JPanel)((Object)this.paretoFrontView)), "Center");
            }
            this.paretoFrontView.updateView();
            this.functionAre = null;
        } else {
            if (this.functionAre == null) {
                this.viewPanel.removeAll();
                this.viewPanel.setLayout(new BorderLayout());
                this.functionAre = new FunctionArea("?", "?");
                this.functionAre.setPreferredSize(new Dimension(450, 450));
                this.functionAre.setMinimumSize(new Dimension(450, 450));
                ScaledBorder areaBorder = new ScaledBorder();
                areaBorder.xLabel = "Optimzation Step";
                areaBorder.yLabel = "Fitness";
                this.functionAre.setBorder(areaBorder);
                this.functionAre.setBackground(Color.WHITE);
                this.viewPanel.add((Component)this.functionAre, "Center");
            }
            this.plot1DFitnessPlot();
        }
    }

    public void plot1DFitnessPlot() {
        double xmin = 0.0;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        Population[] pops = this.moccoStandalone.state.populationHistory;
        if (pops == null || pops.length < 1) {
            return;
        }
        this.functionAre.removeAll();
        GraphPointSet mySet = new GraphPointSet(1, this.functionAre);
        mySet.setConnectedMode(true);
        mySet.setColor(Color.BLACK);
        for (int i = 0; i < pops.length; ++i) {
            double fitness = pops[i].getBestEAIndividual().getFitness()[0];
            DPoint myPoint = new DPoint(i + 1, fitness);
            DPointContentSelectable icon = new DPointContentSelectable();
            ((InterfaceDPointWithContent)icon).setProblem(this.moccoStandalone.state.currentProblem);
            ((InterfaceDPointWithContent)icon).setEAIndividual(pops[i].getBestEAIndividual());
            myPoint.setIcon(icon);
            mySet.addDPoint(myPoint);
            if (fitness < ymin) {
                ymin = fitness;
            }
            if (!(fitness > ymax)) continue;
            ymax = fitness;
        }
        mySet = new GraphPointSet(2, this.functionAre);
        mySet.setConnectedMode(false);
        double yrange = ymax - ymin;
        if (yrange < 1.0E-5) {
            yrange = 1.0E-5;
        }
        mySet.addDPoint(0.0, ymin - 0.1 * yrange);
        mySet.addDPoint(pops.length + 2, ymax + 0.1 * yrange);
        this.viewPanel.validate();
    }

    @Override
    public void individualSelected(AbstractEAIndividual indy) {
        if (indy.isMarked()) {
            indy.setMarked(false);
        } else {
            if (this.selectUniqueSolution) {
                this.moccoStandalone.state.paretoFront.unmarkAllIndividuals();
            }
            indy.setMarked(true);
        }
        this.paretoFrontView.updateView();
        if (this.refSolutionListener != null) {
            this.refSolutionListener.individualSelected(indy);
        }
    }

    public void setUniquelySelectable(boolean t) {
        this.selectUniqueSolution = t;
    }

    public void setRefSolutionSelectable(boolean t) {
        this.refSolutionSelectable = t;
        this.paretoFrontView.updateView();
    }

    public void addRefSolutionSelectionListener(InterfaceRefSolutionListener a) {
        this.refSolutionListener = a;
    }

    public InterfaceRefSolutionListener getRefSolutionSelectionListener() {
        return this.refSolutionListener;
    }

    public void removeRefSolutionSelectionListeners() {
        this.refSolutionListener = null;
    }

    @Override
    public void refPointGiven(double[] point) {
        this.referencePoint = point;
        if (this.refPointListener != null) {
            this.refPointListener.refPointGiven(point);
        }
        this.paretoFrontView.updateView();
    }

    public void setRefPointSelectable(boolean t) {
        this.refPointSelectable = t;
        if (this.refPointSelectable) {
            int dim = ((AbstractEAIndividual)this.moccoStandalone.state.paretoFront.get(0)).getFitness().length;
            this.referencePoint = new double[dim];
            for (int i = 0; i < dim; ++i) {
                this.referencePoint[i] = 0.0;
            }
        }
        this.paretoFrontView.updateView();
    }

    public void removeReferencePoint() {
        this.referencePoint = null;
    }

    public void addRefPointSelectionListener(InterfaceRefPointListener a) {
        this.refPointListener = a;
    }

    public InterfaceRefPointListener getRefPointSelectionListener() {
        return this.refPointListener;
    }

    public void removeRefPointSelectionListeners() {
        this.refPointListener = null;
        this.paretoFrontView.updateView();
    }
}

