/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.mocco.paretofrontviewer;

import eva2.gui.plot.FunctionArea;
import eva2.gui.plot.GraphPointSet;
import eva2.gui.plot.InterfaceDPointWithContent;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.mocco.paretofrontviewer.InterfaceParetoFrontView;
import eva2.optimization.mocco.paretofrontviewer.InterfaceRefPointListener;
import eva2.optimization.mocco.paretofrontviewer.MOCCOViewer;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceMultiObjectiveDeNovoProblem;
import eva2.problems.InterfaceOptimizationObjective;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DPointContentSelectable;
import eva2.tools.chart2d.ScaledBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ParetoFrontView2D
extends JPanel
implements InterfaceParetoFrontView,
InterfaceRefPointListener {
    public MOCCOViewer moccoViewer;
    private JPanel mainPanel;
    private JPanel topPanel;
    private JComboBox objective1;
    private JComboBox objective2;
    private JComboBox fitObjective;
    private FunctionArea functionArea;
    private ScaledBorder areaBorder;
    private InterfaceRefPointListener refPointListener;
    ActionListener jcomboboxListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            ParetoFrontView2D.this.updateView();
        }
    };
    ActionListener jcombobox2Listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            ParetoFrontView2D.this.updateObjectiveComboBoxes();
        }
    };

    public ParetoFrontView2D(MOCCOViewer t) {
        this.moccoViewer = t;
        this.init();
    }

    private void init() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
        this.functionArea = new FunctionArea("?", "?");
        this.functionArea.setPreferredSize(new Dimension(450, 450));
        this.functionArea.setMinimumSize(new Dimension(450, 450));
        this.areaBorder = new ScaledBorder();
        this.areaBorder.xLabel = "?";
        this.areaBorder.yLabel = "?";
        this.functionArea.setBorder(this.areaBorder);
        this.functionArea.setBackground(Color.WHITE);
        this.mainPanel.add((Component)this.functionArea, "Center");
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new GridLayout(1, 5));
        String[] tmp = new String[]{"Fitness", "Objective"};
        this.fitObjective = new JComboBox<String>(tmp);
        this.fitObjective.setSelectedIndex(0);
        this.fitObjective.addActionListener(this.jcombobox2Listener);
        this.objective1 = new JComboBox<String>(this.getAvailableObjectiveNames());
        this.objective1.setSelectedIndex(0);
        this.objective1.addActionListener(this.jcomboboxListener);
        this.topPanel.add(this.objective1);
        this.topPanel.add(new JLabel(" vs "));
        this.objective2 = new JComboBox<String>(this.getAvailableObjectiveNames());
        try {
            this.objective2.setSelectedIndex(1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.objective2.addActionListener(this.jcomboboxListener);
        this.topPanel.add(this.objective2);
        this.topPanel.add(new JLabel(" using:"));
        this.topPanel.add(this.fitObjective);
        this.mainPanel.add((Component)this.topPanel, "North");
        this.updateView();
    }

    public void updateObjectiveComboBoxes() {
        int i;
        this.objective1.removeActionListener(this.jcomboboxListener);
        this.objective2.removeActionListener(this.jcomboboxListener);
        this.objective1.removeAllItems();
        String[] tmpS = this.getAvailableObjectiveNames();
        for (i = 0; i < tmpS.length; ++i) {
            this.objective1.addItem(tmpS[i]);
        }
        this.objective1.setSelectedIndex(0);
        this.objective2.removeAllItems();
        tmpS = this.getAvailableObjectiveNames();
        for (i = 0; i < tmpS.length; ++i) {
            this.objective2.addItem(tmpS[i]);
        }
        this.objective2.setSelectedIndex(1);
        this.objective1.addActionListener(this.jcomboboxListener);
        this.objective2.addActionListener(this.jcomboboxListener);
        this.updateView();
    }

    private String[] getAvailableObjectiveNames() {
        String[] result = null;
        if (this.moccoViewer.moccoStandalone.state.currentProblem == null) {
            result = new String[]{"none"};
            return result;
        }
        if (this.moccoViewer.moccoStandalone.state.currentProblem instanceof InterfaceMultiObjectiveDeNovoProblem) {
            InterfaceOptimizationObjective[] tmp = ((InterfaceMultiObjectiveDeNovoProblem)((Object)this.moccoViewer.moccoStandalone.state.currentProblem)).getProblemObjectives();
            result = new String[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                result[i] = tmp[i].getIdentName();
            }
            if (this.fitObjective.getSelectedIndex() == 0) {
                int i;
                ArrayList<String> tmpList = new ArrayList<String>();
                for (i = 0; i < tmp.length; ++i) {
                    if (tmp[i].getOptimizationMode().equalsIgnoreCase("Constraint")) continue;
                    tmpList.add(result[i]);
                }
                result = new String[tmpList.size()];
                for (i = 0; i < tmpList.size(); ++i) {
                    result[i] = (String)tmpList.get(i);
                }
            }
        }
        return result;
    }

    @Override
    public void updateView() {
        this.functionArea.removeAll();
        String[] tmpS = this.getAvailableObjectiveNames();
        if (tmpS.length != this.objective1.getItemCount()) {
            this.updateObjectiveComboBoxes();
        }
        boolean equal = true;
        for (int i = 0; i < tmpS.length; ++i) {
            if (tmpS[i].equalsIgnoreCase((String)this.objective1.getItemAt(i))) continue;
            equal = false;
        }
        if (!equal) {
            this.updateObjectiveComboBoxes();
        }
        if (this.moccoViewer.moccoStandalone.state.currentProblem instanceof InterfaceMultiObjectiveDeNovoProblem) {
            String[] objectives = this.getAvailableObjectiveNames();
            this.areaBorder.xLabel = "" + objectives[this.objective1.getSelectedIndex()];
            this.areaBorder.yLabel = "" + objectives[this.objective2.getSelectedIndex()];
        }
        if (this.moccoViewer.moccoStandalone.state.paretoFront != null && this.moccoViewer.moccoStandalone.state.paretoFront.size() > 0) {
            this.plot2DParetoFront();
        }
        this.validate();
    }

    public void plot2DParetoFront() {
        GraphPointSet mySet;
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        this.functionArea.clearAll();
        this.functionArea.setBackground(Color.WHITE);
        int indexX = this.objective1.getSelectedIndex();
        int indexY = this.objective2.getSelectedIndex();
        Population pf = this.moccoViewer.moccoStandalone.state.paretoFront;
        if (pf.size() > 0) {
            mySet = new GraphPointSet(1, this.functionArea);
            mySet.setConnectedMode(false);
            mySet.setColor(Color.BLACK);
            for (int i = 0; i < pf.size(); ++i) {
                double[] fitness;
                if (this.fitObjective.getSelectedIndex() == 0) {
                    fitness = ((AbstractEAIndividual)pf.get(i)).getFitness();
                } else {
                    InterfaceOptimizationObjective[] tmpObj = ((InterfaceMultiObjectiveDeNovoProblem)((Object)this.moccoViewer.moccoStandalone.state.currentProblem)).getProblemObjectives();
                    fitness = new double[tmpObj.length];
                    for (int k = 0; k < tmpObj.length; ++k) {
                        fitness[k] = (Double)((AbstractEAIndividual)pf.get(i)).getData(tmpObj[k].getIdentName());
                    }
                }
                DPoint point = new DPoint(fitness[indexX], fitness[indexY]);
                DPointContentSelectable icon = new DPointContentSelectable();
                if (this.moccoViewer.refSolutionSelectable) {
                    icon.addSelectionListener(this.moccoViewer);
                }
                ((InterfaceDPointWithContent)icon).setProblem(this.moccoViewer.moccoStandalone.state.currentProblem);
                ((InterfaceDPointWithContent)icon).setEAIndividual((AbstractEAIndividual)pf.get(i));
                point.setIcon(icon);
                mySet.addDPoint(point);
                if (fitness[indexX] < xmin) {
                    xmin = fitness[indexX];
                }
                if (fitness[indexX] > xmax) {
                    xmax = fitness[indexX];
                }
                if (fitness[indexY] < ymin) {
                    ymin = fitness[indexY];
                }
                if (!(fitness[indexY] > ymax)) continue;
                ymax = fitness[indexY];
            }
        }
        mySet = new GraphPointSet(0, this.functionArea);
        mySet.setConnectedMode(false);
        double xrange = xmax - xmin;
        double yrange = ymax - ymin;
        if (new Double(xrange).isNaN()) {
            mySet.addDPoint(0.0, 0.0);
            mySet.addDPoint(1.0, 1.0);
        } else {
            mySet.addDPoint(xmin - 0.1 * xrange, ymin - 0.1 * yrange);
            mySet.addDPoint(xmin - 0.1 * xrange, ymin - 0.1 * yrange);
            mySet.addDPoint(xmax + 0.1 * xrange, ymax + 0.1 * yrange);
            mySet.addDPoint(xmax + 0.1 * xrange, ymax + 0.1 * yrange);
        }
        if (this.moccoViewer.moccoStandalone.state.currentProblem instanceof InterfaceMultiObjectiveDeNovoProblem && this.fitObjective.getSelectedIndex() == 1) {
            InterfaceOptimizationObjective[] tmp = ((InterfaceMultiObjectiveDeNovoProblem)((Object)this.moccoViewer.moccoStandalone.state.currentProblem)).getProblemObjectives();
            for (int i = 0; i < tmp.length; ++i) {
                double tmpD;
                if (tmp[i].getOptimizationMode().equalsIgnoreCase("Objective") || this.objective1.getSelectedIndex() != i && this.objective2.getSelectedIndex() != i || new Double(tmpD = tmp[i].getConstraintGoal()).isNaN()) continue;
                mySet = new GraphPointSet(500 + i, this.functionArea);
                mySet.setConnectedMode(true);
                if (this.objective1.getSelectedIndex() == i) {
                    if (!(tmpD > xmin - 0.1 * xrange) || !(tmpD < xmax + 0.1 * xrange)) continue;
                    mySet.addDPoint(tmpD, ymin - 0.1 * yrange);
                    mySet.addDPoint(tmpD, ymin - 0.1 * yrange);
                    mySet.addDPoint(tmpD, ymax + 0.1 * yrange);
                    mySet.addDPoint(tmpD, ymax + 0.1 * yrange);
                    continue;
                }
                if (!(tmpD > ymin - 0.1 * yrange) || !(tmpD < ymax + 0.1 * yrange)) continue;
                mySet.addDPoint(xmin - 0.1 * xrange, tmpD);
                mySet.addDPoint(xmin - 0.1 * xrange, tmpD);
                mySet.addDPoint(xmax + 0.1 * xrange, tmpD);
                mySet.addDPoint(xmax + 0.1 * xrange, tmpD);
            }
        }
        if (this.moccoViewer.refPointSelectable) {
            this.functionArea.addRefPointSelectionListener(this);
        } else {
            this.functionArea.removeRefPointSelectionListeners();
            this.removeRefPointSelectionListeners();
        }
        if (this.moccoViewer.referencePoint != null && this.fitObjective.getSelectedIndex() == 0) {
            mySet = new GraphPointSet(1001, this.functionArea);
            mySet.setConnectedMode(true);
            mySet.setColor(Color.RED);
            double tmpD = this.moccoViewer.referencePoint[this.objective1.getSelectedIndex()];
            if (tmpD > xmin - 0.1 * xrange && tmpD < xmax + 0.1 * xrange) {
                mySet.addDPoint(tmpD, ymin - 0.1 * yrange);
                mySet.addDPoint(tmpD, ymin - 0.1 * yrange);
                mySet.addDPoint(tmpD, ymax + 0.1 * yrange);
                mySet.addDPoint(tmpD, ymax + 0.1 * yrange);
            }
            mySet = new GraphPointSet(1002, this.functionArea);
            mySet.setConnectedMode(true);
            mySet.setColor(Color.RED);
            tmpD = this.moccoViewer.referencePoint[this.objective2.getSelectedIndex()];
            if (tmpD > ymin - 0.1 * yrange && tmpD < ymax + 0.1 * yrange) {
                mySet.addDPoint(xmin - 0.1 * xrange, tmpD);
                mySet.addDPoint(xmin - 0.1 * xrange, tmpD);
                mySet.addDPoint(xmax + 0.1 * xrange, tmpD);
                mySet.addDPoint(xmax + 0.1 * xrange, tmpD);
            }
        }
    }

    @Override
    public void refPointGiven(double[] point) {
        if (this.fitObjective.getSelectedIndex() == 1) {
            JOptionPane.showMessageDialog(this.moccoViewer.moccoStandalone.getMainFrame(), "Reference point needs to be selected in fitness space!", "Warning", 2);
        } else {
            double[] tmpD = this.moccoViewer.referencePoint;
            tmpD[this.objective1.getSelectedIndex()] = point[0];
            tmpD[this.objective2.getSelectedIndex()] = point[1];
            this.moccoViewer.refPointGiven(tmpD);
        }
    }

    public void addRefPointSelectionListener(InterfaceRefPointListener a) {
        this.refPointListener = a;
    }

    public InterfaceRefPointListener getRefPointSelectionListener() {
        return this.refPointListener;
    }

    public void removeRefPointSelectionListeners() {
        this.refPointListener = null;
    }
}

