/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.mocco.paretofrontviewer;

import eva2.optimization.mocco.paretofrontviewer.InterfaceParetoFrontView;
import eva2.optimization.mocco.paretofrontviewer.InterfaceRefPointListener;
import eva2.optimization.mocco.paretofrontviewer.MOCCOViewer;
import eva2.optimization.mocco.paretofrontviewer.SimpleView;
import eva2.problems.InterfaceMultiObjectiveDeNovoProblem;
import eva2.problems.InterfaceOptimizationObjective;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ParetoFrontViewScatterPlot
extends JPanel
implements InterfaceParetoFrontView {
    public MOCCOViewer moccoViewer;
    private JPanel mainPanel;
    private JPanel centerPanel;
    private JPanel topPanel;
    public JComboBox fitnessObjectiveComboBox;
    private InterfaceRefPointListener refPointListener;
    private SimpleView[][] simpleViews;
    ActionListener jcomboboxListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            ParetoFrontViewScatterPlot.this.updateView();
        }
    };

    public ParetoFrontViewScatterPlot(MOCCOViewer t) {
        this.moccoViewer = t;
        this.init();
    }

    private void init() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
        this.centerPanel = new JPanel();
        this.mainPanel.add((Component)new JScrollPane(this.centerPanel), "Center");
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new GridLayout(1, 2));
        String[] tmp = new String[]{"Fitness", "Objective"};
        this.fitnessObjectiveComboBox = new JComboBox<String>(tmp);
        this.fitnessObjectiveComboBox.setSelectedIndex(0);
        this.fitnessObjectiveComboBox.addActionListener(this.jcomboboxListener);
        this.topPanel.add(new JLabel("Showing:"));
        this.topPanel.add(this.fitnessObjectiveComboBox);
        this.mainPanel.add((Component)this.topPanel, "North");
        this.updateView();
    }

    private void makeScatter() {
        InterfaceOptimizationObjective[] tmp = ((InterfaceMultiObjectiveDeNovoProblem)((Object)this.moccoViewer.moccoStandalone.state.currentProblem)).getProblemObjectives();
        this.simpleViews = new SimpleView[tmp.length][tmp.length];
        this.centerPanel.removeAll();
        this.centerPanel.setLayout(new GridLayout(tmp.length, tmp.length));
        for (int i = 0; i < tmp.length; ++i) {
            for (int j = 0; j < tmp.length; ++j) {
                this.simpleViews[i][j] = new SimpleView(this, i, j);
                this.centerPanel.add(this.simpleViews[i][j]);
            }
        }
    }

    @Override
    public void updateView() {
        if (this.moccoViewer.moccoStandalone.state.currentProblem == null) {
            this.simpleViews = null;
            this.centerPanel.removeAll();
            this.centerPanel.add(new JLabel("no problem given"));
            this.validate();
            return;
        }
        InterfaceOptimizationObjective[] tmp = ((InterfaceMultiObjectiveDeNovoProblem)((Object)this.moccoViewer.moccoStandalone.state.currentProblem)).getProblemObjectives();
        if (this.simpleViews == null) {
            this.makeScatter();
        }
        if (this.simpleViews.length != tmp.length) {
            this.makeScatter();
        }
        if (this.simpleViews != null) {
            for (int i = 0; i < tmp.length; ++i) {
                for (int j = 0; j < tmp.length; ++j) {
                    this.simpleViews[i][j].updateView();
                }
            }
        }
        this.validate();
    }

    public void refPointGiven(double[] point) {
        if (this.fitnessObjectiveComboBox.getSelectedIndex() == 1) {
            JOptionPane.showMessageDialog(this.moccoViewer.moccoStandalone.getMainFrame(), "Reference point needs to be selected in fitness space!", "Warning", 2);
        } else {
            this.moccoViewer.refPointGiven(point);
        }
    }

    public void addRefPointSelectionListener(InterfaceRefPointListener a) {
        this.refPointListener = a;
    }

    public InterfaceRefPointListener getRefPointSelectionListener() {
        return this.refPointListener;
    }

    public void removeRefPointSelectionListeners() {
        this.refPointListener = null;
    }
}

