/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.mocco.paretofrontviewer;

import eva2.gui.plot.FunctionArea;
import eva2.gui.plot.GraphPointSet;
import eva2.gui.plot.InterfaceDPointWithContent;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.mocco.paretofrontviewer.InterfaceRefPointListener;
import eva2.optimization.mocco.paretofrontviewer.ParetoFrontViewScatterPlot;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceMultiObjectiveDeNovoProblem;
import eva2.problems.InterfaceOptimizationObjective;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DPointContentSelectable;
import eva2.tools.chart2d.ScaledBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

class SimpleView
extends JComponent
implements InterfaceRefPointListener {
    private InterfaceRefPointListener refPointListener;
    private FunctionArea functionArea = null;
    private ScaledBorder areaBorder;
    ParetoFrontViewScatterPlot paretoFrontViewScatterPlot;
    int object1;
    int object2;
    JLabel label;

    public SimpleView(ParetoFrontViewScatterPlot dad, int obj1, int obj2) {
        this.paretoFrontViewScatterPlot = dad;
        this.object1 = obj1;
        this.object2 = obj2;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        if (this.object1 == this.object2) {
            this.label = new JLabel("" + ((InterfaceMultiObjectiveDeNovoProblem)((Object)this.paretoFrontViewScatterPlot.moccoViewer.moccoStandalone.state.currentProblem)).getProblemObjectives()[this.object1].getIdentName());
            this.add((Component)this.label, "Center");
        } else {
            this.functionArea = new FunctionArea("?", "?");
            this.functionArea.setPreferredSize(new Dimension(200, 200));
            this.functionArea.setMinimumSize(new Dimension(200, 200));
            this.areaBorder = new ScaledBorder();
            this.areaBorder.xLabel = ((InterfaceMultiObjectiveDeNovoProblem)((Object)this.paretoFrontViewScatterPlot.moccoViewer.moccoStandalone.state.currentProblem)).getProblemObjectives()[this.object1].getIdentName();
            this.areaBorder.yLabel = ((InterfaceMultiObjectiveDeNovoProblem)((Object)this.paretoFrontViewScatterPlot.moccoViewer.moccoStandalone.state.currentProblem)).getProblemObjectives()[this.object2].getIdentName();
            this.functionArea.setBorder(this.areaBorder);
            this.functionArea.setBackground(Color.WHITE);
            this.add((Component)this.functionArea, "Center");
        }
    }

    private double[] fetchPlotValueFor(AbstractEAIndividual indy) {
        double[] result = new double[2];
        if (this.paretoFrontViewScatterPlot.fitnessObjectiveComboBox.getSelectedIndex() == 0) {
            int i;
            int index;
            InterfaceOptimizationObjective[] tmpObj = ((InterfaceMultiObjectiveDeNovoProblem)((Object)this.paretoFrontViewScatterPlot.moccoViewer.moccoStandalone.state.currentProblem)).getProblemObjectives();
            if (tmpObj[this.object1].getOptimizationMode().equalsIgnoreCase("Constraint")) {
                result[0] = 0.0;
            } else {
                index = 0;
                for (i = 0; i < this.object1; ++i) {
                    if (tmpObj[i].getOptimizationMode().equalsIgnoreCase("Constraint")) continue;
                    ++index;
                }
                result[0] = indy.getFitness(index);
            }
            if (tmpObj[this.object2].getOptimizationMode().equalsIgnoreCase("Constraint")) {
                result[1] = 0.0;
            } else {
                index = 0;
                for (i = 0; i < this.object2; ++i) {
                    if (tmpObj[i].getOptimizationMode().equalsIgnoreCase("Constraint")) continue;
                    ++index;
                }
                result[1] = indy.getFitness(index);
            }
        } else {
            InterfaceOptimizationObjective[] tmpObj = ((InterfaceMultiObjectiveDeNovoProblem)((Object)this.paretoFrontViewScatterPlot.moccoViewer.moccoStandalone.state.currentProblem)).getProblemObjectives();
            result[0] = (Double)indy.getData(tmpObj[this.object1].getIdentName());
            result[1] = (Double)indy.getData(tmpObj[this.object2].getIdentName());
        }
        return result;
    }

    public void updateView() {
        if (this.object1 == this.object2) {
            this.label.setText("" + ((InterfaceMultiObjectiveDeNovoProblem)((Object)this.paretoFrontViewScatterPlot.moccoViewer.moccoStandalone.state.currentProblem)).getProblemObjectives()[this.object1].getIdentName());
        } else {
            Population pf = this.paretoFrontViewScatterPlot.moccoViewer.moccoStandalone.state.paretoFront;
            double xmin = Double.POSITIVE_INFINITY;
            double ymin = Double.POSITIVE_INFINITY;
            double xmax = Double.NEGATIVE_INFINITY;
            double ymax = Double.NEGATIVE_INFINITY;
            this.functionArea.clearAll();
            this.functionArea.setBackground(Color.WHITE);
            if (pf.size() > 0) {
                GraphPointSet mySet = new GraphPointSet(1, this.functionArea);
                mySet.setConnectedMode(false);
                mySet.setColor(Color.BLACK);
                for (int i = 0; i < pf.size(); ++i) {
                    double[] plotValue = this.fetchPlotValueFor((AbstractEAIndividual)pf.get(i));
                    DPoint point = new DPoint(plotValue[0], plotValue[1]);
                    DPointContentSelectable icon = new DPointContentSelectable();
                    if (this.paretoFrontViewScatterPlot.moccoViewer.refSolutionSelectable) {
                        icon.addSelectionListener(this.paretoFrontViewScatterPlot.moccoViewer);
                    }
                    ((InterfaceDPointWithContent)icon).setProblem(this.paretoFrontViewScatterPlot.moccoViewer.moccoStandalone.state.currentProblem);
                    ((InterfaceDPointWithContent)icon).setEAIndividual((AbstractEAIndividual)pf.get(i));
                    point.setIcon(icon);
                    mySet.addDPoint(point);
                    if (plotValue[0] < xmin) {
                        xmin = plotValue[0];
                    }
                    if (plotValue[0] > xmax) {
                        xmax = plotValue[0];
                    }
                    if (plotValue[1] < ymin) {
                        ymin = plotValue[1];
                    }
                    if (!(plotValue[1] > ymax)) continue;
                    ymax = plotValue[1];
                }
                mySet = new GraphPointSet(0, this.functionArea);
                mySet.setConnectedMode(false);
                double xrange = xmax - xmin;
                double yrange = ymax - ymin;
                if (xrange < 1.0E-7) {
                    xrange = 1.0E-7;
                }
                if (yrange < 1.0E-7) {
                    yrange = 1.0E-7;
                }
                if (new Double(xrange).isNaN()) {
                    mySet.addDPoint(0.0, 0.0);
                    mySet.addDPoint(1.0, 1.0);
                } else {
                    mySet.addDPoint(xmin - 0.1 * xrange, ymin - 0.1 * yrange);
                    mySet.addDPoint(xmin - 0.1 * xrange, ymin - 0.1 * yrange);
                    mySet.addDPoint(xmax + 0.1 * xrange, ymax + 0.1 * yrange);
                    mySet.addDPoint(xmax + 0.1 * xrange, ymax + 0.1 * yrange);
                }
                if (this.paretoFrontViewScatterPlot.moccoViewer.moccoStandalone.state.currentProblem instanceof InterfaceMultiObjectiveDeNovoProblem && this.paretoFrontViewScatterPlot.fitnessObjectiveComboBox.getSelectedIndex() == 1) {
                    double tmpD;
                    InterfaceOptimizationObjective[] tmp = ((InterfaceMultiObjectiveDeNovoProblem)((Object)this.paretoFrontViewScatterPlot.moccoViewer.moccoStandalone.state.currentProblem)).getProblemObjectives();
                    if (tmp[this.object1].getOptimizationMode().equalsIgnoreCase("Objective") && !new Double(tmpD = tmp[this.object1].getConstraintGoal()).isNaN()) {
                        mySet = new GraphPointSet(501, this.functionArea);
                        mySet.setConnectedMode(true);
                        if (tmpD > xmin - 0.1 * xrange && tmpD < xmax + 0.1 * xrange) {
                            mySet.addDPoint(tmpD, ymin - 0.1 * yrange);
                            mySet.addDPoint(tmpD, ymin - 0.1 * yrange);
                            mySet.addDPoint(tmpD, ymax + 0.1 * yrange);
                            mySet.addDPoint(tmpD, ymax + 0.1 * yrange);
                        }
                    }
                    if (tmp[this.object2].getOptimizationMode().equalsIgnoreCase("Objective") && !new Double(tmpD = tmp[this.object2].getConstraintGoal()).isNaN()) {
                        mySet = new GraphPointSet(502, this.functionArea);
                        mySet.setConnectedMode(true);
                        if (tmpD > ymin - 0.1 * yrange && tmpD < ymax + 0.1 * yrange) {
                            mySet.addDPoint(xmin - 0.1 * xrange, tmpD);
                            mySet.addDPoint(xmin - 0.1 * xrange, tmpD);
                            mySet.addDPoint(xmax + 0.1 * xrange, tmpD);
                            mySet.addDPoint(xmax + 0.1 * xrange, tmpD);
                        }
                    }
                }
                if (this.paretoFrontViewScatterPlot.moccoViewer.referencePoint != null && this.paretoFrontViewScatterPlot.fitnessObjectiveComboBox.getSelectedIndex() == 0) {
                    mySet = new GraphPointSet(1001, this.functionArea);
                    mySet.setConnectedMode(true);
                    mySet.setColor(Color.RED);
                    double tmpD = this.paretoFrontViewScatterPlot.moccoViewer.referencePoint[this.object1];
                    if (tmpD > xmin - 0.1 * xrange && tmpD < xmax + 0.1 * xrange) {
                        mySet.addDPoint(tmpD, ymin - 0.1 * yrange);
                        mySet.addDPoint(tmpD, ymin - 0.1 * yrange);
                        mySet.addDPoint(tmpD, ymax + 0.1 * yrange);
                        mySet.addDPoint(tmpD, ymax + 0.1 * yrange);
                    }
                    mySet = new GraphPointSet(1002, this.functionArea);
                    mySet.setConnectedMode(true);
                    mySet.setColor(Color.RED);
                    tmpD = this.paretoFrontViewScatterPlot.moccoViewer.referencePoint[this.object2];
                    if (tmpD > ymin - 0.1 * yrange && tmpD < ymax + 0.1 * yrange) {
                        mySet.addDPoint(xmin - 0.1 * xrange, tmpD);
                        mySet.addDPoint(xmin - 0.1 * xrange, tmpD);
                        mySet.addDPoint(xmax + 0.1 * xrange, tmpD);
                        mySet.addDPoint(xmax + 0.1 * xrange, tmpD);
                    }
                }
            }
            if (this.paretoFrontViewScatterPlot.moccoViewer.refPointSelectable) {
                this.functionArea.addRefPointSelectionListener(this);
            } else {
                this.removeRefPointSelectionListeners();
                this.functionArea.removeRefPointSelectionListeners();
                this.paretoFrontViewScatterPlot.removeRefPointSelectionListeners();
            }
        }
    }

    @Override
    public void refPointGiven(double[] point) {
        if (this.paretoFrontViewScatterPlot.fitnessObjectiveComboBox.getSelectedIndex() == 1) {
            JOptionPane.showMessageDialog(this.paretoFrontViewScatterPlot.moccoViewer.moccoStandalone.getMainFrame(), "Reference point needs to be selected in fitness space!", "Warning", 2);
        } else {
            double[] tmpD = this.paretoFrontViewScatterPlot.moccoViewer.referencePoint;
            tmpD[this.object1] = point[0];
            tmpD[this.object1] = point[1];
            this.paretoFrontViewScatterPlot.moccoViewer.refPointGiven(tmpD);
        }
    }

    public void addRefPointSelectionListener(InterfaceRefPointListener a) {
        this.refPointListener = a;
    }

    public InterfaceRefPointListener getRefPointSelectionListener() {
        return this.refPointListener;
    }

    public void removeRefPointSelectionListeners() {
        this.refPointListener = null;
    }
}

