/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.modules;

import eva2.optimization.InterfaceOptimizationParameters;
import eva2.optimization.InterfaceProcessor;
import eva2.optimization.OptimizationStateListener;
import eva2.optimization.Processor;
import eva2.optimization.modules.ModuleAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractModuleAdapter
implements ModuleAdapter,
Serializable {
    private static int instanceCounter;
    protected int instanceNumber = ++instanceCounter;
    protected String adapterName;
    protected InterfaceProcessor processor;
    protected ModuleAdapter remoteModuleAdapter = null;
    private List<OptimizationStateListener> optimizationStateListeners = new ArrayList<OptimizationStateListener>();

    protected AbstractModuleAdapter() {
    }

    @Override
    public void updateProgress(int percent, String msg) {
        for (OptimizationStateListener listener : this.optimizationStateListeners) {
            listener.updateProgress(percent, msg);
        }
    }

    @Override
    public void startOptimization() {
        this.processor.startOptimization();
    }

    @Override
    public void stopOptimization() {
        this.processor.stopOptimization();
    }

    @Override
    public boolean hasPostProcessing() {
        return this.processor instanceof Processor && ((Processor)this.processor).getOptimizationParameters().getPostProcessParams().isDoPostProcessing();
    }

    @Override
    public boolean startPostProcessing() {
        if (this.hasPostProcessing() && ((Processor)this.processor).getOptimizationParameters().getPostProcessParams().isDoPostProcessing()) {
            ((Processor)this.processor).performPostProcessing();
            return true;
        }
        return false;
    }

    public InterfaceOptimizationParameters getOptimizationParameters() {
        if (this.processor != null && this.processor instanceof Processor) {
            return ((Processor)this.processor).getOptimizationParameters();
        }
        return null;
    }

    public void setOptimizationParameters(InterfaceOptimizationParameters goParams) {
        if (this.processor != null && this.processor instanceof Processor) {
            ((Processor)this.processor).setOptimizationParameters(goParams);
        }
    }

    @Override
    public void addOptimizationStateListener(OptimizationStateListener remoteListener) {
        this.optimizationStateListeners.add(remoteListener);
    }

    @Override
    public void performedStop() {
        for (OptimizationStateListener listener : this.optimizationStateListeners) {
            listener.performedStop();
        }
    }

    @Override
    public void performedStart(String infoString) {
        for (OptimizationStateListener listener : this.optimizationStateListeners) {
            listener.performedStart(infoString);
        }
    }

    @Override
    public void performedRestart(String infoString) {
        for (OptimizationStateListener listener : this.optimizationStateListeners) {
            listener.performedRestart(infoString);
        }
    }
}

