/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.modules;

import eva2.gui.JParaPanel;
import eva2.gui.ModuleButtonPanelMaker;
import eva2.gui.TabbedFrameMaker;
import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.InterfaceOptimizationParameters;
import eva2.optimization.Processor;
import eva2.optimization.modules.AbstractModuleAdapter;
import eva2.optimization.statistics.AbstractStatistics;
import eva2.optimization.statistics.InterfaceStatisticsParameters;
import eva2.optimization.statistics.OptimizationJob;
import eva2.optimization.statistics.OptimizationJobList;
import eva2.optimization.statistics.StatisticsStandalone;
import eva2.optimization.statistics.StatisticsWithGUI;
import java.io.Serializable;

public class GenericModuleAdapter
extends AbstractModuleAdapter
implements Serializable {
    private AbstractStatistics statisticsModule;
    private OptimizationJobList jobList = null;
    public String helperFilename;
    JParaPanel jobPanel = null;
    JParaPanel paramPanel = null;

    public GenericModuleAdapter(String adapterName, String helperFName, InterfaceOptimizationParameters params, boolean optimizerExpert, String noGUIStatOut) {
        this.remoteModuleAdapter = this;
        this.adapterName = adapterName;
        this.helperFilename = helperFName;
        this.statisticsModule = noGUIStatOut == null ? new StatisticsWithGUI() : new StatisticsStandalone(noGUIStatOut);
        this.processor = new Processor(this.statisticsModule, params);
        this.processor.addListener(this);
        GenericObjectEditor.setExpertProperty(params.getClass(), "optimizer", optimizerExpert);
        ((Processor)this.processor).start();
    }

    public GenericModuleAdapter(String adapterName, String helperFName, InterfaceOptimizationParameters params, boolean optimizerExpert) {
        this(adapterName, helperFName, params, optimizerExpert, null);
    }

    @Override
    public TabbedFrameMaker getModuleFrame() {
        if (!(this.statisticsModule instanceof StatisticsWithGUI)) {
            System.err.println("Error: Unable to create Frame when started with noGUI option (GenericModuleAdapter)!");
            return null;
        }
        TabbedFrameMaker frmMkr = new TabbedFrameMaker();
        InterfaceStatisticsParameters Stat = this.statisticsModule.getStatisticsParameters();
        ModuleButtonPanelMaker buttonPanel = new ModuleButtonPanelMaker(this.remoteModuleAdapter, ((Processor)this.processor).isOptimizationRunning());
        buttonPanel.setHelperFilename(this.helperFilename);
        frmMkr.addPanelMaker(buttonPanel);
        InterfaceOptimizationParameters optimizationParameters = ((Processor)this.processor).getOptimizationParameters();
        this.paramPanel = new JParaPanel(optimizationParameters, optimizationParameters.getName());
        frmMkr.addPanelMaker(this.paramPanel);
        frmMkr.addPanelMaker(new JParaPanel(Stat, Stat.getName()));
        this.jobList = new OptimizationJobList(new OptimizationJob[0]);
        this.jobList.setModule(this);
        this.jobList.addTextListener((AbstractStatistics)((Processor)this.processor).getStatistics());
        this.jobPanel = new JParaPanel(this.jobList, this.jobList.getName());
        frmMkr.addPanelMaker(this.jobPanel);
        ((Processor)this.processor).getOptimizationParameters().addInformableInstance(frmMkr);
        return frmMkr;
    }

    @Override
    public void performedStart(String infoString) {
        super.performedStart(infoString);
        OptimizationJob job = this.scheduleJob();
        ((Processor)this.processor).getStatistics().addDataListener(job);
    }

    @Override
    public void performedStop() {
        super.performedStop();
        this.jobPanel.getEditor().getCustomEditor().repaint();
    }

    public static String getName() {
        return null;
    }

    public AbstractStatistics getStatistics() {
        return this.statisticsModule;
    }

    @Override
    public OptimizationJob scheduleJob() {
        OptimizationJob job = this.jobList.addJob(((Processor)this.processor).getOptimizationParameters(), (AbstractStatistics)((Processor)this.processor).getStatistics());
        this.jobPanel.getEditor().setValue(this.jobList);
        return job;
    }

    @Override
    public void setOptimizationParameters(InterfaceOptimizationParameters goParams) {
        super.setOptimizationParameters(goParams);
        this.paramPanel.getEditor().setValue(goParams);
    }
}

