/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.archiving;

import eva2.gui.plot.GraphPointSet;
import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.archiving.InterfaceArchiving;
import eva2.optimization.population.Population;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DPointIcon;
import eva2.tools.chart2d.DPointIconCross;
import java.io.Serializable;

public abstract class AbstractArchiving
implements InterfaceArchiving,
Serializable {
    protected transient Plot plot = null;
    protected int p = 0;
    public boolean obeyDebsConstViolationPrinciple = true;

    @Override
    public abstract Object clone();

    public boolean isDominant(AbstractEAIndividual indy, Population pop) {
        if (this.obeyDebsConstViolationPrinciple) {
            for (int i = 0; i < pop.size(); ++i) {
                if (indy.equals(pop.get(i)) || !((AbstractEAIndividual)pop.get(i)).isDominatingDebConstraints(indy)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < pop.size(); ++i) {
                if (indy.equals(pop.get(i)) || !((AbstractEAIndividual)pop.get(i)).isDominating(indy)) continue;
                return false;
            }
        }
        return true;
    }

    public void addIndividualToArchive(AbstractEAIndividual indy, Population archive) {
        double[] indyFitness = indy.getFitness();
        for (int i = 0; i < archive.size(); ++i) {
            boolean isDominating = true;
            double[] tmpFitness = ((AbstractEAIndividual)archive.get(i)).getFitness();
            try {
                for (int j = 0; j < indyFitness.length; ++j) {
                    isDominating &= indyFitness[j] <= tmpFitness[j];
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
            if (!isDominating) continue;
            archive.remove(i);
            --i;
        }
        archive.add(indy);
    }

    public void plotParetoFront(Population pop, Plot plot) {
        DPointIcon[] icons = new DPointIcon[pop.size()];
        for (int i = 0; i < icons.length; ++i) {
            icons[i] = new DPointIconCross();
        }
        this.plotParetoFront(pop, icons, plot);
    }

    public void plotParetoFront(Population pop, DPointIcon[] icons, Plot plot) {
        int j;
        GraphPointSet mySet = new GraphPointSet(10, plot.getFunctionArea());
        double[] lastValue = null;
        mySet.setConnectedMode(false);
        ++this.p;
        mySet = new GraphPointSet(10000 + this.p, plot.getFunctionArea());
        mySet.setConnectedMode(false);
        lastValue = null;
        double[][] tmpFit = new double[pop.size()][];
        for (j = 0; j < pop.size(); ++j) {
            AbstractEAIndividual tmpIndy = (AbstractEAIndividual)pop.get(j);
            if (tmpIndy.getFitness().length <= 1) {
                double[] tmpD = (double[])tmpIndy.getData("MOFitness");
                tmpFit[j] = new double[tmpD.length];
                System.arraycopy(tmpD, 0, tmpFit[j], 0, tmpD.length);
                continue;
            }
            tmpFit[j] = new double[tmpIndy.getFitness().length];
            System.arraycopy(tmpIndy.getFitness(), 0, tmpFit[j], 0, tmpIndy.getFitness().length);
        }
        for (j = 0; j < pop.size(); ++j) {
            int index = -1;
            double curVal = Double.POSITIVE_INFINITY;
            for (int n = 0; n < tmpFit.length; ++n) {
                if (!(tmpFit[n][0] < curVal)) continue;
                index = n;
                curVal = tmpFit[n][0];
            }
            DPoint myPoint = new DPoint(tmpFit[index][0], tmpFit[index][1]);
            if (lastValue != null) {
                plot.setConnectedPoint((double)lastValue[0], lastValue[1], 20000 + this.p);
                plot.setConnectedPoint(tmpFit[index][0], lastValue[1], 20000 + this.p);
                plot.setConnectedPoint(tmpFit[index][0], tmpFit[index][1], 20000 + this.p);
            }
            lastValue = new double[tmpFit[index].length];
            System.arraycopy(tmpFit[index], 0, lastValue, 0, lastValue.length);
            tmpFit[index][0] = Double.POSITIVE_INFINITY;
            myPoint.setIcon(icons[index]);
            mySet.addDPoint(myPoint);
        }
        if (lastValue != null) {
            plot.setConnectedPoint((double)lastValue[0], (double)lastValue[1], 20000 + this.p);
        }
        ++this.p;
    }

    public void setObeyDebsConstViolationPrinciple(boolean b) {
        this.obeyDebsConstViolationPrinciple = b;
    }

    public boolean getObeyDebsConstViolationPrinciple() {
        return this.obeyDebsConstViolationPrinciple;
    }

    public String obeyDebsConstViolationPrincipleToolTip() {
        return "Toggle the use of Deb's constraint violation principle.";
    }
}

