/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.archiving;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.archiving.AbstractArchiving;
import eva2.optimization.operator.selection.SelectBestIndividuals;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is a straightforward strategy, which selects all dominating individuals (very prone to generate OutOfMemory errors).")
public class ArchivingAllDominating
extends AbstractArchiving
implements Serializable {
    public ArchivingAllDominating() {
    }

    public ArchivingAllDominating(ArchivingAllDominating a) {
        this.obeyDebsConstViolationPrinciple = a.obeyDebsConstViolationPrinciple;
    }

    @Override
    public Object clone() {
        return new ArchivingAllDominating(this);
    }

    @Override
    public void addElementsToArchive(Population pop) {
        if (pop.getArchive() == null) {
            pop.SetArchive(new Population());
        }
        if (this.obeyDebsConstViolationPrinciple) {
            for (int i = 0; i < pop.size(); ++i) {
                if (((AbstractEAIndividual)pop.get(i)).getConstraintViolation() != 0.0 || !this.isDominant((AbstractEAIndividual)pop.get(i), pop.getArchive())) continue;
                this.addIndividualToArchive((AbstractEAIndividual)((AbstractEAIndividual)pop.get(i)).clone(), pop.getArchive());
            }
            if (pop.getArchive().size() == 0 && pop.size() > 0) {
                SelectBestIndividuals select = new SelectBestIndividuals();
                select.setObeyDebsConstViolationPrinciple(true);
                pop.getArchive().addPopulation(select.selectFrom(pop, pop.getArchive().getTargetSize()));
            }
        } else {
            for (int i = 0; i < pop.size(); ++i) {
                if (!this.isDominant((AbstractEAIndividual)pop.get(i), pop.getArchive())) continue;
                this.addIndividualToArchive((AbstractEAIndividual)((AbstractEAIndividual)pop.get(i)).clone(), pop.getArchive());
            }
        }
    }

    public String getName() {
        return "AllDominating";
    }
}

