/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.archiving;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.archiving.InterfaceArchiving;
import eva2.optimization.operator.moso.MOSOMaxiMin;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.operator.selection.SelectBestIndividuals;
import eva2.optimization.population.Population;
import eva2.tools.chart2d.DPointIcon;
import eva2.tools.chart2d.DPointIconCross;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Maxi Min Archiving.")
public class ArchivingMaxiMin
implements InterfaceArchiving,
Serializable {
    private MOSOMaxiMin maxiMin = new MOSOMaxiMin();
    private InterfaceSelection selection = new SelectBestIndividuals();
    private boolean obeyDebsConstViolationPrinciple = true;

    public ArchivingMaxiMin() {
    }

    public ArchivingMaxiMin(ArchivingMaxiMin a) {
        this.maxiMin = new MOSOMaxiMin();
        this.selection = (InterfaceSelection)a.selection.clone();
        this.obeyDebsConstViolationPrinciple = a.obeyDebsConstViolationPrinciple;
    }

    @Override
    public Object clone() {
        return new ArchivingMaxiMin(this);
    }

    @Override
    public void addElementsToArchive(Population pop) {
        if (pop.getArchive() == null) {
            pop.SetArchive(new Population());
        }
        Population tmpPop = new Population();
        tmpPop.addPopulation((Population)pop.getClone());
        tmpPop.addPopulation((Population)pop.getArchive().getClone());
        tmpPop.removeRedundantIndiesUsingFitness();
        this.maxiMin.convertMultiObjective2SingleObjective(tmpPop);
        this.selection.setObeyDebsConstViolationPrinciple(this.obeyDebsConstViolationPrinciple);
        this.selection.prepareSelection(tmpPop);
        Population archive = this.selection.selectFrom(tmpPop, pop.getArchive().getTargetSize());
        archive.setTargetSize(pop.getArchive().getTargetSize());
        for (int i = 0; i < archive.size(); ++i) {
            double[] tmpD = (double[])((AbstractEAIndividual)archive.get(i)).getData("MOFitness");
            ((AbstractEAIndividual)archive.get(i)).setFitness(tmpD);
        }
        pop.SetArchive(archive);
    }

    public DPointIcon getIconFor(int index, Population pop) {
        return new DPointIconCross();
    }

    public String getName() {
        return "MaxiMin";
    }

    public void setSelectionMethod(InterfaceSelection pop) {
        this.selection = pop;
    }

    public InterfaceSelection getSelectionMethod() {
        return this.selection;
    }

    public String selectionMethodTipText() {
        return "Choose the selection method (single-criteria ones please).";
    }

    public void setObeyDebsConstViolationPrinciple(boolean b) {
        this.obeyDebsConstViolationPrinciple = b;
    }

    public boolean getObeyDebsConstViolationPrinciple() {
        return this.obeyDebsConstViolationPrinciple;
    }

    public String obeyDebsConstViolationPrincipleToolTip() {
        return "Toggle the use of Deb's coonstraint violation principle.";
    }
}

