/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.archiving;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.archiving.AbstractArchiving;
import eva2.optimization.operator.archiving.InterfaceRemoveSurplusIndividuals;
import eva2.optimization.operator.archiving.RemoveSurplusIndividualsDynamicHyperCube;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Non-dominating sorting GA revision 1.0.")
public class ArchivingNSGA
extends AbstractArchiving
implements Serializable {
    public InterfaceRemoveSurplusIndividuals cleaner = new RemoveSurplusIndividualsDynamicHyperCube();

    public ArchivingNSGA() {
    }

    public ArchivingNSGA(ArchivingNSGA a) {
        this.cleaner = (InterfaceRemoveSurplusIndividuals)a.cleaner.clone();
    }

    @Override
    public Object clone() {
        return new ArchivingNSGA(this);
    }

    @Override
    public void addElementsToArchive(Population pop) {
        if (pop.getArchive() == null) {
            pop.SetArchive(new Population());
        }
        for (int i = 0; i < pop.size(); ++i) {
            if (!this.isDominant((AbstractEAIndividual)pop.get(i), pop.getArchive())) continue;
            this.addIndividualToArchive((AbstractEAIndividual)((AbstractEAIndividual)pop.get(i)).clone(), pop.getArchive());
        }
        Population archive = pop.getArchive();
        this.cleaner.removeSurplusIndividuals(archive);
    }

    public String getName() {
        return "NSGA";
    }

    public void setCleaner(InterfaceRemoveSurplusIndividuals s) {
        this.cleaner = s;
    }

    public InterfaceRemoveSurplusIndividuals getCleaner() {
        return this.cleaner;
    }

    public String cleanerTipText() {
        return "Choose the method to remove surplus individuals from the archive.";
    }
}

