/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.archiving;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.archiving.ArchivingNSGA;
import eva2.optimization.operator.archiving.RemoveSurplusIndividualsDynamicHyperCube;
import eva2.optimization.population.Population;
import eva2.tools.chart2d.DPointIcon;
import eva2.tools.chart2d.DPointIconCross;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.ArrayList;

@Description(value="Non-dominating sorting GA revision 2.0.")
public class ArchivingNSGAII
extends ArchivingNSGA
implements Serializable {
    public ArchivingNSGAII() {
    }

    public ArchivingNSGAII(ArchivingNSGAII a) {
    }

    @Override
    public Object clone() {
        return new ArchivingNSGAII(this);
    }

    @Override
    public void addElementsToArchive(Population pop) {
        int index;
        if (pop.getArchive() == null) {
            pop.SetArchive(new Population());
        }
        Population tmpPop = new Population();
        tmpPop.addPopulation((Population)pop.getClone());
        tmpPop.addPopulation((Population)pop.getArchive().getClone());
        tmpPop.removeRedundantIndiesUsingFitness();
        Population[] fronts = this.getNonDominatedSortedFronts(tmpPop);
        tmpPop.clear();
        tmpPop = null;
        Population archive = new Population();
        archive.setTargetSize(pop.getArchive().getTargetSize());
        for (index = 0; index < fronts.length && archive.size() + fronts[index].size() < archive.getTargetSize(); ++index) {
            archive.addPopulation(fronts[index]);
        }
        if (index < fronts.length && !archive.targetSizeReached()) {
            fronts[index].setTargetSize(archive.getTargetSize() - archive.size());
            this.cleaner.removeSurplusIndividuals(fronts[index]);
            archive.addPopulation(fronts[index]);
        }
        for (int i = 0; i < fronts.length; ++i) {
            fronts[i].clear();
            fronts[i] = null;
        }
        fronts = null;
        pop.SetArchive(archive);
    }

    public static Population getNonDominatedSortedFront(Population pop) {
        ArchivingNSGAII arch = new ArchivingNSGAII();
        Population[] fronts = arch.getNonDominatedSortedFronts(pop);
        return fronts[0];
    }

    public Population[] getNonDominatedSortedFronts(Population pop) {
        int i;
        Population[] result = null;
        ArrayList<Population> tmpResult = new ArrayList<Population>();
        int level = 1;
        Population tmpPop = new Population();
        tmpPop.addPopulation(pop);
        while (tmpPop.size() > 0) {
            Population tmpDom = new Population();
            Population tmpNonDom = new Population();
            for (i = 0; i < tmpPop.size(); ++i) {
                if (this.isDominant((AbstractEAIndividual)tmpPop.get(i), tmpPop)) {
                    ((AbstractEAIndividual)tmpPop.get(i)).putData("ParetoLevel", level);
                    tmpDom.add(tmpPop.get(i));
                    continue;
                }
                tmpNonDom.add(tmpPop.get(i));
            }
            tmpPop = tmpNonDom;
            if (tmpDom.size() < 1) {
                System.out.println("Problem NSGA II at level " + level + ".");
                tmpDom.addPopulation(tmpNonDom);
                for (i = 0; i < tmpDom.size(); ++i) {
                    ((AbstractEAIndividual)tmpDom.get(i)).putData("ParetoLevel", level);
                }
                tmpPop.clear();
            }
            tmpResult.add(tmpDom);
            ++level;
        }
        result = new Population[tmpResult.size()];
        for (i = 0; i < result.length; ++i) {
            result[i] = (Population)tmpResult.get(i);
        }
        return result;
    }

    public void calculateCrowdingDistance(Population[] fronts) {
        RemoveSurplusIndividualsDynamicHyperCube heidi = new RemoveSurplusIndividualsDynamicHyperCube();
        for (int i = 0; i < fronts.length; ++i) {
            int j;
            double[][] fitness = new double[fronts[i].size()][];
            double[] hyperCube = new double[fronts[i].size()];
            for (j = 0; j < fronts[i].size(); ++j) {
                fitness[j] = ((AbstractEAIndividual)fronts[i].get(j)).getFitness();
            }
            hyperCube = heidi.calculateHyperCubeVolumes(fitness);
            for (j = 0; j < fronts[i].size(); ++j) {
                ((AbstractEAIndividual)fronts[i].get(j)).putData("HyperCube", hyperCube[j]);
            }
        }
    }

    public DPointIcon getIconFor(int index, Population pop) {
        return new DPointIconCross();
    }

    @Override
    public String getName() {
        return "NSGA II";
    }
}

