/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.archiving;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.EAIndividualComparator;
import eva2.optimization.operator.archiving.ArchivingNSGAII;
import eva2.optimization.population.Population;
import java.util.Arrays;

public class ArchivingNSGAIISMeasure
extends ArchivingNSGAII {
    @Override
    public void calculateCrowdingDistance(Population[] fronts) {
        for (Population front : fronts) {
            this.calculateCrowdingDistance(front);
        }
    }

    @Override
    public boolean isDominant(AbstractEAIndividual indy, Population pop) {
        if (this.obeyDebsConstViolationPrinciple) {
            for (int i = 0; i < pop.size(); ++i) {
                if (indy.equals(pop.get(i)) || indy.equalFitness((AbstractEAIndividual)pop.get(i)) || !((AbstractEAIndividual)pop.get(i)).isDominatingDebConstraints(indy)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < pop.size(); ++i) {
                if (indy.equals(pop.get(i)) || indy.equalFitness((AbstractEAIndividual)pop.get(i)) || !((AbstractEAIndividual)pop.get(i)).isDominating(indy)) continue;
                return false;
            }
        }
        return true;
    }

    public void calculateCrowdingDistance(Population front) {
        int i;
        Object[] frontArray = front.toArray();
        boolean[] assigned = new boolean[frontArray.length];
        double[] v = new double[frontArray.length];
        for (i = 0; i < frontArray.length; ++i) {
            assigned[i] = false;
        }
        Arrays.sort(frontArray, new EAIndividualComparator(0));
        ((AbstractEAIndividual)frontArray[0]).putData("HyperCube", Double.MAX_VALUE);
        ((AbstractEAIndividual)frontArray[frontArray.length - 1]).putData("HyperCube", Double.MAX_VALUE);
        v[0] = Double.MAX_VALUE;
        v[frontArray.length - 1] = Double.MAX_VALUE;
        for (int e = 1; e < frontArray.length - 1; ++e) {
            i = 1;
            while (assigned[i]) {
                ++i;
            }
            int left = 0;
            while (i < frontArray.length - 1) {
                int right = i + 1;
                while (assigned[right]) {
                    ++right;
                }
                v[i] = (((AbstractEAIndividual)frontArray[right]).getFitness(0) - ((AbstractEAIndividual)frontArray[i]).getFitness(0)) * (((AbstractEAIndividual)frontArray[left]).getFitness(1) - ((AbstractEAIndividual)frontArray[i]).getFitness(1));
                left = i;
                i = right;
            }
            int minIndex = 0;
            double min = v[minIndex];
            for (int f = 1; f < frontArray.length - 1; ++f) {
                if (assigned[f] || !(v[f] < min)) continue;
                min = v[f];
                minIndex = f;
            }
            assigned[minIndex] = true;
            ((AbstractEAIndividual)frontArray[minIndex]).putData("HyperCube", e);
        }
    }
}

