/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.archiving;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.archiving.AbstractArchiving;
import eva2.optimization.population.Population;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.ArrayList;

@Description(value="Pareto Envelope-based Selection Algorithm revision 2.0.")
public class ArchivingPESAII
extends AbstractArchiving
implements Serializable {
    private int gridSize = 4;

    public ArchivingPESAII() {
    }

    public ArchivingPESAII(ArchivingPESAII a) {
        this.gridSize = a.gridSize;
    }

    @Override
    public Object clone() {
        return new ArchivingPESAII(this);
    }

    @Override
    public void addElementsToArchive(Population pop) {
        if (pop.getArchive() == null) {
            pop.SetArchive(new Population());
        }
        Population archive = pop.getArchive();
        for (int i = 0; i < pop.size(); ++i) {
            if (!this.isDominant((AbstractEAIndividual)pop.get(i), pop.getArchive())) continue;
            this.addIndividualToArchive((AbstractEAIndividual)((AbstractEAIndividual)pop.get(i)).clone(), pop.getArchive());
        }
        while (archive.targetSizeExceeded()) {
            int[] squeezeFactor = this.calculateSqueezeFactor(archive);
            int bigSqueeze = 0;
            int index = -1;
            for (int i = 0; i < squeezeFactor.length; ++i) {
                if (bigSqueeze < squeezeFactor[i]) {
                    bigSqueeze = squeezeFactor[i];
                    index = i;
                }
                if (bigSqueeze != squeezeFactor[i] || !RNG.flipCoin(0.5)) continue;
                index = i;
            }
            archive.remove(index);
        }
    }

    public int[] calculateSqueezeFactor(Population pop) {
        double[] tmpFit;
        int i;
        int[] result = new int[pop.size()];
        double[][] bounds = new double[((AbstractEAIndividual)pop.get(0)).getFitness().length][2];
        for (i = 0; i < bounds.length; ++i) {
            bounds[i][0] = Double.POSITIVE_INFINITY;
            bounds[i][1] = Double.NEGATIVE_INFINITY;
        }
        for (i = 0; i < pop.size(); ++i) {
            tmpFit = ((AbstractEAIndividual)pop.get(i)).getFitness();
            result[i] = 0;
            for (int j = 0; j < tmpFit.length; ++j) {
                if (tmpFit[j] < bounds[j][0]) {
                    bounds[j][0] = tmpFit[j];
                }
                if (!(tmpFit[j] > bounds[j][1])) continue;
                bounds[j][1] = tmpFit[j];
            }
        }
        int[] tmpGrid = new int[bounds.length];
        double[] grid = new double[bounds.length];
        for (int i2 = 0; i2 < pop.size(); ++i2) {
            int j;
            if (result[i2] != 0) continue;
            int[] curGrid = new int[bounds.length];
            tmpFit = ((AbstractEAIndividual)pop.get(i2)).getFitness();
            ArrayList<Integer> coll = new ArrayList<Integer>();
            for (j = 0; j < tmpFit.length; ++j) {
                grid[j] = (bounds[j][1] - bounds[j][0]) / (double)this.gridSize;
                curGrid[j] = (int)((tmpFit[j] - bounds[j][0]) / grid[j]);
            }
            coll.add(i2);
            for (j = i2 + 1; j < pop.size(); ++j) {
                if (result[j] != 0) continue;
                tmpFit = ((AbstractEAIndividual)pop.get(j)).getFitness();
                boolean sameGrid = true;
                for (int k = 0; k < tmpFit.length; ++k) {
                    tmpGrid[k] = (int)((tmpFit[k] - bounds[k][0]) / grid[k]);
                    sameGrid &= curGrid[k] == tmpGrid[k];
                }
                if (!sameGrid) continue;
                coll.add(j);
            }
            for (j = 0; j < coll.size(); ++j) {
                result[((Integer)coll.get((int)j)).intValue()] = coll.size();
                AbstractEAIndividual tmpIndy = (AbstractEAIndividual)pop.get((Integer)coll.get(j));
                tmpIndy.putData("SqueezeFactor", coll.size());
                tmpIndy.putData("GridBox", curGrid);
            }
        }
        return result;
    }

    public String getName() {
        return "PESA II";
    }

    public void setGridSize(int b) {
        this.gridSize = b;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public String gridSizeTipText() {
        return "Choose the number of a grid elements per dimension.";
    }
}

