/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.archiving;

import eva2.gui.plot.GraphPointSet;
import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.archiving.AbstractArchiving;
import eva2.optimization.operator.distancemetric.InterfaceDistanceMetric;
import eva2.optimization.operator.distancemetric.ObjectiveSpaceMetric;
import eva2.optimization.population.Population;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DPointIconCircle;
import eva2.tools.chart2d.DPointIconText;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Strength Pareto EA revision 2.0. The variable k to calculate the k-th distance is given by max(2, sqrt(archive.size())).")
public class ArchivingSPEAII
extends AbstractArchiving
implements Serializable {
    private InterfaceDistanceMetric metric = new ObjectiveSpaceMetric();
    private boolean soutDebug = false;

    public ArchivingSPEAII() {
    }

    public ArchivingSPEAII(ArchivingSPEAII a) {
        this.metric = (InterfaceDistanceMetric)a.metric.clone();
    }

    @Override
    public Object clone() {
        return new ArchivingSPEAII(this);
    }

    @Override
    public void addElementsToArchive(Population pop) {
        if (pop.getArchive() == null) {
            pop.SetArchive(new Population());
        }
        Population tmpPop = new Population();
        tmpPop.addPopulation((Population)pop.getClone());
        tmpPop.addPopulation((Population)pop.getArchive().getClone());
        tmpPop.removeRedundantIndiesUsingFitness();
        double[] RawFitness = this.calculateRawFitness(tmpPop);
        double[] kthDistance = this.calculateKthDistance(tmpPop, Math.max(2, (int)Math.sqrt(tmpPop.size())));
        Population archive = new Population();
        archive.setTargetSize(pop.getArchive().getTargetSize());
        for (int i = 0; i < RawFitness.length; ++i) {
            if (!(RawFitness[i] < 1.0)) continue;
            archive.add(tmpPop.get(i));
        }
        int currentLevel = 0;
        while (!archive.targetSizeReached()) {
            ++currentLevel;
            for (int i = 0; i < RawFitness.length; ++i) {
                if (!(RawFitness[i] >= (double)currentLevel) || !(RawFitness[i] < (double)(currentLevel + 1))) continue;
                archive.add(tmpPop.get(i));
            }
        }
        while (archive.targetSizeExceeded()) {
            int i;
            double highestLevel = 0.0;
            RawFitness = this.calculateRawFitness(archive);
            for (i = 0; i < RawFitness.length; ++i) {
                if (!(RawFitness[i] > highestLevel)) continue;
                highestLevel = RawFitness[i];
            }
            kthDistance = this.calculateKthDistance(archive, Math.max(2, (int)Math.sqrt(archive.size())));
            int ICurSma = -1;
            double curSmall = Double.MAX_VALUE;
            for (i = 0; i < kthDistance.length; ++i) {
                if (highestLevel != RawFitness[i] || !(curSmall > kthDistance[i])) continue;
                curSmall = kthDistance[i];
                ICurSma = i;
            }
            archive.remove(ICurSma);
        }
        pop.SetArchive(archive);
    }

    private double[][] showMay(Population pop) {
        Population tmp = new Population();
        tmp.addPopulation(pop);
        if (pop.getArchive() != null) {
            tmp.addPopulation(pop.getArchive());
        }
        double[][] fitness = new double[tmp.size()][];
        for (int i = 0; i < tmp.size(); ++i) {
            fitness[i] = ((AbstractEAIndividual)tmp.get(i)).getFitness();
        }
        double[] minY = fitness[0];
        double[] maxY = fitness[0];
        for (int i = 1; i < fitness.length; ++i) {
            if (minY[0] > fitness[i][0]) {
                minY = fitness[i];
            }
            if (!(maxY[1] > fitness[i][1])) continue;
            maxY = fitness[i];
        }
        double[][] result = new double[][]{minY, maxY};
        return result;
    }

    private double[] calculateRawFitness(Population pop) {
        int j;
        int i;
        double[] result = new double[pop.size()];
        int[] SPEAStrength = new int[pop.size()];
        for (i = 0; i < pop.size(); ++i) {
            result[i] = 0.0;
            SPEAStrength[i] = 0;
            AbstractEAIndividual tmpIndy = (AbstractEAIndividual)pop.get(i);
            for (j = 0; j < pop.size(); ++j) {
                if (i == j || this.isEqualTo(tmpIndy, (AbstractEAIndividual)pop.get(j)) || !tmpIndy.isDominating((AbstractEAIndividual)pop.get(j))) continue;
                int n = i;
                SPEAStrength[n] = SPEAStrength[n] + 1;
            }
        }
        if (this.soutDebug) {
            for (i = 0; i < SPEAStrength.length; ++i) {
                System.out.println("SPEAStrength " + i + ": " + SPEAStrength[i]);
            }
        }
        for (i = 0; i < pop.size(); ++i) {
            for (j = 0; j < pop.size(); ++j) {
                if (i == j || this.isEqualTo((AbstractEAIndividual)pop.get(i), (AbstractEAIndividual)pop.get(j)) || !((AbstractEAIndividual)pop.get(i)).isDominating((AbstractEAIndividual)pop.get(j))) continue;
                int n = j;
                result[n] = result[n] + (double)SPEAStrength[i];
                if (!this.soutDebug) continue;
                if (i == 14) {
                    double[] f1 = ((AbstractEAIndividual)pop.get(i)).getFitness();
                    double[] f2 = ((AbstractEAIndividual)pop.get(j)).getFitness();
                    for (int n2 = 0; n2 < f1.length; ++n2) {
                        System.out.println("" + Math.abs(f1[n2] - f2[n2]));
                    }
                }
                System.out.println("Adding: " + SPEAStrength[i] + " to " + j + " because " + i + " is dominating!");
            }
        }
        if (this.soutDebug) {
            for (i = 0; i < result.length; ++i) {
                System.out.println("Result " + i + ": " + result[i]);
            }
            this.plot = new Plot("Debug SPEAII", "Y1", "Y2", true);
            this.plot.setUnconnectedPoint(0.0, 0.0, 11);
            this.plot.setUnconnectedPoint(1.2, 2.0, 11);
            GraphPointSet mySet = new GraphPointSet(10, this.plot.getFunctionArea());
            double[][] trueFitness = new double[pop.size()][];
            for (int i2 = 0; i2 < pop.size(); ++i2) {
                trueFitness[i2] = ((AbstractEAIndividual)pop.get(i2)).getFitness();
                System.out.println("Fitness: (" + trueFitness[i2][0] + "/" + trueFitness[i2][1] + ")");
            }
            mySet.setConnectedMode(false);
            for (int i3 = 0; i3 < trueFitness.length; ++i3) {
                DPoint myPoint = new DPoint(trueFitness[i3][0], trueFitness[i3][1]);
                DPointIconText tmp = new DPointIconText("" + SPEAStrength[i3] + "/" + result[i3]);
                tmp.setIcon(new DPointIconCircle());
                myPoint.setIcon(tmp);
                mySet.addDPoint(myPoint);
            }
        }
        return result;
    }

    private boolean isEqualTo(AbstractEAIndividual a1, AbstractEAIndividual a2) {
        double[] f1 = a1.getFitness();
        double[] f2 = a2.getFitness();
        for (int i = 0; i < f1.length; ++i) {
            if (!(Math.abs(f1[i] - f2[i]) > 1.0E-8)) continue;
            return false;
        }
        return false;
    }

    public double[] calculateKthDistance(Population pop, int k) {
        double[] result = new double[pop.size()];
        double[][] distMatrix = new double[pop.size()][pop.size()];
        for (int i = 0; i < pop.size(); ++i) {
            distMatrix[i][i] = 0.0;
            for (int j = i + 1; j < pop.size(); ++j) {
                distMatrix[i][j] = this.metric.distance((AbstractEAIndividual)pop.get(i), (AbstractEAIndividual)pop.get(j));
                distMatrix[j][i] = distMatrix[i][j];
            }
        }
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < k; ++j) {
                int current = -1;
                double currentSmallest = Double.MAX_VALUE;
                for (int n = 0; n < result.length; ++n) {
                    if (i == n || !(currentSmallest > distMatrix[i][n])) continue;
                    current = n;
                    currentSmallest = distMatrix[i][n];
                }
                if (current >= 0) {
                    result[i] = distMatrix[i][current];
                } else {
                    System.out.println("Error no smallest found in calculateKthDistance().");
                }
                distMatrix[i][current] = Double.MAX_VALUE;
            }
        }
        return result;
    }

    public double[] calculateSPEA(Population pop) {
        int i;
        int j;
        int i2;
        int[] SPEAStrength = new int[pop.size()];
        int[] SPEAFitness = new int[pop.size()];
        double[] SPEAResult = new double[pop.size()];
        double[][] trueFitness = new double[pop.size()][];
        for (i2 = 0; i2 < pop.size(); ++i2) {
            AbstractEAIndividual tmpIndy = (AbstractEAIndividual)pop.get(i2);
            trueFitness[i2] = tmpIndy.getFitness();
            for (j = i2 + 1; j < pop.size(); ++j) {
                if (tmpIndy.isDominating((AbstractEAIndividual)pop.get(j))) {
                    int n = i2;
                    SPEAStrength[n] = SPEAStrength[n] + 1;
                    continue;
                }
                if (!((AbstractEAIndividual)pop.get(j)).isDominating(tmpIndy)) continue;
                int n = j;
                SPEAStrength[n] = SPEAStrength[n] + 1;
            }
        }
        for (i2 = 0; i2 < pop.size(); ++i2) {
            for (j = 0; j < pop.size(); ++j) {
                if (i2 == j || !((AbstractEAIndividual)pop.get(i2)).isDominating((AbstractEAIndividual)pop.get(j))) continue;
                int n = j;
                SPEAFitness[n] = SPEAFitness[n] + SPEAStrength[i2];
            }
        }
        double[][] distMatrix = new double[pop.size()][pop.size()];
        int k = (int)Math.sqrt(pop.size());
        for (int i3 = 0; i3 < pop.size(); ++i3) {
            distMatrix[i3][i3] = 0.0;
            for (int j2 = i3 + 1; j2 < pop.size(); ++j2) {
                distMatrix[i3][j2] = this.metric.distance((AbstractEAIndividual)pop.get(i3), (AbstractEAIndividual)pop.get(j2));
                distMatrix[j2][i3] = distMatrix[i3][j2];
            }
        }
        double[] tmpD = new double[pop.size()];
        double[] D = new double[pop.size()];
        for (i = 0; i < tmpD.length; ++i) {
            tmpD[i] = Double.POSITIVE_INFINITY;
            D[i] = Double.NEGATIVE_INFINITY;
        }
        for (i = 0; i < k; ++i) {
            int j3;
            for (j3 = 0; j3 < tmpD.length; ++j3) {
                for (int n = 0; n < tmpD.length; ++n) {
                    if (!(distMatrix[j3][n] > D[j3]) || !(distMatrix[j3][n] < tmpD[j3])) continue;
                    tmpD[j3] = distMatrix[j3][n];
                }
            }
            for (j3 = 0; j3 < tmpD.length; ++j3) {
                D[j3] = tmpD[j3];
                tmpD[j3] = Double.POSITIVE_INFINITY;
            }
        }
        for (i = 0; i < SPEAResult.length; ++i) {
            if (1.0 / (2.0 + D[i]) >= 1.0) {
                System.out.println("d " + 1.0 / (2.0 + D[i]));
            }
            SPEAResult[i] = (double)SPEAFitness[i] + 1.0 / (2.0 + D[i]);
            ((AbstractEAIndividual)pop.get(i)).putData("RawFit", SPEAFitness[i]);
            ((AbstractEAIndividual)pop.get(i)).putData("SPEAFit", SPEAResult[i]);
        }
        return SPEAResult;
    }

    public String getName() {
        return "SPEA II";
    }
}

