/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.archiving;

import eva2.optimization.operator.archiving.InterfaceInformationRetrieval;
import eva2.optimization.population.Population;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This Information Retrieval will replace the current population by the archive.")
public class InformationRetrievalReplacing
implements InterfaceInformationRetrieval,
Serializable {
    public InformationRetrievalReplacing() {
    }

    public InformationRetrievalReplacing(InformationRetrievalReplacing a) {
    }

    @Override
    public Object clone() {
        return new InformationRetrievalReplacing(this);
    }

    @Override
    public void retrieveInformationFrom(Population pop) {
        Population archive = pop.getArchive();
        if (archive == null) {
            return;
        }
        Population tmp = new Population();
        tmp.addPopulation(archive);
        while (tmp.size() < archive.getTargetSize()) {
            tmp.add(pop.get(RNG.randomInt(0, pop.size() - 1)));
        }
        pop.clear();
        pop.addPopulation(tmp);
    }

    public String getName() {
        return "Replacing Information Retrieval";
    }
}

