/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.archiving;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.archiving.InterfaceRemoveSurplusIndividuals;
import eva2.optimization.population.Population;
import eva2.tools.math.RNG;
import java.io.Serializable;

public class RemoveSurplusIndividualsDynamicHyperCube
implements InterfaceRemoveSurplusIndividuals,
Serializable {
    public RemoveSurplusIndividualsDynamicHyperCube() {
    }

    public RemoveSurplusIndividualsDynamicHyperCube(RemoveSurplusIndividualsDynamicHyperCube a) {
    }

    @Override
    public Object clone() {
        return new RemoveSurplusIndividualsDynamicHyperCube(this);
    }

    @Override
    public void removeSurplusIndividuals(Population archive) {
        while (archive.targetSizeExceeded()) {
            int i;
            double[][] fitness = new double[archive.size()][];
            double[] space = new double[archive.size()];
            for (i = 0; i < archive.size(); ++i) {
                fitness[i] = ((AbstractEAIndividual)archive.get(i)).getFitness();
            }
            space = this.calculateHyperCubeVolumes(fitness);
            int indexSmallHyperCube = 0;
            for (i = 1; i < archive.size(); ++i) {
                if (space[i] < space[indexSmallHyperCube]) {
                    indexSmallHyperCube = i;
                    continue;
                }
                if (space[i] != space[indexSmallHyperCube] || !RNG.flipCoin(0.5)) continue;
                indexSmallHyperCube = i;
            }
            archive.remove(indexSmallHyperCube);
        }
    }

    public double[] calculateHyperCubeVolumes(double[][] fitness) {
        double[] result = new double[fitness.length];
        for (int i = 0; i < fitness.length; ++i) {
            result[i] = 1.0;
            for (int y = 0; y < fitness[i].length; ++y) {
                int upperI = -1;
                int lowerI = -1;
                double upperX = Double.POSITIVE_INFINITY;
                double lowerX = Double.POSITIVE_INFINITY;
                for (int j = 0; j < fitness.length; ++j) {
                    if (i == j) continue;
                    if (fitness[j][y] <= fitness[i][y] && Math.abs(fitness[j][y] - fitness[i][y]) < lowerX) {
                        lowerX = Math.abs(fitness[j][y] - fitness[i][y]);
                        lowerI = j;
                    }
                    if (!(fitness[j][y] >= fitness[i][y]) || !(Math.abs(fitness[j][y] - fitness[i][y]) < upperX)) continue;
                    upperX = Math.abs(fitness[j][y] - fitness[i][y]);
                    upperI = j;
                }
                if (upperI == -1 || lowerI == -1) {
                    int n = i;
                    result[n] = result[n] * Double.POSITIVE_INFINITY;
                    continue;
                }
                int n = i;
                result[n] = result[n] * Math.abs(Math.abs(fitness[upperI][y] - fitness[lowerI][y]));
            }
        }
        return result;
    }
}

