/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.archiving;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.archiving.InterfaceRemoveSurplusIndividuals;
import eva2.optimization.population.Population;
import eva2.tools.math.RNG;
import java.io.Serializable;

public class RemoveSurplusIndividualsSMetric
implements InterfaceRemoveSurplusIndividuals,
Serializable {
    public RemoveSurplusIndividualsSMetric() {
    }

    public RemoveSurplusIndividualsSMetric(RemoveSurplusIndividualsSMetric a) {
    }

    @Override
    public Object clone() {
        return new RemoveSurplusIndividualsSMetric(this);
    }

    @Override
    public void removeSurplusIndividuals(Population archive) {
        while (archive.targetSizeExceeded()) {
            int i;
            double[][] fitness = new double[archive.size()][];
            double[] space = new double[archive.size()];
            for (i = 0; i < archive.size(); ++i) {
                fitness[i] = ((AbstractEAIndividual)archive.get(i)).getFitness();
            }
            space = this.calculateContributingHypervolume(fitness);
            int indexSmallHyperCube = 0;
            for (i = 1; i < archive.size(); ++i) {
                if (space[i] < space[indexSmallHyperCube]) {
                    indexSmallHyperCube = i;
                    continue;
                }
                if (space[i] != space[indexSmallHyperCube] || !RNG.flipCoin(0.5)) continue;
                indexSmallHyperCube = i;
            }
            archive.remove(indexSmallHyperCube);
        }
    }

    public double[] calculateContributingHypervolume(double[][] fitness) {
        int temp;
        double temp2;
        double temp1;
        int size = fitness.length;
        double[] result = new double[size];
        int[] sort = new int[size];
        int[] global = new int[size];
        boolean[] assigned = new boolean[size];
        int counter = 0;
        int i = 0;
        while (i < fitness.length) {
            global[counter] = i++;
            ++counter;
        }
        int obj = 0;
        for (i = 0; i < size; ++i) {
            sort[i] = i;
            assigned[i] = false;
        }
        boolean changed = false;
        for (i = 0; i < counter - 1; ++i) {
            temp1 = fitness[global[sort[i]]][obj];
            temp2 = fitness[global[sort[i + 1]]][obj];
            if (!(temp1 > temp2)) continue;
            temp = sort[i];
            sort[i] = sort[i + 1];
            sort[i + 1] = temp;
            changed = true;
        }
        while (changed) {
            changed = false;
            for (i = 0; i < counter - 1; ++i) {
                temp1 = fitness[global[sort[i]]][obj];
                temp2 = fitness[global[sort[i + 1]]][obj];
                if (!(temp1 > temp2)) continue;
                temp = sort[i];
                sort[i] = sort[i + 1];
                sort[i + 1] = temp;
                changed = true;
            }
        }
        result[global[sort[0]]] = Double.MAX_VALUE;
        result[global[sort[counter - 1]]] = Double.MAX_VALUE;
        for (int e = 1; e < counter - 1; ++e) {
            i = 1;
            while (assigned[sort[i]]) {
                ++i;
            }
            int left = 0;
            while (i < counter - 1) {
                double v;
                int right = i + 1;
                while (assigned[sort[right]]) {
                    ++right;
                }
                result[global[sort[i]]] = v = (fitness[global[sort[right]]][0] - fitness[global[sort[i]]][0]) * (fitness[global[sort[left]]][1] - fitness[global[sort[i]]][1]);
                left = i;
                i = right;
            }
            int minIndex = 0;
            double min = result[global[sort[minIndex]]];
            for (int f = 1; f < counter - 1; ++f) {
                if (assigned[sort[f]] || !(result[global[sort[f]]] < min)) continue;
                min = result[global[sort[f]]];
                minIndex = f;
            }
            assigned[sort[minIndex]] = true;
            result[global[sort[minIndex]]] = e;
        }
        return result;
    }
}

