/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.classification;

import eva2.optimization.operator.classification.InterfaceClassification;
import eva2.tools.chart2d.DArea;
import eva2.tools.chart2d.DLine;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DPointIconCross;
import eva2.tools.chart2d.DRectangle;
import eva2.tools.chart2d.ScaledBorder;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

@Description(value="The Self-Organizing Maps, have been proposed by Kohonen (read this book on SOMs for further details).")
public class ClassificationSelfOrganizingMaps
implements Serializable,
InterfaceClassification {
    private static final long serialVersionUID = 1447707947002269263L;
    private int dim1 = 5;
    private int dim2 = 15;
    private int alternativeClasses;
    private double[][][] SOM;
    private int[][][] SOMClass;
    private double[][] range;
    private double alpha = 0.4;
    private int trainingCycles = 250;
    private int neighborhoodSize = 2;
    private boolean dikelThis = true;
    private boolean debug = false;

    public ClassificationSelfOrganizingMaps() {
    }

    public ClassificationSelfOrganizingMaps(ClassificationSelfOrganizingMaps a) {
        int j;
        int i;
        this.dim1 = a.dim1;
        this.dim2 = a.dim2;
        this.alternativeClasses = a.alternativeClasses;
        this.neighborhoodSize = a.neighborhoodSize;
        this.alpha = a.alpha;
        this.dikelThis = a.dikelThis;
        this.trainingCycles = a.trainingCycles;
        if (a.SOM != null) {
            this.SOM = new double[a.SOM.length][a.SOM[0].length][a.SOM[0][0].length];
            for (i = 0; i < a.SOM.length; ++i) {
                for (j = 0; j < a.SOM[0].length; ++j) {
                    System.arraycopy(a.SOM[i][j], 0, this.SOM[i][j], 0, a.SOM[0][0].length);
                }
            }
        }
        if (a.SOMClass != null) {
            this.SOMClass = new int[a.SOMClass.length][a.SOMClass[0].length][a.SOMClass[0][0].length];
            for (i = 0; i < a.SOMClass.length; ++i) {
                for (j = 0; j < a.SOMClass[0].length; ++j) {
                    System.arraycopy(a.SOMClass[i][j], 0, this.SOMClass[i][j], 0, a.SOMClass[0][0].length);
                }
            }
        }
        if (a.range != null) {
            this.range = new double[a.range.length][4];
            for (i = 0; i < this.range.length; ++i) {
                this.range[i][0] = a.range[i][0];
                this.range[i][1] = a.range[i][1];
                this.range[i][2] = a.range[i][2];
                this.range[i][3] = a.range[i][3];
            }
        }
    }

    @Override
    public Object clone() {
        return new ClassificationSelfOrganizingMaps(this);
    }

    @Override
    public void init(double[][] space, int[] type) {
        int i;
        this.alternativeClasses = 0;
        for (i = 0; i < type.length; ++i) {
            this.alternativeClasses = Math.max(type[i], this.alternativeClasses);
        }
        ++this.alternativeClasses;
        this.SOM = new double[this.dim1][this.dim2][space[0].length];
        this.SOMClass = new int[this.dim1][this.dim2][this.alternativeClasses];
        this.range = new double[space[0].length][4];
        for (i = 0; i < this.range.length; ++i) {
            this.range[i][0] = Double.POSITIVE_INFINITY;
            this.range[i][1] = Double.NEGATIVE_INFINITY;
            this.range[i][2] = 0.0;
            this.range[i][3] = 0.0;
        }
        for (i = 0; i < space.length; ++i) {
            for (int k = 0; k < space[0].length; ++k) {
                this.range[k][0] = Math.min(this.range[k][0], space[i][k]);
                this.range[k][1] = Math.max(this.range[k][1], space[i][k]);
                double[] dArray = this.range[k];
                dArray[2] = dArray[2] + space[i][k];
            }
        }
        for (i = 0; i < this.range.length; ++i) {
            double[] dArray = this.range[i];
            dArray[2] = dArray[2] / (double)space.length;
            for (int j = 0; j < space.length; ++j) {
                double[] dArray2 = this.range[i];
                dArray2[3] = dArray2[3] + Math.pow(this.range[i][2] - space[j][i], 2.0);
            }
            this.range[i][3] = Math.sqrt(this.range[i][3] / (double)space.length);
        }
        this.initSOM();
    }

    private void initSOM() {
        for (int i = 0; i < this.SOM.length; ++i) {
            for (int j = 0; j < this.SOM[0].length; ++j) {
                int k;
                for (k = 0; k < this.SOM[0][0].length; ++k) {
                    this.SOM[i][j][k] = 0.0 * RNG.randomDouble((this.range[k][0] - this.range[k][2]) / (1.0 + this.range[k][3]), (this.range[k][1] - this.range[k][2]) / (1.0 + this.range[k][3]));
                }
                for (k = 0; k < this.SOMClass[0][0].length; ++k) {
                    this.SOMClass[i][j][k] = 0;
                }
            }
        }
    }

    @Override
    public void train(double[][] space, int[] type) {
        for (int i = 0; i < this.SOM.length; ++i) {
            for (int j = 0; j < this.SOM[0].length; ++j) {
                for (int k = 0; k < this.SOMClass[0][0].length; ++k) {
                    this.SOMClass[i][j][k] = 0;
                }
            }
        }
        for (int t = 0; t < this.trainingCycles; ++t) {
            int[] order = RNG.randomPerm(space.length);
            for (int i = 0; i < order.length; ++i) {
                int[] winner = this.findWinningNeuron(space[order[i]]);
                this.update(winner, space[order[i]], (double)t / (double)this.trainingCycles);
            }
        }
        for (int i = 0; i < space.length; ++i) {
            int[] winner = this.findWinningNeuron(space[i]);
            int[] nArray = this.SOMClass[winner[0]][winner[1]];
            int n = type[i];
            nArray[n] = nArray[n] + 1;
        }
        if (this.debug) {
            this.drawSOM(space, type);
        }
    }

    private void update(int[] w, double[] data, double t) {
        double a = this.alpha * (1.0 - t);
        int[] tmpI = new int[2];
        if (this.dikelThis) {
            this.drikelWinnerTo(w, data, a);
        } else {
            this.moveNeuronTo(w, data, a);
        }
        for (int i = -this.neighborhoodSize; i <= this.neighborhoodSize; ++i) {
            for (int j = -this.neighborhoodSize; j <= this.neighborhoodSize; ++j) {
                if (j == 0 && i == 0 || this.SOM.length <= w[0] + i || w[0] + i < 0 || this.SOM[0].length <= w[1] + j || w[1] + j < 0) continue;
                double dist = Math.sqrt(i * i + j * j);
                tmpI[0] = w[0] + i;
                tmpI[1] = w[1] + j;
                this.moveNeuronTo(tmpI, data, a / dist);
            }
        }
    }

    private int[] findWinningNeuron(double[] data) {
        double minDist = Double.POSITIVE_INFINITY;
        int[] result = new int[]{0, 0};
        for (int m = 0; m < this.SOM.length; ++m) {
            for (int n = 0; n < this.SOM[0].length; ++n) {
                double dist = this.distance(this.SOM[m][n], data);
                if (!(minDist > dist)) continue;
                minDist = dist;
                result[0] = m;
                result[1] = n;
            }
        }
        return result;
    }

    public double distance(double[] n, double[] d) {
        double result = 0.0;
        for (int i = 0; i < n.length; ++i) {
            result += Math.pow(n[i] - (d[i] - this.range[i][2]) / (1.0 + this.range[i][3]), 2.0);
        }
        result = Math.sqrt(result);
        return result;
    }

    public void moveNeuronTo(int[] w, double[] d, double a) {
        double[] vec = new double[this.SOM[w[0]][w[1]].length];
        for (int i = 0; i < this.SOM[w[0]][w[1]].length; ++i) {
            vec[i] = (d[i] - this.range[i][2]) / (1.0 + this.range[i][3]) - this.SOM[w[0]][w[1]][i];
            double[] dArray = this.SOM[w[0]][w[1]];
            int n = i;
            dArray[n] = dArray[n] + a * vec[i];
        }
    }

    public void drikelWinnerTo(int[] w, double[] d, double a) {
        int i;
        double[] vec = new double[this.SOM[w[0]][w[1]].length];
        double[] nec = new double[this.SOM[w[0]][w[1]].length];
        for (i = 0; i < this.SOM[w[0]][w[1]].length; ++i) {
            vec[i] = (d[i] - this.range[i][2]) / (1.0 + this.range[i][3]) - this.SOM[w[0]][w[1]][i];
            nec[i] = 0.0;
        }
        for (i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (j == 0 && i == 0 || this.SOM.length <= w[0] + i || w[0] + i < 0 || this.SOM[0].length <= w[1] + j || w[1] + j < 0) continue;
                for (int k = 0; k < this.SOM[0][0].length; ++k) {
                    int n = k;
                    nec[n] = nec[n] + ((d[k] - this.range[k][2]) / (1.0 + this.range[k][3]) - this.SOM[w[0] + i][w[1] + j][k]);
                }
            }
        }
        for (i = 0; i < this.SOM[w[0]][w[1]].length; ++i) {
            int n = i;
            vec[n] = vec[n] - a / 2.0 * nec[i];
            double[] dArray = this.SOM[w[0]][w[1]];
            int n2 = i;
            dArray[n2] = dArray[n2] + a * vec[i];
        }
    }

    @Override
    public int getClassFor(double[] point) {
        int[] winner = this.findWinningNeuron(point);
        int mostClasses = 0;
        int result = 0;
        for (int i = 0; i < this.SOMClass[winner[0]][winner[1]].length; ++i) {
            if (mostClasses >= this.SOMClass[winner[0]][winner[1]][i]) continue;
            result = i;
            mostClasses = this.SOMClass[winner[0]][winner[1]][i];
        }
        return result;
    }

    private void drawSOM(double[][] data, int[] types) {
        JFrame frame = new JFrame();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        frame.setTitle("SOM tester");
        frame.setSize(500, 500);
        frame.setLocation(530, 50);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                System.exit(0);
            }
        });
        ScaledBorder myBorder = new ScaledBorder();
        DArea area = new DArea();
        area.setBorder(myBorder);
        area.setBackground(Color.white);
        for (int i = 0; i < this.SOM.length; ++i) {
            for (int j = 0; j < this.SOM[0].length; ++j) {
                DLine tmpL;
                double[] pos2;
                double[] pos1 = this.SOM[i][j];
                if (i + 1 < this.SOM.length) {
                    pos2 = this.SOM[i + 1][j];
                    tmpL = new DLine(pos1[0], pos1[1], pos2[0], pos2[1], Color.BLACK);
                    area.addDElement(tmpL);
                }
                if (j + 1 >= this.SOM[i].length) continue;
                pos2 = this.SOM[i][j + 1];
                tmpL = new DLine(pos1[0], pos1[1], pos2[0], pos2[1], Color.BLACK);
                area.addDElement(tmpL);
            }
        }
        for (int i = 0; i < data.length; ++i) {
            DPoint tmpP = new DPoint((data[i][0] - this.range[0][2]) / (1.0 + this.range[0][3]), (data[i][1] - this.range[1][2]) / (1.0 + this.range[1][3]));
            tmpP.setIcon(new DPointIconCross());
            tmpP.setColor(this.getColorFor(types[i]));
            area.addDElement(tmpP);
        }
        panel.add((Component)area, "Center");
        frame.getContentPane().add(panel);
        frame.validate();
        frame.setVisible(true);
    }

    public JComponent getViewOnSOM() {
        DArea result = new DArea();
        result.setBackground(Color.WHITE);
        result.setVisibleRectangle(0.0, 0.0, this.SOM.length, this.SOM[0].length);
        result.setPreferredSize(new Dimension(this.SOM.length * 10, this.SOM[0].length * 10));
        result.setMinimumSize(new Dimension(this.SOM.length * 2, this.SOM[0].length * 2));
        for (int i = 0; i < this.SOM.length; ++i) {
            for (int j = 0; j < this.SOM[i].length; ++j) {
                DRectangle tmpRect;
                int k;
                double total = 0.0;
                double currentP = 0.0;
                double lastP = 0.0;
                for (k = 0; k < this.SOMClass[i][j].length; ++k) {
                    total += (double)this.SOMClass[i][j][k];
                }
                for (k = 0; k < this.SOMClass[i][j].length; ++k) {
                    currentP = (double)this.SOMClass[i][j][k] / total;
                    if (!(currentP > 0.0)) continue;
                    tmpRect = new DRectangle(i, (double)j + lastP, 1.0, currentP);
                    tmpRect.setColor(this.getColorFor(k));
                    tmpRect.setFillColor(this.getColorFor(k));
                    result.addDElement(tmpRect);
                    lastP += currentP;
                }
                tmpRect = new DRectangle(i, j, 1.0, 1.0);
                tmpRect.setColor(Color.BLACK);
                tmpRect.setFillColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
                result.addDElement(tmpRect);
            }
        }
        return result;
    }

    private Color getColorFor(int i) {
        switch (i) {
            case 0: {
                return Color.BLUE;
            }
            case 1: {
                return Color.RED;
            }
            case 2: {
                return Color.GREEN;
            }
            case 3: {
                return Color.CYAN;
            }
            case 4: {
                return Color.ORANGE;
            }
            case 5: {
                return Color.MAGENTA;
            }
            case 6: {
                return Color.YELLOW;
            }
            case 7: {
                return Color.PINK;
            }
            case 8: {
                return Color.GRAY;
            }
        }
        return Color.LIGHT_GRAY;
    }

    public static void main(String[] args) {
        ClassificationSelfOrganizingMaps som = new ClassificationSelfOrganizingMaps();
        som.setSizeX(5);
        som.setSizeY(25);
        int num = 25;
        double[][] data = new double[num * 2][2];
        int[] type = new int[num * 2];
        for (int i = 0; i < num; ++i) {
            data[i][0] = -0.8 + RNG.gaussianDouble(0.3);
            data[i][1] = -0.5 + RNG.gaussianDouble(0.1);
            type[i] = 0;
            data[i + num][0] = 0.1 + RNG.gaussianDouble(0.1);
            data[i + num][1] = 0.2 + RNG.gaussianDouble(0.1);
            type[i + num] = 1;
        }
        som.init(data, type);
        som.train(data, type);
    }

    public String getName() {
        return "Self-Organizing Maps";
    }

    public void setSizeX(int t) {
        if (t < 1) {
            t = 1;
        }
        this.dim1 = t;
    }

    public int getSizeX() {
        return this.dim1;
    }

    public String sizeXTipText() {
        return "Set the number of neurons in x dimension.";
    }

    public void setSizeY(int t) {
        if (t < 1) {
            t = 1;
        }
        this.dim2 = t;
    }

    public int getSizeY() {
        return this.dim2;
    }

    public String sizeYTipText() {
        return "Set the number of neurons in y dimension.";
    }

    public void setTrainingCycles(int t) {
        if (t < 1) {
            t = 1;
        }
        this.trainingCycles = t;
    }

    public int getTrainingCycles() {
        return this.trainingCycles;
    }

    public String trainingCyclesTipText() {
        return "Set the number of training cycles to perform.";
    }

    public void setNeighborhoodSize(int t) {
        if (t < 0) {
            t = 0;
        }
        this.neighborhoodSize = t;
    }

    public int getNeighborhoodSize() {
        return this.neighborhoodSize;
    }

    public String neighborhoodSizeTipText() {
        return "Set the size of the neighborhood.";
    }

    public void setAlpha(double t) {
        if (t < 0.0) {
            t = 0.0;
        }
        if (t > 0.5) {
            t = 0.5;
        }
        this.alpha = t;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public String AlphaTipText() {
        return "Choose the initial alpha (0-0.5).";
    }

    public void setDikelThis(boolean t) {
        this.dikelThis = t;
    }

    public boolean getDikelThis() {
        return this.dikelThis;
    }

    public String dikelThisTipText() {
        return "Activate attractive neignbors for the winner neuron.";
    }
}

