/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.cluster;

import eva2.optimization.operator.cluster.InterfaceClustering;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.Arrays;

@Description(value="A dummy clustering implementation which assigns all elements to a single cluster.")
public class ClusterAll
implements InterfaceClustering,
Serializable {
    private boolean assignLoners = false;

    @Override
    public Object clone() {
        return new ClusterAll();
    }

    @Override
    public int[] associateLoners(Population loners, Population[] species, Population referenceSet) {
        if (loners != null && loners.size() > 0) {
            int[] indices = new int[loners.size()];
            if (this.assignLoners) {
                Arrays.fill(indices, 0);
            } else {
                Arrays.fill(indices, -1);
            }
            return indices;
        }
        return null;
    }

    @Override
    public Population[] cluster(Population pop, Population referenceSet) {
        return new Population[]{pop.cloneWithoutInds(), pop.cloneShallowInds()};
    }

    @Override
    public String initClustering(Population pop) {
        return null;
    }

    @Override
    public boolean mergingSpecies(Population species1, Population species2, Population referenceSet) {
        return true;
    }

    public String getName() {
        return "Cluster-all";
    }
}

