/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.cluster;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.cluster.InterfaceClusteringDistanceParam;
import eva2.optimization.operator.cluster.InterfaceClusteringMetricBased;
import eva2.optimization.operator.distancemetric.InterfaceDistanceMetric;
import eva2.optimization.operator.distancemetric.PhenotypeMetric;
import eva2.optimization.population.Population;
import eva2.tools.Pair;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.ArrayList;

@Description(value="A density-based clustering algorithm (DBSCAN).")
public class ClusteringDensityBased
implements InterfaceClusteringDistanceParam,
InterfaceClusteringMetricBased,
Serializable {
    private InterfaceDistanceMetric metric = new PhenotypeMetric();
    private double clusterDistance = 0.1;
    private int minimumGroupSize = 3;
    private boolean[][] connectionMatrix;
    private boolean[] clustered;
    private boolean testConvergingSpeciesOnBestOnly = true;

    public ClusteringDensityBased() {
    }

    public ClusteringDensityBased(double sigma) {
        this.clusterDistance = sigma;
    }

    public ClusteringDensityBased(double sigma, int minGSize) {
        this.clusterDistance = sigma;
        this.minimumGroupSize = minGSize;
    }

    public ClusteringDensityBased(double sigma, int minGSize, InterfaceDistanceMetric metric) {
        this.clusterDistance = sigma;
        this.minimumGroupSize = minGSize;
        this.metric = metric;
    }

    public ClusteringDensityBased(ClusteringDensityBased a) {
        if (a.metric != null) {
            this.metric = (InterfaceDistanceMetric)a.metric.clone();
        }
        this.testConvergingSpeciesOnBestOnly = a.testConvergingSpeciesOnBestOnly;
        this.clusterDistance = a.clusterDistance;
        this.minimumGroupSize = a.minimumGroupSize;
        if (a.clustered != null) {
            this.clustered = new boolean[a.clustered.length];
            System.arraycopy(a.clustered, 0, this.clustered, 0, this.clustered.length);
        }
        if (a.connectionMatrix != null) {
            this.connectionMatrix = new boolean[a.connectionMatrix.length][a.connectionMatrix[0].length];
            for (int i = 0; i < this.connectionMatrix.length; ++i) {
                System.arraycopy(a.connectionMatrix[i], 0, this.connectionMatrix[i], 0, this.connectionMatrix[i].length);
            }
        }
    }

    @Override
    public Object clone() {
        return new ClusteringDensityBased(this);
    }

    @Override
    public Population[] cluster(Population pop, Population referencePop) {
        int i;
        this.connectionMatrix = new boolean[pop.size()][pop.size()];
        this.clustered = new boolean[pop.size()];
        ArrayList<Population> ClusteredPopulations = new ArrayList<Population>();
        Population template = (Population)pop.clone();
        template.clear();
        Population PopulationOfUnclustered = (Population)template.clone();
        ClusteredPopulations.add(PopulationOfUnclustered);
        for (i = 0; i < pop.size(); ++i) {
            AbstractEAIndividual tmpIndy1 = (AbstractEAIndividual)pop.get(i);
            this.connectionMatrix[i][i] = true;
            for (int j = i + 1; j < pop.size(); ++j) {
                AbstractEAIndividual tmpIndy2 = (AbstractEAIndividual)pop.get(j);
                if (tmpIndy1 == null || tmpIndy2 == null) {
                    System.err.println("Warning: Individual should not be null (ClusteringDensityBased)!");
                }
                if (tmpIndy1 != null && tmpIndy2 != null && this.metric.distance(tmpIndy1, tmpIndy2) < this.clusterDistance) {
                    this.connectionMatrix[i][j] = true;
                    this.connectionMatrix[j][i] = true;
                    continue;
                }
                this.connectionMatrix[i][j] = false;
                this.connectionMatrix[j][i] = false;
            }
        }
        for (i = 0; i < this.clustered.length; ++i) {
            this.clustered[i] = false;
        }
        for (i = 0; i < this.connectionMatrix.length; ++i) {
            if (this.clustered[i]) continue;
            Population Cluster2 = (Population)template.clone();
            this.addRowToPopulation(i, Cluster2, pop);
            if (Cluster2.size() >= this.minimumGroupSize) {
                ClusteredPopulations.add(Cluster2);
                continue;
            }
            PopulationOfUnclustered.addPopulation(Cluster2);
        }
        Population[] result = new Population[ClusteredPopulations.size()];
        for (int i2 = 0; i2 < ClusteredPopulations.size(); ++i2) {
            result[i2] = (Population)ClusteredPopulations.get(i2);
        }
        return result;
    }

    private void addRowToPopulation(int index, Population cluster, Population source) {
        for (int i = 0; i < this.connectionMatrix[index].length; ++i) {
            if (this.clustered[i] || !this.connectionMatrix[index][i]) continue;
            this.clustered[i] = true;
            this.connectionMatrix[index][i] = false;
            this.connectionMatrix[i][index] = false;
            cluster.add(source.get(i));
            this.addRowToPopulation(i, cluster, source);
        }
    }

    @Override
    public boolean mergingSpecies(Population species1, Population species2, Population referencePop) {
        if (this.testConvergingSpeciesOnBestOnly) {
            double specDist = this.metric.distance(species1.getBestEAIndividual(), species2.getBestEAIndividual());
            return specDist < this.clusterDistance;
        }
        Population tmpPop = new Population(species1.size() + species2.size());
        tmpPop.addPopulation(species1);
        tmpPop.addPopulation(species2);
        return this.cluster(tmpPop, referencePop).length <= 2;
    }

    @Override
    public int[] associateLoners(Population loners, Population[] species, Population referencePop) {
        int[] res = new int[loners.size()];
        for (int l = 0; l < loners.size(); ++l) {
            double minDist = -1.0;
            res[l] = -1;
            for (int spI = 0; spI < species.length; ++spI) {
                Pair<Integer, Double> iDist = Population.getClosestFarthestIndy(loners.getEAIndividual(l), species[spI], this.metric, true);
                if (!(iDist.tail() < this.clusterDistance) || !(minDist < 0.0) && !(iDist.tail() < minDist)) continue;
                res[l] = spI;
            }
        }
        return res;
    }

    public String getName() {
        return "DBSCAN";
    }

    @Override
    public InterfaceDistanceMetric getMetric() {
        return this.metric;
    }

    @Override
    public void setMetric(InterfaceDistanceMetric m) {
        this.metric = m;
    }

    public String metricTipText() {
        return "Choose the distance metric to use.";
    }

    public int getMinimumGroupSize() {
        return this.minimumGroupSize;
    }

    public void setMinimumGroupSize(int m) {
        if (m < 1) {
            m = 1;
        }
        this.minimumGroupSize = m;
    }

    public String minimumGroupSizeTipText() {
        return "Set the minimum group size for the DBSCAN method.";
    }

    @Override
    public String initClustering(Population pop) {
        return null;
    }

    @Override
    public double getClustDistParam() {
        return this.clusterDistance;
    }

    @Override
    public void setClustDistParam(double m) {
        if (m < 0.0) {
            m = 0.0;
        }
        this.clusterDistance = m;
    }

    public String clustDistTipText() {
        return "Set the distance threshhold for the DBSCAN method.";
    }
}

