/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.cluster;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.EAIndividualComparator;
import eva2.optimization.individuals.IndividualDistanceComparator;
import eva2.optimization.operator.cluster.InterfaceClustering;
import eva2.optimization.operator.distancemetric.EuclideanMetric;
import eva2.optimization.operator.distancemetric.InterfaceDistanceMetric;
import eva2.optimization.operator.distancemetric.PhenotypeMetric;
import eva2.optimization.population.Population;
import eva2.tools.Pair;
import java.io.Serializable;
import java.util.ArrayList;

public class ClusteringDynPeakIdent
implements InterfaceClustering,
Serializable {
    private int numNiches;
    private double nicheRadius;
    private int maxNicheCount;
    private boolean strictNicheRadius = true;
    InterfaceDistanceMetric metric = new PhenotypeMetric();

    public ClusteringDynPeakIdent(int numNs, int numIndiesPerPeak, double nicheRad, boolean strictRad, InterfaceDistanceMetric alternativeMetric) {
        this.numNiches = numNs;
        this.maxNicheCount = numIndiesPerPeak;
        this.nicheRadius = nicheRad;
        this.strictNicheRadius = strictRad;
        if (this.metric == null && alternativeMetric == null) {
            this.metric = new PhenotypeMetric();
        } else if (alternativeMetric != null) {
            this.metric = alternativeMetric;
        }
    }

    public ClusteringDynPeakIdent(ClusteringDynPeakIdent o) {
        this(o.numNiches, o.maxNicheCount, o.nicheRadius, o.strictNicheRadius, o.metric);
    }

    @Override
    public Object clone() {
        return new ClusteringDynPeakIdent(this);
    }

    @Override
    public int[] associateLoners(Population loners, Population[] species, Population referenceSet) {
        Population bests = new Population(species.length);
        for (int i = 0; i < species.length; ++i) {
            bests.add(species[i].getBestEAIndividual());
        }
        return this.assignLeaders(loners, bests);
    }

    protected int[] assignLeaders(Population loners, Population bests) {
        int[] assoc = new int[loners.size()];
        for (int i = 0; i < loners.size(); ++i) {
            Pair<Integer, Double> closestInfo = Population.getClosestFarthestIndy(loners.getEAIndividual(i), bests, this.metric, true);
            assoc[i] = !this.strictNicheRadius || closestInfo.tail() < this.nicheRadius ? closestInfo.head() : -1;
        }
        return assoc;
    }

    @Override
    public Population[] cluster(Population pop, Population referenceSet) {
        int i;
        EAIndividualComparator eaComparator = new EAIndividualComparator(-1);
        Population sorted = pop.getSortedBestFirst(eaComparator);
        Population peaks = ClusteringDynPeakIdent.performDynPeakIdent(this.metric, sorted, this.numNiches, this.nicheRadius);
        Population[] clusters = new Population[peaks.size() + 1];
        for (int i2 = 0; i2 < clusters.length; ++i2) {
            clusters[i2] = referenceSet.cloneWithoutInds();
            if (i2 <= 0) continue;
            clusters[i2].add(peaks.getEAIndividual(i2 - 1));
        }
        Population rest = pop.filter(peaks);
        if (pop.getRedundancyCount() > 0) {
            System.err.println("warning, found redundant indies: " + pop.getRedundancyCount());
            rest.removeRedundantIndies();
        }
        if (rest.size() + peaks.size() + pop.getRedundancyCount() != pop.size()) {
            System.err.println("Warning, inconsistent filtering in ClusteringDynPeakIdent! Redundant: " + pop.getRedundancyCount());
        }
        int[] assoc = this.assignLeaders(rest, peaks);
        for (int i3 = 0; i3 < assoc.length; ++i3) {
            if (assoc[i3] >= 0) {
                clusters[assoc[i3] + 1].add(rest.getEAIndividual(i3));
                continue;
            }
            clusters[0].add(rest.getEAIndividual(i3));
        }
        int cnt = clusters[0].size();
        for (i = 1; i < clusters.length; ++i) {
            cnt += clusters[i].size();
            if (clusters[i].size() != 0) continue;
            System.err.println("Warning!!!");
        }
        if (cnt != pop.size() - pop.getRedundancyCount()) {
            System.err.println("Another warning!!  " + cnt + " vs. " + pop.size());
        }
        if (this.maxNicheCount > 0) {
            for (i = 1; i < clusters.length; ++i) {
                if (clusters[i].size() <= this.maxNicheCount) continue;
                ArrayList<AbstractEAIndividual> overhd = clusters[i].getSorted(new IndividualDistanceComparator(peaks.getEAIndividual(i - 1), new EuclideanMetric(), true));
                Population overhead = new Population();
                overhead.addAll(Population.toTail(clusters[i].size() - this.maxNicheCount, overhd));
                clusters[i].removeMembers(overhead, true);
                clusters[0].addPopulation(overhead);
            }
        }
        return clusters;
    }

    @Override
    public String initClustering(Population pop) {
        return null;
    }

    @Override
    public boolean mergingSpecies(Population species1, Population species2, Population referenceSet) {
        return this.metric.distance(species1.getBestEAIndividual(), species2.getBestEAIndividual()) < this.nicheRadius;
    }

    public static Population performDynPeakIdent(InterfaceDistanceMetric metric, Population sortedPop, int q, double rho) {
        Population peaks = new Population(q);
        for (int i = 0; i < sortedPop.size() && peaks.size() < q; ++i) {
            if (peaks.size() != 0 && peaks.isWithinPopDist((AbstractEAIndividual)sortedPop.get(i), rho, metric)) continue;
            peaks.add(sortedPop.get(i));
        }
        return peaks;
    }

    public boolean isStrictNicheRadius() {
        return this.strictNicheRadius;
    }

    public void setStrictNicheRadius(boolean strictNicheRadius) {
        this.strictNicheRadius = strictNicheRadius;
    }

    public String strictNicheRadiusTipText() {
        return "If false, any individual will be assigned its closest peak; if true, it must be within the niche radius to be assigend and remains unclustered otherwise.";
    }

    public void setNicheRadius(double r) {
        this.nicheRadius = r;
    }

    public double getNicheRadius() {
        return this.nicheRadius;
    }

    public String nicheRadiusTipText() {
        return "Distance below which two individuals are assumed to belong to the same niche";
    }
}

