/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.cluster;

import eva2.gui.plot.GraphPointSet;
import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.cluster.InterfaceClustering;
import eva2.optimization.operator.distancemetric.EuclideanMetric;
import eva2.optimization.operator.distancemetric.InterfaceDistanceMetric;
import eva2.optimization.population.Population;
import eva2.problems.F1Problem;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DPointIconCircle;
import eva2.tools.chart2d.DPointIconText;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.Arrays;

@Description(value="Oldy but goldy: K-Means clustering.")
public class ClusteringKMeans
implements InterfaceClustering,
Serializable {
    private int k = 5;
    private double[][] c = null;
    private double mergeDist = 0.001;
    private boolean useSearchSpace = true;
    private boolean reuseC = false;
    private boolean debug = false;
    private int minClustSize = 1;
    InterfaceDistanceMetric metric = new EuclideanMetric();
    AbstractEAIndividual tmpIndy = null;

    public ClusteringKMeans() {
    }

    public ClusteringKMeans(ClusteringKMeans a) {
        this.debug = a.debug;
        this.k = a.k;
        this.useSearchSpace = a.useSearchSpace;
        this.metric = a.metric;
        this.minClustSize = a.minClustSize;
        this.mergeDist = a.mergeDist;
        if (a.c != null) {
            this.c = new double[a.c.length][a.c[0].length];
            for (int i = 0; i < this.c.length; ++i) {
                System.arraycopy(a.c[i], 0, this.c[i], 0, this.c[i].length);
            }
        }
    }

    @Override
    public Object clone() {
        return new ClusteringKMeans(this);
    }

    @Override
    public Population[] cluster(Population pop, Population referencePop) {
        if (pop.size() < this.k) {
            Population[] res = new Population[]{pop.cloneShallowInds()};
            return res;
        }
        this.tmpIndy = (AbstractEAIndividual)pop.getEAIndividual(0).clone();
        if (!this.reuseC || this.c == null) {
            this.c = new double[this.k][];
            Population initialSeeds = pop.getRandNIndividuals(this.k);
            for (int i = 0; i < this.k; ++i) {
                this.c[i] = this.useSearchSpace ? (double[])initialSeeds.getEAIndividual(i).getDoublePosition().clone() : (double[])initialSeeds.getEAIndividual(i).getFitness().clone();
            }
        }
        boolean finished = false;
        int[] assignment = new int[pop.size()];
        while (!finished) {
            DPointIconText tmp;
            DPoint myPoint;
            int i;
            int j;
            int i2;
            for (i2 = 0; i2 < pop.size(); ++i2) {
                int assign = 0;
                for (j = 1; j < this.c.length; ++j) {
                    if (!(this.distance(pop.getEAIndividual(i2), this.c[assign]) > this.distance(pop.getEAIndividual(i2), this.c[j]))) continue;
                    assign = j;
                }
                assignment[i2] = assign;
            }
            double[][] newC = new double[this.k][this.c[0].length];
            int[] numbOfAssigned = new int[this.k];
            for (i2 = 0; i2 < newC.length; ++i2) {
                numbOfAssigned[i2] = 1;
                System.arraycopy(this.c[i2], 0, newC[i2], 0, newC[i2].length);
            }
            for (i2 = 0; i2 < assignment.length; ++i2) {
                int n = assignment[i2];
                numbOfAssigned[n] = numbOfAssigned[n] + 1;
                for (j = 0; j < newC[assignment[i2]].length; ++j) {
                    if (this.useSearchSpace) {
                        double[] dArray = newC[assignment[i2]];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + pop.getEAIndividual(i2).getDoublePosition()[j];
                        continue;
                    }
                    double[] dArray = newC[assignment[i2]];
                    int n3 = j;
                    dArray[n3] = dArray[n3] + pop.getEAIndividual(i2).getFitness(j);
                }
            }
            for (i2 = 0; i2 < newC.length; ++i2) {
                for (j = 0; j < newC[i2].length; ++j) {
                    if (numbOfAssigned[i2] <= 1) continue;
                    double[] dArray = newC[i2];
                    int n = j;
                    dArray[n] = dArray[n] / (double)numbOfAssigned[i2];
                }
            }
            if (this.debug) {
                double[] tmpD = new double[]{0.0, 0.0};
                Plot plot = new Plot("Debugging K-Means Clustering", "Y1", "Y2", tmpD, tmpD);
                for (int i3 = 0; i3 < pop.size(); ++i3) {
                    double[] x = ((InterfaceDataTypeDouble)pop.get(i3)).getDoubleData();
                    plot.setUnconnectedPoint(x[0], x[1], 1);
                }
                for (i = 0; i < this.c.length; ++i) {
                    GraphPointSet mySet = new GraphPointSet(10 + i, plot.getFunctionArea());
                    mySet.setConnectedMode(true);
                    myPoint = new DPoint(this.c[i][0], this.c[i][1]);
                    tmp = new DPointIconText("Old: " + i);
                    tmp.setIcon(new DPointIconCircle());
                    myPoint.setIcon(tmp);
                    mySet.addDPoint(myPoint);
                    myPoint = new DPoint(newC[i][0], newC[i][1]);
                    tmp = new DPointIconText("New: " + i);
                    tmp.setIcon(new DPointIconCircle());
                    myPoint.setIcon(tmp);
                    mySet.addDPoint(myPoint);
                }
            }
            if (this.debug) {
                double[] tmpD = new double[]{0.0, 0.0};
                Plot plot = new Plot("Debugging Cluster", "Y1", "Y2", tmpD, tmpD);
                for (i = 0; i < pop.size(); ++i) {
                    GraphPointSet mySet = new GraphPointSet(11, plot.getFunctionArea());
                    mySet.setConnectedMode(false);
                    double[] x = pop.getEAIndividual(i).getDoublePosition();
                    myPoint = new DPoint(x[0], x[1]);
                    tmp = new DPointIconText("" + assignment[i]);
                    if (assignment[i] % 2 == 0) {
                        tmp.setIcon(new DPointIconCircle());
                    }
                    myPoint.setIcon(tmp);
                    mySet.addDPoint(myPoint);
                }
            }
            finished = true;
            for (i2 = 0; i2 < this.c.length; ++i2) {
                if (EuclideanMetric.euclideanDistance(this.c[i2], newC[i2]) > 1.0E-4) {
                    finished = false;
                }
                this.c[i2] = newC[i2];
            }
        }
        Population[] result = this.cluster(pop, this.c);
        if (this.debug) {
            double[] tmpD = new double[]{0.0, 0.0};
            Plot plot = new Plot("Debugging Clustering Separation", "Y1", "Y2", tmpD, tmpD);
            for (int i = 0; i < result.length; ++i) {
                GraphPointSet mySet = new GraphPointSet(11, plot.getFunctionArea());
                mySet.setConnectedMode(false);
                for (int j = 0; j < result[i].size(); ++j) {
                    double[] x = ((InterfaceDataTypeDouble)result[i].get(j)).getDoubleData();
                    DPoint myPoint = new DPoint(x[0], x[1]);
                    DPointIconText tmp = new DPointIconText("" + i);
                    if (i % 2 == 0) {
                        tmp.setIcon(new DPointIconCircle());
                    }
                    myPoint.setIcon(tmp);
                    mySet.addDPoint(myPoint);
                }
            }
        }
        int largeEnough = 0;
        for (int i = 0; i < result.length; ++i) {
            if (result[i].size() < this.getMinClustSize()) continue;
            ++largeEnough;
        }
        Population[] resExpanded = new Population[largeEnough + 1];
        resExpanded[0] = pop.cloneWithoutInds();
        int lastIndex = 1;
        for (int i = 0; i < result.length; ++i) {
            if (result[i].size() >= this.getMinClustSize()) {
                resExpanded[lastIndex] = result[i];
                ++lastIndex;
                continue;
            }
            resExpanded[0].addPopulation(result[i]);
        }
        this.tmpIndy = null;
        return resExpanded;
    }

    public Population[] cluster(Population pop, double[][] c) {
        int i;
        if (this.tmpIndy == null) {
            this.tmpIndy = (AbstractEAIndividual)pop.getEAIndividual(0).clone();
        }
        Population[] result = new Population[c.length];
        try {
            for (i = 0; i < result.length; ++i) {
                result[i] = (Population)pop.getClass().newInstance();
                result[i].setSameParams(pop);
            }
        }
        catch (Exception e) {
            System.err.println("problems instantiating " + pop.getClass().getName() + " for clustering!");
            e.printStackTrace();
        }
        for (i = 0; i < pop.size(); ++i) {
            int clusterAssigned = 0;
            for (int j = 1; j < c.length; ++j) {
                if (!(this.distance(pop.getEAIndividual(i), c[clusterAssigned]) > this.distance(pop.getEAIndividual(i), c[j]))) continue;
                clusterAssigned = j;
            }
            result[clusterAssigned].add(pop.get(i));
        }
        return result;
    }

    private double distance(AbstractEAIndividual indy, double[] p) {
        if (this.useSearchSpace) {
            ((InterfaceDataTypeDouble)((Object)this.tmpIndy)).setDoubleGenotype(p);
        } else {
            this.tmpIndy.setFitness(p);
        }
        return this.metric.distance(indy, this.tmpIndy);
    }

    private double[][] extractClusterDataFrom(Population pop) {
        double[][] data = new double[pop.size()][];
        if (this.useSearchSpace && pop.get(0) instanceof InterfaceDataTypeDouble) {
            for (int i = 0; i < pop.size(); ++i) {
                data[i] = ((InterfaceDataTypeDouble)pop.get(i)).getDoubleData();
            }
        } else {
            for (int i = 0; i < pop.size(); ++i) {
                data[i] = ((AbstractEAIndividual)pop.get(i)).getFitness();
            }
        }
        return data;
    }

    @Override
    public boolean mergingSpecies(Population species1, Population species2, Population referencePop) {
        return this.metric.distance(species1.getBestEAIndividual(), species2.getBestEAIndividual()) < this.mergeDist;
    }

    @Override
    public int[] associateLoners(Population loners, Population[] species, Population referencePop) {
        int[] res = new int[loners.size()];
        System.err.println("Warning, associateLoners not implemented for " + this.getClass());
        Arrays.fill(res, -1);
        return res;
    }

    public double[][] getC() {
        return this.c;
    }

    public void resetC() {
        this.c = null;
    }

    public static void main(String[] args) {
        ClusteringKMeans ckm = new ClusteringKMeans();
        ckm.setUseSearchSpace(true);
        ckm.debug = true;
        Population pop = new Population();
        F1Problem f1 = new F1Problem();
        f1.setProblemDimension(2);
        f1.setEAIndividual(new ESIndividualDoubleData());
        f1.initializePopulation(pop);
        ckm.cluster(pop, (Population)null);
    }

    public String getName() {
        return "K-Means";
    }

    public int getK() {
        return this.k;
    }

    public void setK(int m) {
        if (m < 1) {
            m = 1;
        }
        this.k = m;
    }

    public String kTipText() {
        return "Choose the number of clusters to find.";
    }

    public boolean getUseSearchSpace() {
        return this.useSearchSpace;
    }

    public void setUseSearchSpace(boolean m) {
        this.useSearchSpace = m;
    }

    public String useSearchSpaceTipText() {
        return "Toggel between search/objective space distance.";
    }

    public boolean getReuseC() {
        return this.reuseC;
    }

    public void setReuseC(boolean m) {
        this.reuseC = m;
    }

    public String reuseCTipText() {
        return "Toggel reuse of previously found cluster centroids.";
    }

    @Override
    public String initClustering(Population pop) {
        return null;
    }

    public void setMinClustSize(int minClustSize) {
        this.minClustSize = minClustSize;
    }

    public int getMinClustSize() {
        return this.minClustSize;
    }

    public String minClustSizeTipText() {
        return "Require a cluster to be at least of this size. Smaller ones are assigned to the unclustered set.";
    }
}

