/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.cluster;

import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.EAIndividualComparator;
import eva2.optimization.operator.cluster.InterfaceClustering;
import eva2.optimization.operator.distancemetric.InterfaceDistanceMetric;
import eva2.optimization.operator.distancemetric.PhenotypeMetric;
import eva2.optimization.operator.paramcontrol.ParamAdaption;
import eva2.optimization.operator.paramcontrol.ParameterControlManager;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;

@Description(value="A tree is produced by assigning each individual the closest individual with better fitness. Connections with a distance above a certain threshold are cut. After that, each interconnected subtree forms a cluster.")
public class ClusteringNearestBetter
implements InterfaceClustering,
Serializable {
    private static final long serialVersionUID = 1L;
    private InterfaceDistanceMetric metric = new PhenotypeMetric();
    private double absoluteDistThreshold = 0.5;
    private boolean thresholdMultipleOfMeanDist = true;
    private double meanDistFactor = 2.0;
    private double currentMeanDistance = -1.0;
    private int minimumGroupSize = 3;
    private boolean testConvergingSpeciesOnBestOnly = true;
    protected ParameterControlManager paramControl = new ParameterControlManager();
    private int[] uplink;
    private double[] uplinkDist;
    private EAIndividualComparator comparator = new EAIndividualComparator();
    private Vector<Integer>[] children;
    private static final String initializedForKey = "initializedClustNearestBetterOnHash";
    private static final String initializedRefData = "initializedClustNearestBetterData";

    public ClusteringNearestBetter() {
    }

    public ClusteringNearestBetter(ClusteringNearestBetter o) {
        this.metric = o.metric;
        this.absoluteDistThreshold = o.absoluteDistThreshold;
        this.thresholdMultipleOfMeanDist = o.thresholdMultipleOfMeanDist;
        this.meanDistFactor = o.meanDistFactor;
        this.currentMeanDistance = o.currentMeanDistance;
        this.minimumGroupSize = o.minimumGroupSize;
        this.comparator = (EAIndividualComparator)o.comparator.clone();
        this.testConvergingSpeciesOnBestOnly = o.testConvergingSpeciesOnBestOnly;
    }

    public ClusteringNearestBetter(boolean adaptive, double thresholdOrFactor) {
        this.setAdaptiveThreshold(adaptive);
        if (adaptive) {
            this.setMeanDistFactor(thresholdOrFactor);
        } else {
            this.setDistThreshold(thresholdOrFactor);
        }
    }

    public void hideHideable() {
        this.setAdaptiveThreshold(this.isAdaptiveThreshold());
    }

    public ParameterControlManager getParamControl() {
        return this.paramControl;
    }

    public ParamAdaption[] getParameterControl() {
        return this.paramControl.getSingleAdapters();
    }

    public void setParameterControl(ParamAdaption[] paramControl) {
        this.paramControl.setSingleAdapters(paramControl);
    }

    @Override
    public Object clone() {
        return new ClusteringNearestBetter(this);
    }

    @Override
    public int[] associateLoners(Population loners, Population[] species, Population referenceSet) {
        int[] res = new int[loners.size()];
        this.getRefData(referenceSet, loners);
        for (int l = 0; l < loners.size(); ++l) {
            int nearestBetterSpeciesID = -1;
            double nearestBetterDist = -1.0;
            for (int spI = 0; spI < species.length; ++spI) {
                boolean lonerIndyIsBest;
                boolean bl = lonerIndyIsBest = this.comparator.compare(loners.getEAIndividual(l), species[spI].getBestEAIndividual()) <= 0;
                if (lonerIndyIsBest) {
                    double curDist = this.metric.distance(loners.getEAIndividual(l), species[spI].getBestEAIndividual());
                    if (!(nearestBetterDist < 0.0) && !(curDist < nearestBetterDist)) continue;
                    nearestBetterSpeciesID = spI;
                    nearestBetterDist = curDist;
                    continue;
                }
                for (int i = 0; i < species[spI].size(); ++i) {
                    boolean specIndyIsBetter;
                    double curDist = this.metric.distance(loners.getEAIndividual(l), species[spI].getEAIndividual(i));
                    boolean bl2 = specIndyIsBetter = this.comparator.compare(species[spI].getEAIndividual(i), loners.getEAIndividual(l)) < 0;
                    if (!specIndyIsBetter || !(nearestBetterDist < 0.0) && !(curDist < nearestBetterDist)) continue;
                    nearestBetterSpeciesID = spI;
                    nearestBetterDist = curDist;
                }
            }
            res[l] = nearestBetterDist < this.currentDistThreshold() ? nearestBetterSpeciesID : -1;
        }
        return res;
    }

    @Override
    public String initClustering(Population pop) {
        if (this.isAdaptiveThreshold()) {
            ArrayList<AbstractEAIndividual> sorted = pop.getSorted(this.comparator);
            if (this.uplink == null || this.uplink.length != pop.size()) {
                this.uplink = new int[pop.size()];
            }
            if (this.uplinkDist == null || this.uplinkDist.length != pop.size()) {
                this.uplinkDist = new double[pop.size()];
            }
            if (this.children == null || this.children.length != pop.size()) {
                this.children = new Vector[pop.size()];
            } else if (this.children.length == pop.size()) {
                for (int i = 0; i < pop.size(); ++i) {
                    this.children[i] = null;
                }
            }
            this.currentMeanDistance = this.createClusterTreeFromSortedPop(sorted);
            pop.putData(initializedRefData, this.currentMeanDistance);
            return initializedRefData;
        }
        return null;
    }

    @Override
    public Population[] cluster(Population pop, Population referenceSet) {
        if (pop.isEmpty()) {
            return new Population[]{pop.cloneWithoutInds()};
        }
        ArrayList<AbstractEAIndividual> sorted = pop.getSorted(this.comparator);
        if (this.uplink == null || this.uplink.length != pop.size()) {
            this.uplink = new int[pop.size()];
        }
        if (this.uplinkDist == null || this.uplinkDist.length != pop.size()) {
            this.uplinkDist = new double[pop.size()];
        }
        if (this.children == null || this.children.length != pop.size()) {
            this.children = new Vector[pop.size()];
        } else if (this.children.length == pop.size()) {
            for (int i = 0; i < pop.size(); ++i) {
                this.children[i] = null;
            }
        }
        if (this.isAdaptiveThreshold()) {
            if (!this.getRefData(referenceSet, pop)) {
                this.currentMeanDistance = this.createClusterTreeFromSortedPop(sorted);
            } else {
                this.createClusterTreeFromSortedPop(sorted);
            }
        } else {
            this.createClusterTreeFromSortedPop(sorted);
        }
        int current = 0;
        boolean[] clustered = new boolean[pop.size()];
        LinkedList<Population> allClusters = new LinkedList<Population>();
        while (current < sorted.size()) {
            Population currentClust = pop.cloneWithoutInds();
            currentClust.add(sorted.get(current));
            clustered[current] = true;
            this.addChildren(current, clustered, sorted, currentClust);
            allClusters.add(currentClust);
            while (current < sorted.size() && clustered[current]) {
                ++current;
            }
        }
        ArrayList<Population> finalClusts = new ArrayList<Population>(allClusters.size());
        finalClusts.add(pop.cloneWithoutInds());
        for (Population clust : allClusters) {
            if (clust.size() < this.minimumGroupSize) {
                ((Population)finalClusts.get(0)).addPopulation(clust);
                continue;
            }
            finalClusts.add(clust);
        }
        Population[] finalArr = new Population[finalClusts.size()];
        return finalClusts.toArray(finalArr);
    }

    private boolean getRefData(Population referenceSet, Population backup) {
        Double refDat;
        if (referenceSet == null) {
            referenceSet = backup;
        }
        if ((refDat = (Double)referenceSet.getData(initializedRefData)) != null) {
            this.currentMeanDistance = refDat;
            return true;
        }
        System.err.println("Warning, missing reference data - forgot reference set initialization? " + this.getClass());
        return false;
    }

    private double createClusterTreeFromSortedPop(ArrayList<AbstractEAIndividual> sorted) {
        double edgeLengthSum = 0.0;
        int edgeCnt = 0;
        for (int i = sorted.size() - 1; i >= 1; --i) {
            this.uplink[i] = -1;
            this.uplinkDist[i] = -1.0;
            for (int j = i - 1; j >= 0; --j) {
                double curDist = this.metric.distance(sorted.get(i), sorted.get(j));
                if (!(this.uplinkDist[i] < 0.0) && !(curDist < this.uplinkDist[i])) continue;
                this.uplink[i] = j;
                this.uplinkDist[i] = curDist;
            }
            if (this.children[this.uplink[i]] == null) {
                this.children[this.uplink[i]] = new Vector();
            }
            this.children[this.uplink[i]].add(i);
            edgeLengthSum += this.uplinkDist[i];
            ++edgeCnt;
        }
        return edgeLengthSum / (double)edgeCnt;
    }

    private void addChildren(int current, boolean[] clustered, ArrayList<AbstractEAIndividual> sorted, Population currentClust) {
        if (this.children[current] != null && this.children[current].size() > 0) {
            for (int i = 0; i < this.children[current].size(); ++i) {
                if (clustered[this.children[current].get(i)] || !(this.uplinkDist[this.children[current].get(i)] < this.currentDistThreshold())) continue;
                currentClust.add(sorted.get(this.children[current].get(i)));
                clustered[this.children[current].get((int)i).intValue()] = true;
                this.addChildren(this.children[current].get(i), clustered, sorted, currentClust);
            }
        }
    }

    private double currentDistThreshold() {
        if (this.thresholdMultipleOfMeanDist) {
            return this.meanDistFactor * this.currentMeanDistance;
        }
        return this.absoluteDistThreshold;
    }

    @Override
    public boolean mergingSpecies(Population species1, Population species2, Population referenceSet) {
        this.getRefData(referenceSet, species1);
        if (this.testConvergingSpeciesOnBestOnly) {
            return this.metric.distance(species1.getBestEAIndividual(), species2.getBestEAIndividual()) < this.currentDistThreshold();
        }
        Population tmpPop = new Population(species1.size() + species2.size());
        tmpPop.addPopulation(species1);
        tmpPop.addPopulation(species2);
        return this.cluster(tmpPop, referenceSet).length <= 2;
    }

    public String metricTipText() {
        return "The metric to use during clustering.";
    }

    public InterfaceDistanceMetric getMetric() {
        return this.metric;
    }

    public void setMetric(InterfaceDistanceMetric metric) {
        this.metric = metric;
    }

    public String distThresholdTipText() {
        return "In the non-adaptive case the absolute threshold below which clusters are connected.";
    }

    public double getDistThreshold() {
        return this.absoluteDistThreshold;
    }

    public void setDistThreshold(double distThreshold) {
        this.absoluteDistThreshold = distThreshold;
    }

    public String minimumGroupSizeTipText() {
        return "Minimum group size that makes an own cluster.";
    }

    public int getMinimumGroupSize() {
        return this.minimumGroupSize;
    }

    public void setMinimumGroupSize(int minimumGroupSize) {
        this.minimumGroupSize = minimumGroupSize;
    }

    public String comparatorTipText() {
        return "Define the comparator by which the population is sorted before clustering.";
    }

    public EAIndividualComparator getComparator() {
        return this.comparator;
    }

    public String adaptiveThresholdTipText() {
        return "Activate adaptive threshold which is calculated from mean distance in the population and a constant factor.";
    }

    public boolean isAdaptiveThreshold() {
        return this.thresholdMultipleOfMeanDist;
    }

    public void setAdaptiveThreshold(boolean thresholdMultipleOfMeanDist) {
        this.thresholdMultipleOfMeanDist = thresholdMultipleOfMeanDist;
        GenericObjectEditor.setHideProperty(this.getClass(), "meanDistFactor", !thresholdMultipleOfMeanDist);
        GenericObjectEditor.setHideProperty(this.getClass(), "distThreshold", thresholdMultipleOfMeanDist);
    }

    public String meanDistFactorTipText() {
        return "Factor producing the distance threshold from population mean distance.";
    }

    public double getMeanDistFactor() {
        return this.meanDistFactor;
    }

    public void setMeanDistFactor(double meanDistFactor) {
        this.meanDistFactor = meanDistFactor;
    }

    public String testConvergingSpeciesOnBestOnlyTipText() {
        return "Only the best individuals may be compared when testing whether to merge two species.";
    }

    public boolean isTestConvergingSpeciesOnBestOnly() {
        return this.testConvergingSpeciesOnBestOnly;
    }

    public void SetTestConvergingSpeciesOnBestOnly(boolean testConvergingSpeciesOnBestOnly) {
        this.testConvergingSpeciesOnBestOnly = testConvergingSpeciesOnBestOnly;
    }
}

