/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.cluster;

import eva2.gui.plot.GraphPointSet;
import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.cluster.ClusteringKMeans;
import eva2.optimization.operator.cluster.InterfaceClustering;
import eva2.optimization.population.Population;
import eva2.problems.F1Problem;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DPointIconCircle;
import eva2.tools.chart2d.DPointIconText;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.Arrays;

@Description(value="Oldy but goldy: K-Means clustering.")
public class ClusteringXMeans
implements InterfaceClustering,
Serializable {
    public int maxK = 5;
    public double[][] C;
    public boolean useSearchSpace = false;
    public boolean debug = false;

    public ClusteringXMeans() {
    }

    public ClusteringXMeans(ClusteringXMeans a) {
        this.debug = a.debug;
        this.maxK = a.maxK;
        this.useSearchSpace = a.useSearchSpace;
    }

    @Override
    public Object clone() {
        return new ClusteringXMeans(this);
    }

    @Override
    public Population[] cluster(Population pop, Population referencePop) {
        ClusteringKMeans kmeans = new ClusteringKMeans();
        Population[][] tmpResults = new Population[this.maxK][];
        double[][][] tmpC = new double[this.maxK][][];
        double[][] data = this.extractClusterDataFrom(pop);
        tmpResults[0] = new Population[1];
        tmpResults[0][0] = pop;
        tmpC[0] = new double[1][];
        tmpC[0][0] = this.calculateMean(data);
        for (int i = 1; i < this.maxK; ++i) {
            kmeans.setUseSearchSpace(this.useSearchSpace);
            kmeans.setK(i + 1);
            tmpResults[i] = kmeans.cluster(pop, (Population)null);
            tmpC[i] = kmeans.getC();
        }
        double bestBIC = Double.NEGATIVE_INFINITY;
        int index = 0;
        for (int i = 0; i < tmpResults.length; ++i) {
            double tmpBIC = this.calculateBIC(tmpResults[i], tmpC[i]);
            if (this.debug) {
                DPointIconText tmp;
                DPoint myPoint;
                GraphPointSet mySet;
                int k;
                double[] tmpD = new double[]{0.0, 0.0};
                Plot plot = new Plot("K=" + (i + 1) + " reaches BIC = " + tmpBIC, "Y1", "Y2", tmpD, tmpD);
                for (k = 0; k < tmpResults[i].length; ++k) {
                    mySet = new GraphPointSet(10 + k, plot.getFunctionArea());
                    mySet.setConnectedMode(false);
                    for (int l = 0; l < tmpResults[i][k].size(); ++l) {
                        double[] x = ((InterfaceDataTypeDouble)tmpResults[i][k].get(l)).getDoubleData();
                        myPoint = new DPoint(x[0], x[1]);
                        tmp = new DPointIconText("" + k);
                        if (k % 2 == 0) {
                            tmp.setIcon(new DPointIconCircle());
                        }
                        myPoint.setIcon(tmp);
                        mySet.addDPoint(myPoint);
                    }
                }
                mySet = new GraphPointSet(9, plot.getFunctionArea());
                mySet.setConnectedMode(false);
                for (k = 0; k < tmpC[i].length; ++k) {
                    myPoint = new DPoint(tmpC[i][k][0], tmpC[i][k][1]);
                    tmp = new DPointIconText("C/" + k);
                    if (k % 2 == 0) {
                        tmp.setIcon(new DPointIconCircle());
                    }
                    myPoint.setIcon(tmp);
                    mySet.addDPoint(myPoint);
                }
            }
            if (!(tmpBIC > bestBIC)) continue;
            bestBIC = tmpBIC;
            index = i;
        }
        System.out.println("XMeans results in " + (index + 1) + " clusters.");
        Population[] result = tmpResults[index];
        this.C = tmpC[index];
        return result;
    }

    private double calculateBIC(Population[] pop, double[][] C) {
        int i;
        double result = 0.0;
        double R = 0.0;
        double M = 0.0;
        for (i = 0; i < pop.length; ++i) {
            R += (double)pop[i].size();
        }
        double K = pop.length;
        for (i = 0; i < pop.length; ++i) {
            double[][] data = this.extractClusterDataFrom(pop[i]);
            double RM = data.length;
            if (data.length <= 0) continue;
            M = data[0].length;
            double[] mean = this.calculateMean(data);
            double sigma = this.calculateSigma(data, mean);
            result += -(RM / 2.0) * Math.log(Math.PI * 2);
            result += -0.5 * RM * M * Math.log(sigma);
            result += -0.5 * (RM - K);
            result += RM * Math.log(RM);
            result += RM * Math.log(R);
        }
        return result += -(K - 1.0 + M * K + 1.0) * Math.log(R);
    }

    private double[] calculateMean(double[][] data) {
        double[] result = new double[data[0].length];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                int n = j;
                result[n] = result[n] + data[i][j];
            }
        }
        int j = 0;
        while (j < result.length) {
            int n = j++;
            result[n] = result[n] / (double)data.length;
        }
        return result;
    }

    private double calculateSigma(double[][] data, double[] mean) {
        double result = 0.0;
        if (data.length == 1) {
            return 1.0;
        }
        for (int i = 0; i < data.length; ++i) {
            result += Math.pow(this.distance(data[i], mean), 2.0);
        }
        return result /= (double)data.length;
    }

    private double distance(double[] d1, double[] d2) {
        double result = 0.0;
        for (int i = 0; i < d1.length; ++i) {
            result += Math.pow(d1[i] - d2[i], 2.0);
        }
        result = Math.sqrt(result);
        return result;
    }

    private double[][] extractClusterDataFrom(Population pop) {
        double[][] data = new double[pop.size()][];
        if (this.useSearchSpace && pop.get(0) instanceof InterfaceDataTypeDouble) {
            for (int i = 0; i < pop.size(); ++i) {
                data[i] = ((InterfaceDataTypeDouble)pop.get(i)).getDoubleData();
            }
        } else {
            for (int i = 0; i < pop.size(); ++i) {
                data[i] = ((AbstractEAIndividual)pop.get(i)).getFitness();
            }
        }
        return data;
    }

    @Override
    public boolean mergingSpecies(Population species1, Population species2, Population referencePop) {
        return false;
    }

    @Override
    public int[] associateLoners(Population loners, Population[] species, Population referencePop) {
        int[] res = new int[loners.size()];
        System.err.println("Warning, associateLoners not implemented for " + this.getClass());
        Arrays.fill(res, -1);
        return res;
    }

    public double[][] getC() {
        return this.C;
    }

    public Population[] cluster(Population pop, double[][] c) {
        int i;
        Population[] result = new Population[c.length];
        double[][] data = this.extractClusterDataFrom(pop);
        for (i = 0; i < result.length; ++i) {
            result[i] = new Population();
        }
        for (i = 0; i < data.length; ++i) {
            int clusterAssigned = 0;
            for (int j = 1; j < c.length; ++j) {
                if (!(this.distance(data[i], c[clusterAssigned]) > this.distance(data[i], c[j]))) continue;
                clusterAssigned = j;
            }
            result[clusterAssigned].add(pop.get(i));
        }
        return result;
    }

    public static void main(String[] args) {
        ClusteringXMeans ckm = new ClusteringXMeans();
        ckm.setUseSearchSpace(true);
        ckm.debug = true;
        Population pop = new Population();
        pop.setTargetSize(100);
        F1Problem f1 = new F1Problem();
        f1.setProblemDimension(2);
        f1.setEAIndividual(new ESIndividualDoubleData());
        int k = 3;
        f1.initializePopulation(pop);
        for (int i = 0; i < pop.size(); ++i) {
            double[] x = ((InterfaceDataTypeDouble)pop.get(i)).getDoubleData();
            switch (i % k) {
                case 0: {
                    x[0] = 0.0 + RNG.gaussianDouble(1.2);
                    x[1] = -1.0 + RNG.gaussianDouble(1.5);
                    break;
                }
                case 1: {
                    x[0] = 3.0 + RNG.gaussianDouble(1.8);
                    x[1] = 8.0 + RNG.gaussianDouble(0.9);
                    break;
                }
                case 2: {
                    x[0] = -4.0 + RNG.gaussianDouble(1.2);
                    x[1] = -8.0 + RNG.gaussianDouble(1.2);
                    break;
                }
                case 3: {
                    x[0] = 7.0 + RNG.gaussianDouble(1.1);
                    x[1] = -5.0 + RNG.gaussianDouble(1.0);
                    break;
                }
                default: {
                    x[0] = -2.0 + RNG.gaussianDouble(1.2);
                    x[1] = 5.0 + RNG.gaussianDouble(1.2);
                }
            }
            if (i == 0) {
                x[0] = -10.0;
                x[1] = -10.0;
            }
            if (i == 1) {
                x[0] = 10.0;
                x[1] = 10.0;
            }
            ((InterfaceDataTypeDouble)pop.get(i)).setDoubleGenotype(x);
        }
        ckm.cluster(pop, (Population)null);
    }

    public String getName() {
        return "K-Means";
    }

    public int getMaxK() {
        return this.maxK;
    }

    public void setMaxK(int m) {
        if (m < 1) {
            m = 1;
        }
        this.maxK = m;
    }

    public String maxKTipText() {
        return "Choose the max number of clusters to find.";
    }

    public boolean getUseSearchSpace() {
        return this.useSearchSpace;
    }

    public void setUseSearchSpace(boolean m) {
        this.useSearchSpace = m;
    }

    public String useSearchSpaceTipText() {
        return "Toggle between search/objective space distance.";
    }

    @Override
    public String initClustering(Population pop) {
        return null;
    }
}

