/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.constraint;

import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.constraint.ConstraintHandlingEnum;
import eva2.optimization.operator.constraint.ConstraintRelationEnum;
import eva2.optimization.operator.constraint.InterfaceDoubleConstraint;
import eva2.optimization.operator.paramcontrol.GenericParamAdaption;
import eva2.optimization.operator.paramcontrol.InterfaceParameterControl;
import eva2.optimization.operator.paramcontrol.NoParamAdaption;
import eva2.optimization.operator.paramcontrol.ParamAdaption;
import eva2.optimization.operator.paramcontrol.ParameterControlManager;
import eva2.problems.AbstractProblemDouble;
import eva2.tools.EVAERROR;
import java.io.Serializable;
import java.util.logging.Logger;

public abstract class AbstractConstraint
implements InterfaceDoubleConstraint,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(AbstractConstraint.class.getName());
    protected ConstraintRelationEnum relation = ConstraintRelationEnum.lessEqZero;
    protected ConstraintHandlingEnum handling = ConstraintHandlingEnum.specificTag;
    protected double equalityEpsilon = 1.0E-4;
    private AbstractEAIndividual currentIndy = null;
    private double penaltyFactor = 1.0;
    protected ParameterControlManager paramCtrl = new ParameterControlManager(new NoParamAdaption());
    private static String penaltyPropName = "penaltyFactor";

    public AbstractConstraint() {
        this.relation = ConstraintRelationEnum.lessEqZero;
        this.penaltyFactor = 1.0;
        this.paramCtrl = new ParameterControlManager(new NoParamAdaption());
    }

    public AbstractConstraint(AbstractConstraint o) {
        this.paramCtrl = new ParameterControlManager(o.paramCtrl);
        this.penaltyFactor = o.penaltyFactor;
        this.relation = o.relation;
    }

    public void hideHideable() {
        this.setRelation(this.getRelation());
    }

    @Override
    public abstract Object clone();

    public InterfaceParameterControl getParamControl() {
        return this.paramCtrl;
    }

    protected abstract double getRawViolationValue(double[] var1);

    @Override
    public double getViolation(double[] indyX) {
        double viol = this.getRawViolationValue(indyX);
        return this.getViolationConsideringRelation(viol);
    }

    public void addViolation(AbstractEAIndividual indy, double[] indyX) {
        this.currentIndy = indy;
        double v = this.getViolation(indyX);
        switch (this.handling) {
            case penaltyAdditive: {
                if (!(v > 0.0)) break;
                indy.setMarkPenalized(true);
                for (int i = 0; i < indy.getFitness().length; ++i) {
                    indy.SetFitness(i, indy.getFitness(i) + v + this.penaltyFactor);
                }
                break;
            }
            case penaltyMultiplicative: {
                if (v > 0.0) {
                    indy.setMarkPenalized(true);
                    for (int i = 0; i < indy.getFitness().length; ++i) {
                        indy.SetFitness(i, indy.getFitness(i) * (v + this.penaltyFactor));
                    }
                }
            }
            case specificTag: {
                if (!(v > 0.0)) break;
                indy.addConstraintViolation(v);
            }
        }
        this.currentIndy = null;
    }

    protected double[] getIndyRawFit(String key) {
        return this.getIndyDblData(AbstractProblemDouble.rawFitKey);
    }

    protected double[] getIndyDblData(String key) {
        if (this.currentIndy != null) {
            Object dat = this.currentIndy.getData(key);
            if (dat != null && dat instanceof double[]) {
                return (double[])dat;
            }
            LOGGER.finest("Error, invalid call to AbstractConstraint.getRawFitness(). Individual had no raw fitness set.");
            return null;
        }
        LOGGER.finest("Error, invalid call to AbstractConstraint.getRawFitness(). Individual was unknown.");
        return null;
    }

    protected Object getIndyData(String key) {
        if (this.currentIndy != null) {
            return this.currentIndy.getData(key);
        }
        LOGGER.finest("Error, invalid call to AbstractConstraint.getRawFitness(). Individual was unknown.");
        return null;
    }

    private double getViolationConsideringRelation(double val) {
        val *= this.penaltyFactor;
        switch (this.relation) {
            case lessEqZero: {
                return val <= 0.0 ? 0.0 : val;
            }
            case eqZero: {
                val = Math.abs(val);
                if (val <= this.equalityEpsilon) {
                    return 0.0;
                }
                return val;
            }
            case greaterEqZero: {
                return val >= 0.0 ? 0.0 : -val;
            }
        }
        System.err.println("Unknown relation!");
        return 0.0;
    }

    public boolean isViolated(double[] pos) {
        return this.getViolation(pos) > 0.0;
    }

    @Override
    public boolean isSatisfied(double[] pos) {
        return this.getViolation(pos) == 0.0;
    }

    public ConstraintRelationEnum getRelation() {
        return this.relation;
    }

    public void setRelation(ConstraintRelationEnum relation) {
        this.relation = relation;
        GenericObjectEditor.setShowProperty(this.getClass(), "equalityEpsilon", relation == ConstraintRelationEnum.eqZero);
    }

    public ParamAdaption getPenaltyFactControl() {
        return this.paramCtrl.getSingleAdapters()[0];
    }

    public void setPenaltyFactControl(ParamAdaption penaltyAdaption) {
        if (!(penaltyAdaption instanceof NoParamAdaption)) {
            if (penaltyAdaption instanceof GenericParamAdaption) {
                ((GenericParamAdaption)penaltyAdaption).setControlledParam(penaltyPropName);
            } else if (!penaltyPropName.equals(penaltyAdaption.getControlledParam())) {
                System.err.println("Warning: penalty factor control may have different target");
            }
        }
        this.paramCtrl.setSingleAdapters(new ParamAdaption[]{penaltyAdaption});
    }

    public String penaltyFactControlTipText() {
        return "Adaptive penalty may used. For generic adaption mechanisms, the target string will be set automatically.";
    }

    public double getPenaltyFactor() {
        return this.penaltyFactor;
    }

    public void setPenaltyFactor(double penaltyFactor) {
        if (penaltyFactor < 0.0) {
            EVAERROR.errorMsgOnce("Error: a negative penalty factor is not allowed!");
        } else {
            this.penaltyFactor = penaltyFactor;
        }
    }

    public String penaltyFactorTipText() {
        return "Penalty factor by which a constraint violation is multiplied.";
    }

    public ConstraintHandlingEnum getHandlingMethod() {
        return this.handling;
    }

    public void setHandlingMethod(ConstraintHandlingEnum handling) {
        this.handling = handling;
    }

    public String handlingMethodTipText() {
        return "Select the method the constraint is handled.";
    }

    public double getEqualityEpsilon() {
        return this.equalityEpsilon;
    }

    public void setEqualityEpsilon(double equalityEpsilon) {
        this.equalityEpsilon = equalityEpsilon;
    }

    public String equalityEpsilonTipText() {
        return "The threshold below which equality constraints are said to be satisfied.";
    }
}

