/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.constraint;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.constraint.InterfaceConstraint;
import java.io.Serializable;

public class ConstObjectivesInEqualitySmallerThanSurface
implements InterfaceConstraint,
Serializable {
    private double[] base;
    private double[] norm;

    public ConstObjectivesInEqualitySmallerThanSurface() {
    }

    public ConstObjectivesInEqualitySmallerThanSurface(double[] base, double[] norm) {
        this.base = base;
        this.norm = norm;
    }

    public ConstObjectivesInEqualitySmallerThanSurface(ConstObjectivesInEqualitySmallerThanSurface a) {
        this.base = a.base;
        this.norm = a.norm;
    }

    @Override
    public Object clone() {
        return new ConstObjectivesInEqualitySmallerThanSurface(this);
    }

    @Override
    public boolean isValid(AbstractEAIndividual indy) {
        double[] d = indy.getFitness();
        return this.getScalarProduct(this.norm, this.getSubstraction(d, this.base)) < 0.0;
    }

    private double[] getSubstraction(double[] a, double[] b) {
        double[] result = new double[]{a[0] - b[0], a[1] - b[1], a[2] - b[2]};
        return result;
    }

    private double getScalarProduct(double[] a, double[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    private double[] getNormalized(double[] a) {
        int i;
        double[] result = new double[a.length];
        double sum = 0.0;
        for (i = 0; i < a.length; ++i) {
            sum = Math.pow(a[i], 2.0);
        }
        sum = Math.sqrt(sum);
        for (i = 0; i < a.length; ++i) {
            result[i] = a[i] / sum;
        }
        return result;
    }
}

