/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.constraint;

import eva2.optimization.operator.constraint.AbstractConstraint;
import eva2.optimization.operator.constraint.ConstraintHandlingEnum;
import eva2.util.annotation.Description;

@Description(value="A set of constraints with a single parameter adaption mechanism.")
public class ConstraintCollection
extends AbstractConstraint {
    private AbstractConstraint[] constraintArray = new AbstractConstraint[0];

    public ConstraintCollection() {
        this.constraintArray = new AbstractConstraint[0];
    }

    public ConstraintCollection(AbstractConstraint[] constrArr) {
        this.constraintArray = constrArr;
    }

    public ConstraintCollection(AbstractConstraint[] constrArr, ConstraintHandlingEnum handling, double penaltyFact) {
        this(constrArr);
        this.setHandlingMethod(handling);
        this.setPenaltyFactor(penaltyFact);
    }

    public ConstraintCollection(ConstraintCollection o) {
        super(o);
        this.constraintArray = (AbstractConstraint[])o.constraintArray.clone();
        for (int i = 0; i < this.constraintArray.length; ++i) {
            this.constraintArray[i] = (AbstractConstraint)o.constraintArray[i].clone();
        }
    }

    @Override
    public Object clone() {
        return new ConstraintCollection(this);
    }

    @Override
    protected double getRawViolationValue(double[] indyX) {
        double sum = 0.0;
        for (AbstractConstraint constr : this.constraintArray) {
            double v = constr.getViolation(indyX);
            sum += v;
        }
        return sum;
    }

    public AbstractConstraint[] getConstraints() {
        return this.constraintArray;
    }

    public void setConstraints(AbstractConstraint[] constrArray) {
        this.constraintArray = constrArray;
    }

    public String constraintsTipText() {
        return "A set of constraints which is handled uniformly";
    }

    public String getName() {
        return this.constraintArray.length + " constr./" + this.getPenaltyFactor() + "/" + (Object)((Object)this.getHandlingMethod()) + "/" + this.getPenaltyFactControl().getClass().getSimpleName();
    }
}

