/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.constraint;

import eva2.optimization.individuals.codings.gp.AbstractGPNode;
import eva2.optimization.operator.constraint.AbstractConstraint;
import eva2.optimization.operator.constraint.ConstraintHandlingEnum;
import eva2.optimization.operator.constraint.ConstraintRelationEnum;
import eva2.optimization.operator.constraint.InterfaceDoubleConstraint;
import eva2.problems.GPFunctionProblem;
import eva2.tools.EVAERROR;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="A generic constraint which is parsed from a String; n is dimension, x0..xn are solution components. Use prefix notation as in \"+(-(sum(x),n),sqrt(*(pi,x0)))\".")
public class GenericConstraint
extends AbstractConstraint
implements InterfaceDoubleConstraint,
Serializable {
    private String constraintString = "+(x0,x1)";
    private transient AbstractGPNode constraintProgram = null;
    GPFunctionProblem func = null;

    public GenericConstraint() {
        this.constraintProgram = null;
    }

    public GenericConstraint(String str) {
        this();
        this.setConstraintString(str);
        this.compileConstraint();
    }

    public GenericConstraint(String str, ConstraintRelationEnum relation) {
        this(str);
        this.setRelation(relation);
    }

    public GenericConstraint(String str, ConstraintRelationEnum relation, ConstraintHandlingEnum method) {
        this(str, relation);
        this.setHandlingMethod(method);
    }

    public GenericConstraint(String str, ConstraintRelationEnum relation, ConstraintHandlingEnum method, double penFact) {
        this(str, relation, method);
        this.setPenaltyFactor(penFact);
    }

    public GenericConstraint(GenericConstraint o) {
        super(o);
        this.constraintString = o.constraintString;
        this.constraintProgram = null;
    }

    @Override
    public Object clone() {
        return new GenericConstraint(this);
    }

    private void compileConstraint() {
        this.func = null;
        this.constraintProgram = AbstractGPNode.parseFromString(this.constraintString);
        if (this.constraintProgram == null) {
            System.err.println("Error: invalid expression: " + this.constraintString);
        }
    }

    public boolean checkValid() {
        if (this.constraintProgram == null) {
            this.compileConstraint();
        }
        return this.constraintProgram != null;
    }

    @Override
    public double getRawViolationValue(double[] indyX) {
        switch (this.relation) {
            case eqZero: 
            case greaterEqZero: 
            case lessEqZero: {
                if (this.constraintProgram == null) {
                    this.compileConstraint();
                }
                if (this.constraintProgram != null) {
                    if (this.func == null) {
                        this.func = new GPFunctionProblem(this.constraintProgram, null, indyX.length, 0.0, 0.0);
                    }
                    return this.func.evaluate(indyX)[0];
                }
                return 0.0;
            }
        }
        EVAERROR.errorMsgOnce("Error: unknown relation for GenericConstraint!");
        return 0.0;
    }

    public String getConstraintString() {
        return this.constraintString;
    }

    public void setConstraintString(String constraintString) {
        this.constraintString = constraintString;
        this.constraintProgram = null;
    }

    public String getName() {
        return this.getClass().getSimpleName() + " " + this.constraintString;
    }
}

