/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.constraint;

import eva2.optimization.operator.constraint.AbstractConstraint;
import eva2.util.annotation.Description;

@Description(value="Similar to a multi-objective translation into fitness, this class allows to interpret fitness criteria as constraints.")
public class ImplicitConstraint
extends AbstractConstraint {
    int index = 0;

    public ImplicitConstraint() {
    }

    public ImplicitConstraint(int cIndex) {
        this.index = cIndex;
    }

    @Override
    public Object clone() {
        return new ImplicitConstraint(this.index);
    }

    @Override
    protected double getRawViolationValue(double[] indyX) {
        if (this.index < 0 || this.index >= indyX.length) {
            System.err.println("Error in ImplicitConstraint!");
            return 0.0;
        }
        return indyX[this.index];
    }

    public String getName() {
        return "ImplicitCnstr-" + this.index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        if (index > 0) {
            this.index = index;
        } else {
            System.err.println("Error, invalid index (<=0) in ImplicitConstraint.");
        }
    }

    public String indexTipText() {
        return "Set the index of the fitness criterion to be translated into a constraint, must be > 0";
    }
}

