/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.constraint;

import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.operator.constraint.AbstractConstraint;
import eva2.optimization.operator.constraint.ConstraintRelationEnum;
import eva2.optimization.operator.constraint.GenericConstraint;
import eva2.optimization.operator.constraint.InterfaceDoubleConstraint;
import eva2.tools.EVAERROR;
import eva2.tools.math.Mathematics;
import java.io.Serializable;

public class IntervalConstraint
extends AbstractConstraint
implements InterfaceDoubleConstraint,
Serializable {
    double lower = 0.0;
    double upper = 1.0;
    int index = 0;
    GenericConstraint genericConstr = null;

    public IntervalConstraint() {
        this(0, 0.0, 1.0);
        this.genericConstr = null;
    }

    @Override
    public void hideHideable() {
        GenericObjectEditor.setHideProperty(this.getClass(), "relation", true);
    }

    public IntervalConstraint(int index, double lowerBnd, double upperBnd) {
        this.index = index;
        this.lower = lowerBnd;
        this.upper = upperBnd;
        this.setRelation(ConstraintRelationEnum.lessEqZero);
        this.genericConstr = null;
    }

    public IntervalConstraint(String genericFunctionString, double lowerBnd, double upperBnd) {
        this(0, lowerBnd, upperBnd);
        this.setGenericFunction(genericFunctionString);
    }

    public IntervalConstraint(IntervalConstraint o) {
        this(o.index, o.lower, o.upper);
        this.genericConstr = o.genericConstr;
    }

    @Override
    public Object clone() {
        return new IntervalConstraint(this);
    }

    @Override
    protected double getRawViolationValue(double[] indyX) {
        if (this.genericConstr != null) {
            double constrFuncValue = this.genericConstr.getRawViolationValue(indyX);
            return this.distanceToInterval(constrFuncValue);
        }
        if (this.index < 0) {
            double violSum = 0.0;
            for (int i = 0; i < indyX.length; ++i) {
                violSum += this.violInDim(i, indyX);
            }
            return violSum;
        }
        if (this.index >= indyX.length) {
            EVAERROR.errorMsgOnce("Error, invalid index for " + this.getClass().getSimpleName());
            return 0.0;
        }
        return this.violInDim(this.index, indyX);
    }

    public String getName() {
        String clsName = this.getClass().getSimpleName();
        if (this.genericConstr != null) {
            return clsName + "/" + this.genericConstr.getConstraintString() + " in [" + this.lower + "," + this.upper + "]";
        }
        if (this.index < 0) {
            return clsName + "/x_i in [" + this.lower + "," + this.upper + "]";
        }
        return clsName + "/x_" + this.index + " in [" + this.lower + "," + this.upper + "]";
    }

    private double violInDim(int i, double[] pos) {
        return this.distanceToInterval(pos[i]);
    }

    private double distanceToInterval(double v) {
        double tmp = Mathematics.projectValue(v, this.lower, this.upper);
        return Math.abs(tmp - v);
    }

    public void setGenericFunction(String str) {
        if (str != null && str.length() > 0) {
            this.genericConstr = new GenericConstraint(str);
            if (!this.genericConstr.checkValid()) {
                this.genericConstr = null;
            }
        } else {
            this.genericConstr = null;
        }
    }

    public String getGenericFunction() {
        if (this.genericConstr == null) {
            return "";
        }
        return this.genericConstr.getConstraintString();
    }

    public String genericConstrTipText() {
        return "A generic function can be used as in GenericConstraint - it has priority.";
    }
}

