/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.crossover.CrossoverEAMixer;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.operator.crossover.PropertyCrossoverMixer;
import eva2.optimization.operator.mutation.InterfaceAdaptOperatorGenerational;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;

public class AdaptiveCrossoverEAMixer
extends CrossoverEAMixer
implements InterfaceAdaptOperatorGenerational {
    private Population pop = new Population();
    private boolean initialized = false;
    private double lastFitness = Double.MAX_VALUE;
    private int[] used;
    private InterfaceOptimizationProblem opt;

    public AdaptiveCrossoverEAMixer() {
    }

    public AdaptiveCrossoverEAMixer(AdaptiveCrossoverEAMixer mutator) {
        super(mutator);
        this.pop = (Population)mutator.pop.clone();
        this.initialized = mutator.initialized;
        this.lastFitness = mutator.lastFitness;
        this.used = mutator.used;
        this.opt = mutator.opt;
    }

    public AdaptiveCrossoverEAMixer(InterfaceCrossover ... crossovers) {
        this.crossoverMixer = new PropertyCrossoverMixer(crossovers);
        this.crossoverMixer.selectedTargets = (InterfaceCrossover[])this.crossoverMixer.availableTargets.clone();
    }

    @Override
    protected void maybeAdaptWeights(AbstractEAIndividual[] indies) {
        if (this.initialized) {
            AbstractEAIndividual indy = indies[0];
            this.opt.evaluate(indy);
            this.pop.incrFunctionCalls();
            if (indy.getFitness(0) < this.lastFitness) {
                this.lastFitness = indy.getFitness(0);
                int n = this.lastOperatorIndex;
                this.used[n] = this.used[n] + 1;
                int sum = 0;
                for (int i = 0; i < this.used.length; ++i) {
                    sum += this.used[i];
                }
                double[] weights = new double[this.used.length];
                for (int i = 0; i < weights.length; ++i) {
                    weights[i] = (double)this.used[i] / (double)sum;
                }
                this.getCrossovers().setWeights(weights);
            }
        } else {
            System.err.println("not yet initialized");
        }
    }

    public void init(AbstractEAIndividual individual, InterfaceOptimizationProblem opt, Population pop, double fit) {
        int i;
        InterfaceCrossover[] mutators = this.crossoverMixer.getSelectedCrossers();
        for (i = 0; i < mutators.length; ++i) {
            mutators[i].init(individual, opt);
        }
        this.pop = pop;
        this.lastFitness = fit;
        this.used = new int[this.getCrossovers().getWeights().length];
        for (i = 0; i < this.used.length; ++i) {
            this.used[i] = 1;
        }
        this.opt = opt;
        this.initialized = true;
    }

    public void update(AbstractEAIndividual individual, InterfaceOptimizationProblem opt, Population pop, double fit) {
        InterfaceCrossover[] mutators = this.crossoverMixer.getSelectedCrossers();
        for (int i = 0; i < mutators.length; ++i) {
            mutators[i].init(individual, opt);
        }
        this.pop = pop;
        this.lastFitness = fit;
        this.opt = opt;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void adaptAfterSelection(Population oldPop, Population selectedPop) {
    }

    @Override
    public void adaptGenerational(Population oldPop, Population selectedPop, Population newPop, boolean updateSelected) {
        System.out.println("In adaptGenerational");
    }
}

