/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.crossover.CrossoverESArithmetical;
import eva2.optimization.operator.crossover.CrossoverESSBX;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.operator.crossover.InterfaceEvaluatingCrossoverOperator;
import eva2.optimization.operator.crossover.PropertyCrossoverMixer;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.ArrayList;

@Description(value="This meta-mutation operator allows you to combine multiple alternative mutation operators.")
public class CrossoverEAMixer
implements InterfaceCrossover,
InterfaceEvaluatingCrossoverOperator,
Serializable {
    public static final String CROSSOVER_EA_MIXER_OPERATOR_KEY = "CrossoverEAMixerOperatorKey";
    protected PropertyCrossoverMixer crossoverMixer;
    protected boolean useSelfAdaption = false;
    protected double tau1 = 0.15;
    protected double lowerLimitChance = 0.05;
    protected int lastOperatorIndex = -1;

    public CrossoverEAMixer() {
        ArrayList<String> crossers = GenericObjectEditor.getClassesFromProperties(InterfaceCrossover.class.getCanonicalName(), null);
        InterfaceCrossover[] tmpList = new InterfaceCrossover[crossers.size()];
        for (int i = 0; i < crossers.size(); ++i) {
            Class<?> clz = null;
            try {
                clz = Class.forName(crossers.get(i));
            }
            catch (ClassNotFoundException e1) {
                continue;
            }
            if (clz.isAssignableFrom(this.getClass())) continue;
            try {
                tmpList[i] = (InterfaceCrossover)Class.forName(crossers.get(i)).newInstance();
                continue;
            }
            catch (ClassNotFoundException e) {
                System.out.println("Could not find class for " + crossers.get(i));
                continue;
            }
            catch (InstantiationException k) {
                System.out.println("Instantiation exception for " + crossers.get(i));
                continue;
            }
            catch (IllegalAccessException a) {
                System.out.println("Illegal access exception for " + crossers.get(i));
            }
        }
        this.crossoverMixer = new PropertyCrossoverMixer(tmpList);
        tmpList = new InterfaceCrossover[]{new CrossoverESArithmetical(), new CrossoverESSBX()};
        this.crossoverMixer.setSelectedCrossers(tmpList);
        this.crossoverMixer.normalizeWeights();
        this.crossoverMixer.setDescriptiveString("Combining alternative mutation operators, please norm the weights!");
        this.crossoverMixer.setWeightsLabel("Weights");
    }

    public CrossoverEAMixer(CrossoverEAMixer mutator) {
        this.crossoverMixer = (PropertyCrossoverMixer)mutator.crossoverMixer.clone();
        this.useSelfAdaption = mutator.useSelfAdaption;
        this.tau1 = mutator.tau1;
        this.lowerLimitChance = mutator.lowerLimitChance;
    }

    @Override
    public Object clone() {
        return new CrossoverEAMixer(this);
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator instanceof CrossoverEAMixer) {
            CrossoverEAMixer mut = (CrossoverEAMixer)mutator;
            return true;
        }
        return false;
    }

    @Override
    public void init(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        InterfaceCrossover[] crossers = this.crossoverMixer.getSelectedCrossers();
        for (int i = 0; i < crossers.length; ++i) {
            crossers[i].init(individual, opt);
        }
    }

    @Override
    public AbstractEAIndividual[] mate(AbstractEAIndividual indy1, Population partners) {
        this.crossoverMixer.normalizeWeights();
        double[] probs = this.crossoverMixer.getWeights();
        if (this.useSelfAdaption) {
            for (int i = 0; i < probs.length; ++i) {
                int n = i;
                probs[n] = probs[n] * Math.exp(this.tau1 * RNG.gaussianDouble(1.0));
                if (probs[i] <= this.lowerLimitChance) {
                    probs[i] = this.lowerLimitChance;
                }
                if (!(probs[i] >= 1.0)) continue;
                probs[i] = 1.0;
            }
            this.crossoverMixer.normalizeWeights();
        }
        InterfaceCrossover[] crossover = this.crossoverMixer.getSelectedCrossers();
        double pointer = RNG.randomFloat(0.0f, 1.0f);
        this.lastOperatorIndex = 0;
        for (double dum = probs[0]; pointer > dum && this.lastOperatorIndex < probs.length - 1; dum += probs[this.lastOperatorIndex]) {
            ++this.lastOperatorIndex;
        }
        if (this.lastOperatorIndex == probs.length) {
            this.lastOperatorIndex = RNG.randomInt(0, probs.length - 1);
        }
        indy1.putData(CROSSOVER_EA_MIXER_OPERATOR_KEY, this.lastOperatorIndex);
        for (int i = 0; i < partners.size(); ++i) {
            partners.getEAIndividual(i).putData(CROSSOVER_EA_MIXER_OPERATOR_KEY, this.lastOperatorIndex);
        }
        AbstractEAIndividual[] indies = crossover[this.lastOperatorIndex].mate(indy1, partners);
        this.maybeAdaptWeights(indies);
        return indies;
    }

    protected void maybeAdaptWeights(AbstractEAIndividual[] indies) {
    }

    public int getLastOperatorIndex() {
        return this.lastOperatorIndex;
    }

    @Override
    public String getStringRepresentation() {
        return "EA mutation mixer";
    }

    public String getName() {
        return "EA mutation mixer";
    }

    public void setCrossovers(PropertyCrossoverMixer d) {
        this.crossoverMixer = d;
    }

    public PropertyCrossoverMixer getCrossovers() {
        return this.crossoverMixer;
    }

    public String CrossoversTipText() {
        return "Choose the set of crossover operators.";
    }

    public void setUseSelfAdaption(boolean d) {
        this.useSelfAdaption = d;
    }

    public boolean getUseSelfAdaption() {
        return this.useSelfAdaption;
    }

    public String useSelfAdaptionTipText() {
        return "Use my implementation of self-adaption for the mutation mixer.";
    }

    public void setLowerLimitChance(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.lowerLimitChance = d;
    }

    public double getLowerLimitChance() {
        return this.lowerLimitChance;
    }

    public String lowerLimitChanceTipText() {
        return "Set the lower limit for the mutation chance.";
    }

    public void setTau1(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.tau1 = d;
    }

    public double getTau1() {
        return this.tau1;
    }

    public String tau1TipText() {
        return "Set the value for tau1.";
    }

    @Override
    public int getEvaluations() {
        int numEvals = 0;
        InterfaceCrossover[] crossers = this.crossoverMixer.getSelectedCrossers();
        for (int i = 0; i < crossers.length; ++i) {
            if (!(crossers[i] instanceof InterfaceEvaluatingCrossoverOperator)) continue;
            numEvals += ((InterfaceEvaluatingCrossoverOperator)crossers[i]).getEvaluations();
        }
        return numEvals;
    }

    @Override
    public void resetEvaluations() {
        InterfaceCrossover[] crossers = this.crossoverMixer.getSelectedCrossers();
        for (int i = 0; i < crossers.length; ++i) {
            if (!(crossers[i] instanceof InterfaceEvaluatingCrossoverOperator)) continue;
            ((InterfaceEvaluatingCrossoverOperator)crossers[i]).resetEvaluations();
        }
    }
}

