/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is an arithmetical crossover between m ES individuals.")
public class CrossoverESArithmetical
implements InterfaceCrossover,
Serializable {
    private InterfaceOptimizationProblem optimizationProblem;

    public CrossoverESArithmetical() {
    }

    public CrossoverESArithmetical(CrossoverESArithmetical c) {
        this.optimizationProblem = c.optimizationProblem;
    }

    @Override
    public Object clone() {
        return new CrossoverESArithmetical(this);
    }

    @Override
    public AbstractEAIndividual[] mate(AbstractEAIndividual indy1, Population partners) {
        int i;
        AbstractEAIndividual[] result = null;
        result = new AbstractEAIndividual[partners.size() + 1];
        result[0] = (AbstractEAIndividual)indy1.clone();
        for (i = 0; i < partners.size(); ++i) {
            result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
        }
        if (indy1 instanceof InterfaceESIndividual && partners.get(0) instanceof InterfaceESIndividual) {
            int i2;
            double[][] parents = new double[partners.size() + 1][];
            double[][] children = new double[partners.size() + 1][];
            for (int i3 = 0; i3 < result.length; ++i3) {
                parents[i3] = new double[((InterfaceESIndividual)((Object)result[i3])).getDGenotype().length];
                children[i3] = new double[parents[i3].length];
                System.arraycopy(((InterfaceESIndividual)((Object)result[i3])).getDGenotype(), 0, parents[i3], 0, parents[i3].length);
                System.arraycopy(((InterfaceESIndividual)((Object)result[i3])).getDGenotype(), 0, children[i3], 0, parents[i3].length);
            }
            double[] alpha = new double[parents.length];
            double sum = 0.0;
            for (i2 = 0; i2 < children.length; ++i2) {
                int j;
                sum = 0.0;
                for (j = 0; j < alpha.length; ++j) {
                    alpha[j] = RNG.randomDouble(0.0, 1.0);
                    sum += alpha[j];
                }
                j = 0;
                while (j < alpha.length) {
                    int n = j++;
                    alpha[n] = alpha[n] / sum;
                }
                for (int n = 0; n < children[i2].length; ++n) {
                    children[i2][n] = 0.0;
                    for (int m = 0; m < parents.length; ++m) {
                        double[] dArray = children[i2];
                        int n2 = n;
                        dArray[n2] = dArray[n2] + alpha[m] * parents[m][n];
                    }
                }
            }
            for (i2 = 0; i2 < result.length; ++i2) {
                ((InterfaceESIndividual)((Object)result[i2])).setDGenotype(children[i2]);
            }
        }
        for (i = 0; i < result.length; ++i) {
            result[i].getMutationOperator().crossoverOnStrategyParameters(indy1, partners);
        }
        return result;
    }

    @Override
    public boolean equals(Object crossover) {
        return crossover instanceof CrossoverESArithmetical;
    }

    @Override
    public void init(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        this.optimizationProblem = opt;
    }

    @Override
    public String getStringRepresentation() {
        return this.getName();
    }

    public String getName() {
        return "ES arithmetical crossover";
    }
}

