/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is a discrete one-point crossover between m ES individuals.")
public class CrossoverESDefault
implements InterfaceCrossover,
Serializable {
    private InterfaceOptimizationProblem optimizationProblem;

    public CrossoverESDefault() {
    }

    public CrossoverESDefault(CrossoverESDefault c) {
        this.optimizationProblem = c.optimizationProblem;
    }

    @Override
    public Object clone() {
        return new CrossoverESDefault(this);
    }

    @Override
    public AbstractEAIndividual[] mate(AbstractEAIndividual indy1, Population partners) {
        int i;
        AbstractEAIndividual[] result = null;
        result = new AbstractEAIndividual[partners.size() + 1];
        result[0] = (AbstractEAIndividual)indy1.clone();
        for (i = 0; i < partners.size(); ++i) {
            result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
        }
        if (partners == null || partners.size() == 0) {
            throw new RuntimeException("Error, empty partner population for crossover!");
        }
        if (indy1 instanceof InterfaceESIndividual && partners.get(0) instanceof InterfaceESIndividual) {
            int i2;
            int crossoverpoint = RNG.randomInt(0, ((InterfaceESIndividual)((Object)indy1)).getDGenotype().length - 1);
            boolean switcher = RNG.randomBoolean();
            double[][] parents = new double[result.length][];
            double[][] children = new double[result.length][];
            for (i2 = 0; i2 < result.length; ++i2) {
                parents[i2] = new double[((InterfaceESIndividual)((Object)result[i2])).getDGenotype().length];
                children[i2] = new double[parents[i2].length];
                System.arraycopy(((InterfaceESIndividual)((Object)result[i2])).getDGenotype(), 0, parents[i2], 0, parents[i2].length);
                System.arraycopy(((InterfaceESIndividual)((Object)result[i2])).getDGenotype(), 0, children[i2], 0, parents[i2].length);
            }
            for (i2 = 0; i2 < children[0].length; ++i2) {
                if (i2 < crossoverpoint ^ switcher) continue;
                for (int j = 0; j < children.length - 1; ++j) {
                    children[j][i2] = parents[j + 1][i2];
                }
                children[children.length - 1][i2] = parents[0][i2];
            }
            for (i2 = 0; i2 < result.length; ++i2) {
                ((InterfaceESIndividual)((Object)result[i2])).setDGenotype(children[i2]);
            }
        }
        for (i = 0; i < result.length; ++i) {
            result[i].getMutationOperator().crossoverOnStrategyParameters(indy1, partners);
        }
        return result;
    }

    @Override
    public boolean equals(Object crossover) {
        return crossover instanceof CrossoverESDefault;
    }

    @Override
    public void init(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        this.optimizationProblem = opt;
    }

    @Override
    public String getStringRepresentation() {
        return this.getName();
    }

    public String getName() {
        return "ES discrete one-point crossover";
    }
}

