/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The flat crossover initializes the values within the extreme values.")
public class CrossoverESFlat
implements InterfaceCrossover,
Serializable {
    private InterfaceOptimizationProblem optimizationProblem;

    public CrossoverESFlat() {
    }

    public CrossoverESFlat(CrossoverESFlat c) {
        this.optimizationProblem = c.optimizationProblem;
    }

    @Override
    public Object clone() {
        return new CrossoverESFlat(this);
    }

    @Override
    public AbstractEAIndividual[] mate(AbstractEAIndividual indy1, Population partners) {
        int i;
        AbstractEAIndividual[] result = null;
        result = new AbstractEAIndividual[partners.size() + 1];
        result[0] = (AbstractEAIndividual)indy1.clone();
        for (i = 0; i < partners.size(); ++i) {
            result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
        }
        if (indy1 instanceof InterfaceESIndividual && partners.get(0) instanceof InterfaceESIndividual) {
            int j;
            double[][] parents = new double[partners.size() + 1][];
            double[][] children = new double[partners.size() + 1][];
            double[][] extremeValues = new double[((InterfaceESIndividual)((Object)result[0])).getDGenotype().length][2];
            for (i = 0; i < extremeValues.length; ++i) {
                extremeValues[i][0] = Double.MAX_VALUE;
                extremeValues[i][1] = Double.MIN_VALUE;
            }
            for (i = 0; i < result.length; ++i) {
                parents[i] = new double[((InterfaceESIndividual)((Object)result[i])).getDGenotype().length];
                children[i] = new double[parents[i].length];
                System.arraycopy(((InterfaceESIndividual)((Object)result[i])).getDGenotype(), 0, parents[i], 0, parents[i].length);
                System.arraycopy(((InterfaceESIndividual)((Object)result[i])).getDGenotype(), 0, children[i], 0, parents[i].length);
                for (j = 0; j < parents[i].length; ++j) {
                    extremeValues[j][0] = Math.min(extremeValues[j][0], parents[i][j]);
                    extremeValues[j][1] = Math.max(extremeValues[j][1], parents[i][j]);
                }
            }
            for (i = 0; i < children.length; ++i) {
                for (j = 0; j < children[i].length; ++j) {
                    children[i][j] = RNG.randomDouble(extremeValues[j][0], extremeValues[j][1]);
                }
            }
            for (i = 0; i < result.length; ++i) {
                ((InterfaceESIndividual)((Object)result[i])).setDGenotype(children[i]);
            }
        }
        for (i = 0; i < result.length; ++i) {
            result[i].getMutationOperator().crossoverOnStrategyParameters(indy1, partners);
        }
        return result;
    }

    @Override
    public boolean equals(Object crossover) {
        return crossover instanceof CrossoverESFlat;
    }

    @Override
    public void init(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        this.optimizationProblem = opt;
    }

    @Override
    public String getStringRepresentation() {
        return this.getName();
    }

    public String getName() {
        return "ES flat crossover";
    }
}

