/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is an intermediate crossover between m ES individuals.")
public class CrossoverESIntermediate
implements InterfaceCrossover,
Serializable {
    private InterfaceOptimizationProblem optimizationProblem;

    public CrossoverESIntermediate() {
    }

    public CrossoverESIntermediate(CrossoverESIntermediate c) {
        this.optimizationProblem = c.optimizationProblem;
    }

    @Override
    public Object clone() {
        return new CrossoverESIntermediate(this);
    }

    @Override
    public AbstractEAIndividual[] mate(AbstractEAIndividual indy1, Population partners) {
        int i;
        AbstractEAIndividual[] result = null;
        result = new AbstractEAIndividual[partners.size() + 1];
        result[0] = (AbstractEAIndividual)indy1.clone();
        for (i = 0; i < partners.size(); ++i) {
            result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
        }
        if (indy1 instanceof InterfaceESIndividual && partners.get(0) instanceof InterfaceESIndividual) {
            int i2;
            double[][] parents = new double[partners.size() + 1][];
            double[][] children = new double[partners.size() + 1][];
            for (i2 = 0; i2 < result.length; ++i2) {
                parents[i2] = new double[((InterfaceESIndividual)((Object)result[i2])).getDGenotype().length];
                children[i2] = new double[parents[i2].length];
                System.arraycopy(((InterfaceESIndividual)((Object)result[i2])).getDGenotype(), 0, parents[i2], 0, parents[i2].length);
                System.arraycopy(((InterfaceESIndividual)((Object)result[i2])).getDGenotype(), 0, children[i2], 0, parents[i2].length);
            }
            for (i2 = 0; i2 < children[0].length; ++i2) {
                int j;
                double intermediate = 0.0;
                for (j = 0; j < parents.length; ++j) {
                    intermediate += parents[j][i2];
                }
                intermediate /= (double)parents.length;
                for (j = 0; j < children.length; ++j) {
                    children[j][i2] = intermediate;
                }
            }
            for (i2 = 0; i2 < result.length; ++i2) {
                ((InterfaceESIndividual)((Object)result[i2])).setDGenotype(children[i2]);
            }
        }
        for (i = 0; i < result.length; ++i) {
            result[i].getMutationOperator().crossoverOnStrategyParameters(indy1, partners);
        }
        return result;
    }

    @Override
    public boolean equals(Object crossover) {
        return crossover instanceof CrossoverESIntermediate;
    }

    @Override
    public void init(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        this.optimizationProblem = opt;
    }

    @Override
    public String getStringRepresentation() {
        return this.getName();
    }

    public String getName() {
        return "ES intermediate crossover";
    }
}

