/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is a discrete n-point crossover between m ES individuals.")
public class CrossoverESNPointDiscrete
implements InterfaceCrossover,
Serializable {
    private InterfaceOptimizationProblem optimizationProblem;
    private int numberOfCrossovers = 3;

    public CrossoverESNPointDiscrete() {
    }

    public CrossoverESNPointDiscrete(CrossoverESNPointDiscrete mutator) {
        this.optimizationProblem = mutator.optimizationProblem;
        this.numberOfCrossovers = mutator.numberOfCrossovers;
    }

    @Override
    public Object clone() {
        return new CrossoverESNPointDiscrete(this);
    }

    @Override
    public AbstractEAIndividual[] mate(AbstractEAIndividual indy1, Population partners) {
        int i;
        AbstractEAIndividual[] result = null;
        result = new AbstractEAIndividual[partners.size() + 1];
        result[0] = (AbstractEAIndividual)indy1.clone();
        for (i = 0; i < partners.size(); ++i) {
            result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
        }
        if (indy1 instanceof InterfaceESIndividual && partners.get(0) instanceof InterfaceESIndividual) {
            int i2;
            int length = ((InterfaceESIndividual)((Object)result[0])).getDGenotype().length;
            int mixer = RNG.randomInt(0, partners.size());
            int[] crossoverPoints = new int[this.numberOfCrossovers];
            double[][] parents = new double[partners.size() + 1][];
            double[][] children = new double[partners.size() + 1][];
            for (i2 = 0; i2 < result.length; ++i2) {
                parents[i2] = new double[((InterfaceESIndividual)((Object)result[i2])).getDGenotype().length];
                children[i2] = new double[parents[i2].length];
                System.arraycopy(((InterfaceESIndividual)((Object)result[i2])).getDGenotype(), 0, parents[i2], 0, parents[i2].length);
                System.arraycopy(((InterfaceESIndividual)((Object)result[i2])).getDGenotype(), 0, children[i2], 0, parents[i2].length);
            }
            for (i2 = 0; i2 < this.numberOfCrossovers; ++i2) {
                crossoverPoints[i2] = RNG.randomInt(0, length - 1);
            }
            for (i2 = 0; i2 < length; ++i2) {
                int j;
                for (j = 0; j < this.numberOfCrossovers; ++j) {
                    if (i2 != crossoverPoints[j]) continue;
                    ++mixer;
                }
                for (j = 0; j < children.length; ++j) {
                    children[j][i2] = parents[(j + mixer) % parents.length][i2];
                }
            }
            for (i2 = 0; i2 < result.length; ++i2) {
                ((InterfaceESIndividual)((Object)result[i2])).setDGenotype(children[i2]);
            }
        }
        for (i = 0; i < result.length; ++i) {
            result[i].getMutationOperator().crossoverOnStrategyParameters(indy1, partners);
        }
        return result;
    }

    @Override
    public boolean equals(Object crossover) {
        if (crossover instanceof CrossoverESNPointDiscrete) {
            CrossoverESNPointDiscrete cross = (CrossoverESNPointDiscrete)crossover;
            return this.numberOfCrossovers == cross.numberOfCrossovers;
        }
        return false;
    }

    @Override
    public void init(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        this.optimizationProblem = opt;
    }

    @Override
    public String getStringRepresentation() {
        return this.getName();
    }

    public String getName() {
        return "ES discrete n-point crossover";
    }

    public void setNumberOfCrossovers(int crossovers) {
        if (crossovers < 0) {
            crossovers = 0;
        }
        this.numberOfCrossovers = crossovers;
    }

    public int getNumberOfCrossovers() {
        return this.numberOfCrossovers;
    }

    public String numberOfCrossoversTipText() {
        return "The number of crossoverpoints.";
    }
}

