/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.crossover.CrossoverESUNDX;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.population.Population;
import eva2.problems.F1Problem;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.Mathematics;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.ArrayList;

@Description(value="This is the Parent Centric Crossover (PCX).")
public class CrossoverESPCX
implements InterfaceCrossover,
Serializable {
    private InterfaceOptimizationProblem optimizationProblem;
    private double eta = 0.2;
    private double zeta = 0.2;

    public CrossoverESPCX() {
    }

    public CrossoverESPCX(CrossoverESPCX c) {
        this.optimizationProblem = c.optimizationProblem;
        this.eta = c.eta;
        this.zeta = c.zeta;
    }

    @Override
    public Object clone() {
        return new CrossoverESPCX(this);
    }

    @Override
    public AbstractEAIndividual[] mate(AbstractEAIndividual indy1, Population partners) {
        int i;
        AbstractEAIndividual[] result = null;
        result = new AbstractEAIndividual[partners.size() + 1];
        result[0] = (AbstractEAIndividual)indy1.clone();
        for (i = 0; i < partners.size(); ++i) {
            result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
        }
        if (indy1 instanceof InterfaceESIndividual && partners.get(0) instanceof InterfaceESIndividual) {
            int i2;
            double[][] parents = new double[partners.size() + 1][];
            double[][] children = new double[partners.size() + 1][];
            for (int i3 = 0; i3 < result.length; ++i3) {
                parents[i3] = new double[((InterfaceESIndividual)((Object)result[i3])).getDGenotype().length];
                children[i3] = new double[parents[i3].length];
                System.arraycopy(((InterfaceESIndividual)((Object)result[i3])).getDGenotype(), 0, parents[i3], 0, parents[i3].length);
                System.arraycopy(((InterfaceESIndividual)((Object)result[i3])).getDGenotype(), 0, children[i3], 0, parents[i3].length);
            }
            double[] g = Mathematics.meanVect(parents);
            for (i2 = 0; i2 < children.length; ++i2) {
                int j;
                double[] tmpD = Mathematics.getVectorFromTo(g, parents[i2]);
                ArrayList subSpace = this.getCoordinates(g, i2, parents);
                for (j = 0; j < parents[i2].length; ++j) {
                    children[i2][j] = parents[i2][j];
                    double[] dArray = children[i2];
                    int n = j;
                    dArray[n] = dArray[n] + RNG.gaussianDouble(this.zeta) * tmpD[j];
                }
                for (j = 1; j < subSpace.size(); ++j) {
                    tmpD = (double[])subSpace.get(j);
                    double w = RNG.gaussianDouble(this.zeta);
                    children[i2] = Mathematics.vvAdd(children[i2], Mathematics.svMult(w, tmpD));
                }
            }
            for (i2 = 0; i2 < result.length; ++i2) {
                ((InterfaceESIndividual)((Object)result[i2])).setDGenotype(children[i2]);
            }
        }
        for (i = 0; i < result.length; ++i) {
            result[i].getMutationOperator().crossoverOnStrategyParameters(indy1, partners);
        }
        return result;
    }

    private ArrayList getCoordinates(double[] mean, int index, double[][] parents) {
        double[] toro;
        ArrayList<double[]> result = new ArrayList<double[]>();
        double[] tmpVec = Mathematics.vvSub(parents[index], mean);
        result.add(tmpVec);
        for (int i = 0; i < parents.length; ++i) {
            if (i == index || !this.isValidVec(tmpVec = Mathematics.vvSub(parents[i], mean))) continue;
            for (int j = 0; j < result.size(); ++j) {
                toro = (double[])result.get(j);
                double tmpD = Mathematics.vvMult(toro, tmpVec) / Mathematics.vvMult(toro, toro);
                toro = Mathematics.svMult(tmpD, toro);
                tmpVec = Mathematics.vvSub(tmpVec, toro);
            }
            if (!this.isValidVec(tmpVec)) continue;
            result.add(tmpVec);
        }
        for (int i = 1; i < result.size(); ++i) {
            toro = (double[])result.get(i);
            Mathematics.normVect(toro, toro);
            double tmpMean = 0.0;
            for (int j = 0; j < parents.length; ++j) {
                if (j == index) continue;
                tmpMean += Math.abs(Mathematics.vvMult(toro, Mathematics.vvSub(parents[j], mean)));
            }
            toro = Mathematics.svMult(tmpMean /= (double)(result.size() - 1), toro);
            result.set(i, toro);
        }
        return result;
    }

    private boolean isValidVec(double[] d) {
        double sum = 0.0;
        for (int i = 0; i < d.length; ++i) {
            if (Double.isNaN(d[i])) {
                return false;
            }
            sum += Math.pow(d[i], 2.0);
        }
        if (Double.isNaN(sum)) {
            return false;
        }
        return Math.abs(sum) >= 1.0E-18;
    }

    @Override
    public boolean equals(Object crossover) {
        return crossover instanceof CrossoverESUNDX;
    }

    @Override
    public void init(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        this.optimizationProblem = opt;
    }

    public static void main(String[] args) {
        boolean plotFlag = true;
        Plot plot = null;
        Population pop = new Population();
        double[] tmpD = new double[2];
        F1Problem prob = new F1Problem();
        int n = 2;
        ESIndividualDoubleData indy1 = new ESIndividualDoubleData();
        double[][] range = new double[n][2];
        for (int i = 0; i < range.length; ++i) {
            range[i][0] = -2.0;
            range[i][1] = 2.0;
        }
        indy1.setDoubleDataLength(n);
        indy1.setDoubleRange(range);
        ESIndividualDoubleData indy2 = (ESIndividualDoubleData)indy1.clone();
        ESIndividualDoubleData indy3 = (ESIndividualDoubleData)indy1.clone();
        ESIndividualDoubleData indy4 = (ESIndividualDoubleData)indy1.clone();
        tmpD[0] = 0.0;
        tmpD[1] = 1.0;
        indy1.initByValue(tmpD, prob);
        tmpD[0] = -1.0;
        tmpD[1] = 1.0;
        indy2.initByValue(tmpD, prob);
        tmpD[0] = 1.0;
        tmpD[1] = -1.0;
        indy3.initByValue(tmpD, prob);
        tmpD[0] = 0.5;
        tmpD[1] = 1.0;
        indy4.initByValue(tmpD, prob);
        pop = new Population();
        pop.add(indy2);
        pop.add(indy3);
        tmpD[0] = 1.0;
        tmpD[1] = 1.0;
        if (plotFlag) {
            plot = new Plot("SBX Test", "x", "y", true);
            tmpD = indy1.getDoubleData();
            plot.setUnconnectedPoint(tmpD[0], tmpD[1], 0);
            tmpD = indy2.getDoubleData();
            plot.setUnconnectedPoint(tmpD[0], tmpD[1], 0);
            tmpD = indy3.getDoubleData();
            plot.setUnconnectedPoint(tmpD[0], tmpD[1], 0);
            tmpD = indy4.getDoubleData();
            plot.setUnconnectedPoint(-2.0, -2.0, 0);
            plot.setUnconnectedPoint(2.0, 2.0, 0);
            plot.setUnconnectedPoint(2.0, 2.0, 0);
        }
        CrossoverESPCX cross = new CrossoverESPCX();
        cross.eta = 0.2;
        cross.zeta = 0.2;
        for (int i = 0; i < 1; ++i) {
            AbstractEAIndividual[] offsprings = cross.mate(indy1, pop);
            for (int j = 0; j < offsprings.length; ++j) {
                tmpD = ((ESIndividualDoubleData)offsprings[j]).getDoubleData();
                if (!plotFlag) continue;
                plot.setUnconnectedPoint(tmpD[0], tmpD[1], 1);
            }
        }
    }

    @Override
    public String getStringRepresentation() {
        return this.getName();
    }

    public String getName() {
        return "ES PCX crossover";
    }

    public void setEta(double a) {
        if (a < 0.0) {
            a = 0.0;
        }
        this.eta = a;
    }

    public double getEta() {
        return this.eta;
    }

    public String etaTipText() {
        return "The Eta of PCX.";
    }

    public void setZeta(double a) {
        if (a < 0.0) {
            a = 0.0;
        }
        this.zeta = a;
    }

    public double getZeta() {
        return this.zeta;
    }

    public String zetaTipText() {
        return "The Zeta of PCX.";
    }
}

