/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.population.Population;
import eva2.problems.F1Problem;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The SBX crossover simulates a binary crossover (works only for two partners!).")
public class CrossoverESSBX
implements InterfaceCrossover,
Serializable {
    private InterfaceOptimizationProblem optimizationProblem;
    private double eta = 0.2;

    public CrossoverESSBX() {
    }

    public CrossoverESSBX(double eta) {
        this.eta = eta;
    }

    public CrossoverESSBX(CrossoverESSBX c) {
        this.optimizationProblem = c.optimizationProblem;
        this.eta = c.eta;
    }

    @Override
    public Object clone() {
        return new CrossoverESSBX(this);
    }

    @Override
    public AbstractEAIndividual[] mate(AbstractEAIndividual indy1, Population partners) {
        int i;
        AbstractEAIndividual[] result = null;
        result = new AbstractEAIndividual[partners.size() + 1];
        result[0] = (AbstractEAIndividual)indy1.clone();
        for (i = 0; i < partners.size(); ++i) {
            result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
        }
        if (indy1 instanceof InterfaceESIndividual && partners.get(0) instanceof InterfaceESIndividual) {
            double[][] parents = new double[partners.size() + 1][];
            double[][] children = new double[partners.size() + 1][];
            for (i = 0; i < result.length; ++i) {
                parents[i] = new double[((InterfaceESIndividual)((Object)result[i])).getDGenotype().length];
                children[i] = new double[parents[i].length];
                System.arraycopy(((InterfaceESIndividual)((Object)result[i])).getDGenotype(), 0, parents[i], 0, parents[i].length);
                System.arraycopy(((InterfaceESIndividual)((Object)result[i])).getDGenotype(), 0, children[i], 0, parents[i].length);
            }
            for (i = 0; i < children[0].length; ++i) {
                double u = RNG.randomDouble(0.0, 1.0);
                double beta = u <= 0.5 ? Math.pow(2.0 * u, 1.0 / (this.eta + 1.0)) : Math.pow(0.5 / (1.0 - u), 1.0 / (this.eta + 1.0));
                children[0][i] = 0.5 * ((1.0 + beta) * parents[0][i] + (1.0 - beta) * parents[1][i]);
                children[1][i] = 0.5 * ((1.0 - beta) * parents[0][i] + (1.0 + beta) * parents[1][i]);
            }
            for (i = 0; i < result.length; ++i) {
                ((InterfaceESIndividual)((Object)result[i])).setDGenotype(children[i]);
            }
        }
        for (i = 0; i < result.length; ++i) {
            result[i].getMutationOperator().crossoverOnStrategyParameters(indy1, partners);
        }
        return result;
    }

    @Override
    public boolean equals(Object crossover) {
        if (crossover instanceof CrossoverESSBX) {
            CrossoverESSBX cross = (CrossoverESSBX)crossover;
            return this.eta == cross.eta;
        }
        return false;
    }

    @Override
    public void init(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        this.optimizationProblem = opt;
    }

    public static void main(String[] args) {
        Population pop = new Population();
        double[] tmpD = new double[2];
        F1Problem prob = new F1Problem();
        ESIndividualDoubleData indy1 = new ESIndividualDoubleData();
        double[][] range = new double[2][2];
        range[0][0] = -2.0;
        range[0][1] = 2.0;
        range[1][0] = -2.0;
        range[1][1] = 2.0;
        indy1.setDoubleDataLength(2);
        indy1.setDoubleRange(range);
        ESIndividualDoubleData indy2 = (ESIndividualDoubleData)indy1.clone();
        ESIndividualDoubleData indy3 = (ESIndividualDoubleData)indy1.clone();
        tmpD[0] = 0.5;
        tmpD[1] = -0.5;
        indy1.initByValue(tmpD, prob);
        tmpD[0] = -0.5;
        tmpD[1] = 0.5;
        indy2.initByValue(tmpD, prob);
        tmpD[0] = -0.5;
        tmpD[1] = 1.0;
        indy3.initByValue(tmpD, prob);
        pop.add(indy2);
        pop.add(indy3);
        tmpD[0] = 1.0;
        tmpD[1] = 1.0;
        Plot plot = new Plot("SBX Test", "x", "y", true);
        tmpD = indy1.getDoubleData();
        plot.setUnconnectedPoint(tmpD[0], tmpD[1], 0);
        tmpD = indy2.getDoubleData();
        plot.setUnconnectedPoint(tmpD[0], tmpD[1], 0);
        tmpD = indy3.getDoubleData();
        plot.setUnconnectedPoint(tmpD[0], tmpD[1], 0);
        plot.setUnconnectedPoint(-2.0, -2.0, 0);
        plot.setUnconnectedPoint(2.0, 2.0, 0);
        plot.setUnconnectedPoint(2.0, 2.0, 0);
        CrossoverESSBX cross = new CrossoverESSBX();
        cross.eta = 0.2;
        for (int i = 0; i < 5000; ++i) {
            AbstractEAIndividual[] offsprings = cross.mate(indy1, pop);
            for (int j = 0; j < offsprings.length; ++j) {
                tmpD = ((ESIndividualDoubleData)offsprings[j]).getDoubleData();
                plot.setUnconnectedPoint(tmpD[0], tmpD[1], 1);
            }
        }
    }

    @Override
    public String getStringRepresentation() {
        return this.getName();
    }

    public String getName() {
        return "ES SBX crossover";
    }

    public void setEta(double a) {
        if (a < 0.0) {
            a = 0.0;
        }
        this.eta = a;
    }

    public double getEta() {
        return this.eta;
    }

    public String etaTipText() {
        return "Set the Eta_c value (the larger the value, the more restricted the search).";
    }
}

