/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.population.Population;
import eva2.problems.F1Problem;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.Mathematics;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is the Simplex Crossover (SPX).")
public class CrossoverESSPX
implements InterfaceCrossover,
Serializable {
    private InterfaceOptimizationProblem optimizationProblem;
    private double epsilon = 1.2;

    public CrossoverESSPX() {
    }

    public CrossoverESSPX(CrossoverESSPX c) {
        this.optimizationProblem = c.optimizationProblem;
        this.epsilon = c.epsilon;
    }

    @Override
    public Object clone() {
        return new CrossoverESSPX(this);
    }

    @Override
    public AbstractEAIndividual[] mate(AbstractEAIndividual indy1, Population partners) {
        int i;
        AbstractEAIndividual[] result = null;
        result = new AbstractEAIndividual[partners.size() + 1];
        result[0] = (AbstractEAIndividual)indy1.clone();
        for (i = 0; i < partners.size(); ++i) {
            result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
        }
        if (indy1 instanceof InterfaceESIndividual && partners.get(0) instanceof InterfaceESIndividual) {
            int i2;
            double[][] parents = new double[partners.size() + 1][];
            double[][] children = new double[partners.size() + 1][];
            for (int i3 = 0; i3 < result.length; ++i3) {
                parents[i3] = new double[((InterfaceESIndividual)((Object)result[i3])).getDGenotype().length];
                children[i3] = new double[parents[i3].length];
                System.arraycopy(((InterfaceESIndividual)((Object)result[i3])).getDGenotype(), 0, parents[i3], 0, parents[i3].length);
                System.arraycopy(((InterfaceESIndividual)((Object)result[i3])).getDGenotype(), 0, children[i3], 0, parents[i3].length);
            }
            double[] g = Mathematics.meanVect(parents);
            double[][] Y = new double[parents.length][];
            for (i2 = 0; i2 < parents.length; ++i2) {
                Y[i2] = Mathematics.vvAdd(g, Mathematics.svMult(this.epsilon, Mathematics.vvSub(parents[i2], g)));
            }
            for (i2 = 0; i2 < children.length; ++i2) {
                double[][] C = new double[Y.length][];
                C[0] = Mathematics.zeroes(parents[0].length);
                for (int j = 1; j < Y.length; ++j) {
                    double r = Math.pow(RNG.randomDouble(0.0, 1.0), 1.0 / (double)j);
                    C[j] = Mathematics.vvAdd(Y[j - 1], C[j - 1]);
                    C[j] = Mathematics.vvSub(C[j], Y[j]);
                    C[j] = Mathematics.svMult(r, C[j]);
                }
                children[i2] = Mathematics.vvAdd(Y[Y.length - 1], C[C.length - 1]);
            }
            for (i2 = 0; i2 < result.length; ++i2) {
                ((InterfaceESIndividual)((Object)result[i2])).setDGenotype(children[i2]);
            }
        }
        for (i = 0; i < result.length; ++i) {
            result[i].getMutationOperator().crossoverOnStrategyParameters(indy1, partners);
        }
        return result;
    }

    @Override
    public boolean equals(Object crossover) {
        return crossover instanceof CrossoverESSPX;
    }

    @Override
    public void init(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        this.optimizationProblem = opt;
    }

    public static void main(String[] args) {
        boolean plotFlag = true;
        Plot plot = null;
        Population pop = new Population();
        double[] tmpD = new double[2];
        F1Problem prob = new F1Problem();
        int n = 2;
        RNG.setRandomSeed(1L);
        ESIndividualDoubleData indy1 = new ESIndividualDoubleData();
        double[][] range = new double[n][2];
        for (int i = 0; i < range.length; ++i) {
            range[i][0] = -2.0;
            range[i][1] = 2.0;
        }
        indy1.setDoubleDataLength(n);
        indy1.setDoubleRange(range);
        ESIndividualDoubleData indy2 = (ESIndividualDoubleData)indy1.clone();
        ESIndividualDoubleData indy3 = (ESIndividualDoubleData)indy1.clone();
        ESIndividualDoubleData indy4 = (ESIndividualDoubleData)indy1.clone();
        tmpD[0] = -1.0;
        tmpD[1] = -0.5;
        indy1.initByValue(tmpD, prob);
        tmpD[0] = -0.5;
        tmpD[1] = 0.5;
        indy2.initByValue(tmpD, prob);
        tmpD[0] = 0.5;
        tmpD[1] = -1.0;
        indy3.initByValue(tmpD, prob);
        tmpD[0] = 0.5;
        tmpD[1] = 1.0;
        indy4.initByValue(tmpD, prob);
        pop = new Population();
        pop.add(indy2);
        pop.add(indy3);
        tmpD[0] = 1.0;
        tmpD[1] = 1.0;
        if (plotFlag) {
            plot = new Plot("SBX Test", "x", "y", true);
            tmpD = indy1.getDoubleData();
            plot.setUnconnectedPoint(tmpD[0], tmpD[1], 0);
            tmpD = indy2.getDoubleData();
            plot.setUnconnectedPoint(tmpD[0], tmpD[1], 0);
            tmpD = indy3.getDoubleData();
            plot.setUnconnectedPoint(tmpD[0], tmpD[1], 0);
            tmpD = indy4.getDoubleData();
            plot.setUnconnectedPoint(-2.0, -2.0, 0);
            plot.setUnconnectedPoint(2.0, 2.0, 0);
            plot.setUnconnectedPoint(2.0, 2.0, 0);
        }
        CrossoverESSPX cross = new CrossoverESSPX();
        cross.epsilon = 1.2;
        for (int i = 0; i < 500; ++i) {
            AbstractEAIndividual[] offsprings = cross.mate(indy1, pop);
            for (int j = 0; j < offsprings.length; ++j) {
                tmpD = ((ESIndividualDoubleData)offsprings[j]).getDoubleData();
                if (!plotFlag) continue;
                plot.setUnconnectedPoint(tmpD[0], tmpD[1], 1);
            }
        }
    }

    @Override
    public String getStringRepresentation() {
        return this.getName();
    }

    public String getName() {
        return "ES SPX crossover";
    }

    public void setEpsilon(double a) {
        if (a < 0.0) {
            a = 0.0;
        }
        this.epsilon = a;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public String epsilonTipText() {
        return "The epsilon of SPX.";
    }
}

