/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.population.Population;
import eva2.problems.F1Problem;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.Mathematics;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.ArrayList;

@Description(value="This is the Unimodal Normally Distributed crossover (UNDX) by Ono and Kobayashi, 1997, typically uses more than two parents.")
public class CrossoverESUNDX
implements InterfaceCrossover,
Serializable {
    private InterfaceOptimizationProblem optimizationProblem;
    private double eta = 0.2;
    private double zeta = 0.2;

    public CrossoverESUNDX() {
    }

    public CrossoverESUNDX(CrossoverESUNDX c) {
        this.optimizationProblem = c.optimizationProblem;
        this.eta = c.eta;
        this.zeta = c.zeta;
    }

    @Override
    public Object clone() {
        return new CrossoverESUNDX(this);
    }

    @Override
    public AbstractEAIndividual[] mate(AbstractEAIndividual indy1, Population partners) {
        int i;
        AbstractEAIndividual[] result = null;
        result = new AbstractEAIndividual[partners.size() + 1];
        result[0] = (AbstractEAIndividual)indy1.clone();
        for (i = 0; i < partners.size(); ++i) {
            result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
        }
        if (indy1 instanceof InterfaceESIndividual && partners.get(0) instanceof InterfaceESIndividual) {
            int i2;
            double[][] parents = new double[partners.size() + 1][];
            double[][] children = new double[partners.size() + 1][];
            for (int i3 = 0; i3 < result.length; ++i3) {
                parents[i3] = new double[((InterfaceESIndividual)((Object)result[i3])).getDGenotype().length];
                children[i3] = new double[parents[i3].length];
                System.arraycopy(((InterfaceESIndividual)((Object)result[i3])).getDGenotype(), 0, parents[i3], 0, parents[i3].length);
                System.arraycopy(((InterfaceESIndividual)((Object)result[i3])).getDGenotype(), 0, children[i3], 0, parents[i3].length);
            }
            double[][] nParents = new double[parents.length - 1][];
            System.arraycopy(parents, 1, nParents, 0, parents.length - 1);
            double[] g = Mathematics.meanVect(nParents);
            ArrayList givenCoordinates = this.getGivenCoordinates(g, nParents);
            ArrayList missingCorrdinates = this.getMissingCoordinates(g, parents[0], givenCoordinates);
            for (i2 = 0; i2 < children.length; ++i2) {
                double w;
                double[] tmpD;
                int j;
                System.arraycopy(g, 0, children[i2], 0, g.length);
                for (j = 0; j < givenCoordinates.size(); ++j) {
                    tmpD = (double[])givenCoordinates.get(j);
                    w = RNG.gaussianDouble(this.zeta);
                    children[i2] = Mathematics.vvAdd(children[i2], Mathematics.svMult(w, tmpD));
                }
                for (j = 0; j < missingCorrdinates.size(); ++j) {
                    tmpD = (double[])missingCorrdinates.get(j);
                    w = RNG.gaussianDouble(this.eta);
                    children[i2] = Mathematics.vvAdd(children[i2], Mathematics.svMult(w, tmpD));
                }
            }
            for (i2 = 0; i2 < result.length; ++i2) {
                ((InterfaceESIndividual)((Object)result[i2])).setDGenotype(children[i2]);
            }
        }
        for (i = 0; i < result.length; ++i) {
            result[i].getMutationOperator().crossoverOnStrategyParameters(indy1, partners);
        }
        return result;
    }

    private ArrayList getGivenCoordinates(double[] mean, double[][] parents) {
        ArrayList<double[]> result = new ArrayList<double[]>();
        for (int i = 0; i < parents.length; ++i) {
            double[] tmpVec = Mathematics.vvSub(parents[i], mean);
            if (!Mathematics.isValidVector(tmpVec)) continue;
            if (result.size() == 0) {
                result.add(tmpVec);
                continue;
            }
            for (int j = 0; j < result.size(); ++j) {
                double[] toro = (double[])result.get(j);
                double tmpD = Mathematics.vvMult(toro, tmpVec) / Mathematics.vvMult(toro, toro);
                toro = Mathematics.svMult(tmpD, toro);
                tmpVec = Mathematics.vvSub(tmpVec, toro);
            }
            if (!Mathematics.isValidVector(tmpVec)) continue;
            result.add(tmpVec);
        }
        return result;
    }

    private ArrayList getMissingCoordinates(double[] mean, double[] theOther, ArrayList given) {
        ArrayList<double[]> result = new ArrayList<double[]>();
        ArrayList<Object> completeList = new ArrayList<Object>();
        for (int i = 0; i < given.size(); ++i) {
            completeList.add(given.get(i));
        }
        while (completeList.size() < mean.length) {
            double[] tmpVec = RNG.gaussianVector(mean.length, 1.0, true);
            if (!Mathematics.isValidVector(tmpVec)) continue;
            for (int j = 0; j < completeList.size(); ++j) {
                double[] toro = (double[])completeList.get(j);
                double tmpD = Mathematics.vvMult(toro, tmpVec) / Mathematics.vvMult(toro, toro);
                toro = Mathematics.svMult(tmpD, toro);
                tmpVec = Mathematics.vvSub(tmpVec, toro);
            }
            if (!Mathematics.isValidVector(tmpVec)) continue;
            Mathematics.normVect(tmpVec, tmpVec);
            tmpVec = Mathematics.svMult(Mathematics.vvMult(theOther, tmpVec), tmpVec);
            result.add(tmpVec);
            completeList.add(tmpVec);
        }
        return result;
    }

    @Override
    public boolean equals(Object crossover) {
        return crossover instanceof CrossoverESUNDX;
    }

    @Override
    public void init(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        this.optimizationProblem = opt;
    }

    public static void main(String[] args) {
        boolean plotFlag = true;
        Plot plot = null;
        Population pop = new Population();
        double[] tmpD = new double[2];
        F1Problem prob = new F1Problem();
        int n = 2;
        RNG.setRandomSeed(1L);
        ESIndividualDoubleData indy1 = new ESIndividualDoubleData();
        double[][] range = new double[n][2];
        for (int i = 0; i < range.length; ++i) {
            range[i][0] = -2.0;
            range[i][1] = 2.0;
        }
        indy1.setDoubleDataLength(n);
        indy1.setDoubleRange(range);
        ESIndividualDoubleData indy2 = (ESIndividualDoubleData)indy1.clone();
        ESIndividualDoubleData indy3 = (ESIndividualDoubleData)indy1.clone();
        ESIndividualDoubleData indy4 = (ESIndividualDoubleData)indy1.clone();
        tmpD[0] = -1.9;
        tmpD[1] = -1.8;
        indy1.initByValue(tmpD, prob);
        tmpD[0] = 1.0;
        tmpD[1] = 1.0;
        indy2.initByValue(tmpD, prob);
        tmpD[0] = -1.0;
        tmpD[1] = -1.0;
        indy3.initByValue(tmpD, prob);
        tmpD[0] = 0.5;
        tmpD[1] = 1.0;
        indy4.initByValue(tmpD, prob);
        pop = new Population();
        pop.add(indy2);
        pop.add(indy3);
        tmpD[0] = 1.0;
        tmpD[1] = 1.0;
        if (plotFlag) {
            plot = new Plot("SBX Test", "x", "y", true);
            tmpD = indy1.getDoubleData();
            plot.setUnconnectedPoint(tmpD[0], tmpD[1], 0);
            tmpD = indy2.getDoubleData();
            plot.setUnconnectedPoint(tmpD[0], tmpD[1], 0);
            tmpD = indy3.getDoubleData();
            plot.setUnconnectedPoint(tmpD[0], tmpD[1], 0);
            tmpD = indy4.getDoubleData();
            plot.setUnconnectedPoint(-2.0, -2.0, 0);
            plot.setUnconnectedPoint(2.0, 2.0, 0);
            plot.setUnconnectedPoint(2.0, 2.0, 0);
        }
        CrossoverESUNDX cross = new CrossoverESUNDX();
        cross.eta = 0.2;
        cross.zeta = 0.2;
        for (int i = 0; i < 500; ++i) {
            AbstractEAIndividual[] offsprings = cross.mate(indy1, pop);
            for (int j = 0; j < offsprings.length; ++j) {
                tmpD = ((ESIndividualDoubleData)offsprings[j]).getDoubleData();
                if (!plotFlag) continue;
                plot.setUnconnectedPoint(tmpD[0], tmpD[1], 1);
            }
        }
    }

    @Override
    public String getStringRepresentation() {
        return this.getName();
    }

    public String getName() {
        return "ES UNDX crossover";
    }

    public void setEta(double a) {
        if (a < 0.0) {
            a = 0.0;
        }
        this.eta = a;
    }

    public double getEta() {
        return this.eta;
    }

    public String etaTipText() {
        return "The Eta of UNDX (=0,35/Math,sqrt(n-l-2)).";
    }

    public void setZeta(double a) {
        if (a < 0.0) {
            a = 0.0;
        }
        this.zeta = a;
    }

    public double getZeta() {
        return this.zeta;
    }

    public String zetaTipText() {
        return "The Zeta of UNDX (=1/Math,sqrt(l-2)).";
    }
}

