/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.BitSet;

@Description(value="This is a one-point crossover between two individuals.")
public class CrossoverGADefault
implements InterfaceCrossover,
Serializable {
    private InterfaceOptimizationProblem optimizationProblem;

    public CrossoverGADefault() {
    }

    public CrossoverGADefault(CrossoverGADefault c) {
        this.optimizationProblem = c.optimizationProblem;
    }

    @Override
    public Object clone() {
        return new CrossoverGADefault(this);
    }

    @Override
    public AbstractEAIndividual[] mate(AbstractEAIndividual indy1, Population partners) {
        int i;
        AbstractEAIndividual[] result = null;
        result = new AbstractEAIndividual[partners.size() + 1];
        result[0] = (AbstractEAIndividual)indy1.clone();
        for (i = 0; i < partners.size(); ++i) {
            result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
        }
        if (partners.size() == 0) {
            return result;
        }
        if (indy1 instanceof InterfaceGAIndividual && partners.get(0) instanceof InterfaceGAIndividual) {
            int crossoverpoint = RNG.randomInt(0, ((InterfaceGAIndividual)((Object)indy1)).getGenotypeLength() - 1);
            BitSet[] tmpBitSets = new BitSet[]{((InterfaceGAIndividual)((Object)result[0])).getBGenotype(), ((InterfaceGAIndividual)((Object)result[1])).getBGenotype()};
            for (int i2 = crossoverpoint; i2 < ((InterfaceGAIndividual)((Object)result[0])).getGenotypeLength(); ++i2) {
                boolean tmpValue = tmpBitSets[0].get(i2);
                if (tmpBitSets[1].get(i2)) {
                    tmpBitSets[0].set(i2);
                } else {
                    tmpBitSets[0].clear(i2);
                }
                if (tmpValue) {
                    tmpBitSets[1].set(i2);
                    continue;
                }
                tmpBitSets[1].clear(i2);
            }
            ((InterfaceGAIndividual)((Object)result[0])).setBGenotype(tmpBitSets[0]);
            ((InterfaceGAIndividual)((Object)result[1])).setBGenotype(tmpBitSets[1]);
        }
        for (i = 0; i < result.length; ++i) {
            result[i].getMutationOperator().crossoverOnStrategyParameters(indy1, partners);
        }
        return result;
    }

    @Override
    public boolean equals(Object crossover) {
        return crossover instanceof CrossoverGADefault;
    }

    @Override
    public void init(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        this.optimizationProblem = opt;
    }

    @Override
    public String getStringRepresentation() {
        return this.getName();
    }

    public String getName() {
        return "GA default crossover";
    }
}

