/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.individuals.InterfaceGIIndividual;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.BitSet;

@Description(value="This is an n-point crossover between m individuals which may be binary or integer based.")
public class CrossoverGAGINPoint
implements InterfaceCrossover,
Serializable {
    private int numberOfCrossovers = 3;

    public CrossoverGAGINPoint() {
    }

    public CrossoverGAGINPoint(int nPoints) {
        this();
        this.setNumberOfCrossovers(nPoints);
    }

    public CrossoverGAGINPoint(CrossoverGAGINPoint mutator) {
        this.numberOfCrossovers = mutator.numberOfCrossovers;
    }

    @Override
    public Object clone() {
        return new CrossoverGAGINPoint(this);
    }

    protected Object getGenotype(AbstractEAIndividual individual) {
        Object genotype = null;
        genotype = individual instanceof InterfaceGAIndividual ? ((InterfaceGAIndividual)((Object)individual)).getBGenotype() : (Object)((InterfaceGIIndividual)((Object)individual)).getIGenotype();
        return genotype;
    }

    @Override
    public AbstractEAIndividual[] mate(AbstractEAIndividual individual, Population partners) {
        AbstractEAIndividual[] result = null;
        result = new AbstractEAIndividual[partners.size() + 1];
        result[0] = (AbstractEAIndividual)individual.clone();
        for (int i = 0; i < partners.size(); ++i) {
            result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
        }
        if (partners.size() == 0) {
            return result;
        }
        if (individual instanceof InterfaceGAIndividual || individual instanceof InterfaceGIIndividual) {
            int i;
            int length = this.getGenotypeLength(individual);
            Object[] origGenotypes = new Object[partners.size() + 1];
            Object[] newGenotypes = new Object[partners.size() + 1];
            origGenotypes[0] = this.getGenotype(individual);
            newGenotypes[0] = this.getGenotype(result[0]);
            for (int i2 = 0; i2 < partners.size(); ++i2) {
                origGenotypes[i2 + 1] = this.getGenotype(partners.getEAIndividual(i2));
                newGenotypes[i2 + 1] = this.getGenotype(result[i2 + 1]);
                length = Math.max(length, this.getGenotypeLength(partners.getEAIndividual(i2)));
            }
            int mixer = RNG.randomInt(0, partners.size());
            int[] crossoverPoints = this.getCrossoverPoints(length, this.numberOfCrossovers);
            for (i = 0; i < length; ++i) {
                int j;
                for (j = 0; j < this.numberOfCrossovers; ++j) {
                    if (i != crossoverPoints[j]) continue;
                    ++mixer;
                }
                for (j = 0; j < origGenotypes.length; ++j) {
                    this.exchangePos(origGenotypes, newGenotypes, (j + mixer) % origGenotypes.length, j, i);
                }
            }
            for (i = 0; i < result.length; ++i) {
                this.writeBack(result[i], newGenotypes[i]);
            }
        }
        return result;
    }

    private void writeBack(AbstractEAIndividual indy, Object newGenotype) {
        if (indy instanceof InterfaceGAIndividual) {
            ((InterfaceGAIndividual)((Object)indy)).setBGenotype((BitSet)newGenotype);
        } else {
            ((InterfaceGIIndividual)((Object)indy)).setIGenotype((int[])newGenotype);
        }
    }

    protected void exchangePos(Object[] origGenotypes, Object[] newGenotypes, int a, int b, int position) {
        this.setVal(newGenotypes[a], position, this.getVal(origGenotypes[b], position));
        this.setVal(newGenotypes[b], position, this.getVal(origGenotypes[a], position));
    }

    private void setVal(Object genotype, int position, Object val) {
        if (genotype instanceof BitSet) {
            ((BitSet)genotype).set(position, (Boolean)val);
        } else {
            ((int[])genotype)[position] = (Integer)val;
        }
    }

    private Object getVal(Object genotype, int position) {
        if (genotype instanceof BitSet) {
            return ((BitSet)genotype).get(position);
        }
        return ((int[])genotype)[position];
    }

    protected int getGenotypeLength(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceGAIndividual) {
            return ((InterfaceGAIndividual)((Object)individual)).getGenotypeLength();
        }
        return ((InterfaceGIIndividual)((Object)individual)).getGenotypeLength();
    }

    protected int[] getCrossoverPoints(int length, int numberOfCrossovers) {
        int[] crossoverPoints = new int[numberOfCrossovers];
        for (int i = 0; i < numberOfCrossovers; ++i) {
            crossoverPoints[i] = RNG.randomInt(0, length - 1);
        }
        return crossoverPoints;
    }

    @Override
    public boolean equals(Object crossover) {
        if (crossover instanceof CrossoverGAGINPoint) {
            CrossoverGAGINPoint cross = (CrossoverGAGINPoint)crossover;
            return this.numberOfCrossovers == cross.numberOfCrossovers;
        }
        return false;
    }

    @Override
    public void init(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public String getStringRepresentation() {
        return this.getName();
    }

    public String getName() {
        return "GA-GI N-Point Crossover";
    }

    public void setNumberOfCrossovers(int crossovers) {
        if (crossovers < 0) {
            crossovers = 0;
        }
        this.numberOfCrossovers = crossovers;
    }

    public int getNumberOfCrossovers() {
        return this.numberOfCrossovers;
    }

    public String numberOfCrossoversTipText() {
        return "The number of crossoverpoints.";
    }
}

