/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.optimization.operator.crossover.CrossoverGAGINPoint;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;

@Description(value="This is an n-point crossover between m individuals which also splits at certain segment limits. Crossover points are selected from multiples of the segment length.")
public class CrossoverGAGINPointSegmentwise
extends CrossoverGAGINPoint {
    int segmentLength = 8;

    public CrossoverGAGINPointSegmentwise() {
    }

    public CrossoverGAGINPointSegmentwise(CrossoverGAGINPointSegmentwise o) {
        super(o);
        this.segmentLength = o.segmentLength;
    }

    public CrossoverGAGINPointSegmentwise(int nPoints, int segmentLen) {
        super(nPoints);
        this.setSegmentLength(segmentLen);
    }

    @Override
    public Object clone() {
        return new CrossoverGAGINPointSegmentwise(this);
    }

    @Override
    public boolean equals(Object crossover) {
        if (super.equals(crossover) && crossover instanceof CrossoverGAGINPointSegmentwise) {
            return ((CrossoverGAGINPointSegmentwise)crossover).segmentLength == this.segmentLength;
        }
        return false;
    }

    @Override
    protected int[] getCrossoverPoints(int length, int numberOfCrossovers) {
        int[] cPoints = new int[numberOfCrossovers];
        for (int i = 0; i < numberOfCrossovers && i < length / this.segmentLength; ++i) {
            cPoints[i] = this.segmentLength * RNG.randomInt(length / this.segmentLength);
        }
        return cPoints;
    }

    @Override
    public String getName() {
        return "GA-GI N-Point segment-wise crossover";
    }

    public int getSegmentLength() {
        return this.segmentLength;
    }

    public void setSegmentLength(int segmentLength) {
        this.segmentLength = segmentLength;
    }

    public String segmentLengthTipText() {
        return "The fixed length of segments (genes) which are not split by crossover.";
    }
}

